/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import a.b.a.l;
import a.b.l.b;
import a.b.l.i;
import a.b.l.j;
import android.annotation.SuppressLint;
import android.net.ConnectivityManager;
import android.os.Build;
import java.util.ArrayList;
import java.util.Iterator;
import org.chromium.base.ContextUtils;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="net")
public class NetworkChangeNotifier {
    @SuppressLint(value={"StaticFieldLeak"})
    public static NetworkChangeNotifier sInstance;
    public static final /* synthetic */ boolean $assertionsDisabled;
    public final ArrayList<Long> mNativeChangeNotifiers = new ArrayList();
    public final l<ConnectionTypeObserver> mConnectionTypeObservers = new l();
    public final ConnectivityManager mConnectivityManager = (ConnectivityManager)ContextUtils.sApplicationContext.getSystemService("connectivity");
    public b mAutoDetector;
    public int mCurrentConnectionType = 0;

    public static NetworkChangeNotifier init() {
        if (sInstance == null) {
            sInstance = new NetworkChangeNotifier();
        }
        return sInstance;
    }

    public static boolean isInitialized() {
        return sInstance != null;
    }

    public static void resetInstanceForTests(NetworkChangeNotifier networkChangeNotifier) {
        sInstance = networkChangeNotifier;
    }

    public static NetworkChangeNotifier getInstance() {
        if (!$assertionsDisabled && sInstance == null) {
            throw new AssertionError();
        }
        return sInstance;
    }

    public static void setAutoDetectConnectivityState(boolean bl) {
        NetworkChangeNotifier.getInstance().setAutoDetectConnectivityStateInternal(bl, new j());
    }

    public static void registerToReceiveNotificationsAlways() {
        i i2;
        i i3 = i2;
        i2 = new i();
        NetworkChangeNotifier.getInstance().setAutoDetectConnectivityStateInternal(true, i3);
    }

    public static void setAutoDetectConnectivityState(b.g g2) {
        NetworkChangeNotifier.getInstance().setAutoDetectConnectivityStateInternal(true, g2);
    }

    private void destroyAutoDetector() {
        b b2 = this.mAutoDetector;
        if (b2 != null) {
            b b3 = b2;
            b3.a();
            b3.e.a();
            b3.g();
            this.mAutoDetector = null;
        }
    }

    private void setAutoDetectConnectivityStateInternal(boolean bl, b.g g2) {
        if (bl) {
            if (this.mAutoDetector == null) {
                NetworkChangeNotifier networkChangeNotifier = this;
                networkChangeNotifier.mAutoDetector = new b(new b.f(){

                    @Override
                    public void onConnectionTypeChanged(int n2) {
                        NetworkChangeNotifier.access$000(NetworkChangeNotifier.this, n2);
                    }

                    @Override
                    public void onConnectionSubtypeChanged(int n2) {
                        NetworkChangeNotifier.this.notifyObserversOfConnectionSubtypeChange(n2);
                    }

                    @Override
                    public void onNetworkConnect(long l2, int n2) {
                        NetworkChangeNotifier.this.notifyObserversOfNetworkConnect(l2, n2);
                    }

                    @Override
                    public void onNetworkSoonToDisconnect(long l2) {
                        NetworkChangeNotifier.this.notifyObserversOfNetworkSoonToDisconnect(l2);
                    }

                    @Override
                    public void onNetworkDisconnect(long l2) {
                        NetworkChangeNotifier.this.notifyObserversOfNetworkDisconnect(l2);
                    }

                    @Override
                    public void purgeActiveNetworkList(long[] lArray) {
                        NetworkChangeNotifier.this.notifyObserversToPurgeActiveNetworkList(lArray);
                    }
                }, g2);
                b.e e2 = networkChangeNotifier.mAutoDetector.c();
                this.mCurrentConnectionType = e2.b();
                networkChangeNotifier.notifyObserversOfConnectionTypeChange(this.mCurrentConnectionType);
                networkChangeNotifier.notifyObserversOfConnectionSubtypeChange(e2.a());
            }
        } else {
            this.destroyAutoDetector();
        }
    }

    public static void forceConnectivityState(boolean bl) {
        NetworkChangeNotifier.setAutoDetectConnectivityState(false);
        NetworkChangeNotifier.getInstance().forceConnectivityStateInternal(bl);
    }

    private void forceConnectivityStateInternal(boolean bl) {
        if (this.mCurrentConnectionType != 6 != bl) {
            int n2 = bl ? 0 : 6;
            this.mCurrentConnectionType = n2;
            this.notifyObserversOfConnectionTypeChange(n2);
            this.notifyObserversOfConnectionSubtypeChange(bl ^ 1);
        }
    }

    public static void fakeNetworkConnected(long l2, int n2) {
        NetworkChangeNotifier.setAutoDetectConnectivityState(false);
        NetworkChangeNotifier.getInstance().notifyObserversOfNetworkConnect(l2, n2);
    }

    public static void fakeNetworkSoonToBeDisconnected(long l2) {
        NetworkChangeNotifier.setAutoDetectConnectivityState(false);
        NetworkChangeNotifier.getInstance().notifyObserversOfNetworkSoonToDisconnect(l2);
    }

    public static void fakeNetworkDisconnected(long l2) {
        NetworkChangeNotifier.setAutoDetectConnectivityState(false);
        NetworkChangeNotifier.getInstance().notifyObserversOfNetworkDisconnect(l2);
    }

    public static void fakePurgeActiveNetworkList(long[] lArray) {
        NetworkChangeNotifier.setAutoDetectConnectivityState(false);
        NetworkChangeNotifier.getInstance().notifyObserversToPurgeActiveNetworkList(lArray);
    }

    public static void fakeDefaultNetwork(long l2, int n2) {
        NetworkChangeNotifier.setAutoDetectConnectivityState(false);
        NetworkChangeNotifier.getInstance().notifyObserversOfConnectionTypeChange(n2, l2);
    }

    public static void fakeConnectionSubtypeChanged(int n2) {
        NetworkChangeNotifier.setAutoDetectConnectivityState(false);
        NetworkChangeNotifier.getInstance().notifyObserversOfConnectionSubtypeChange(n2);
    }

    private void updateCurrentConnectionType(int n2) {
        this.mCurrentConnectionType = n2;
        this.notifyObserversOfConnectionTypeChange(n2);
    }

    private void notifyObserversOfConnectionTypeChange(int n2, long l2) {
        Iterator<Long> iterator = ((NetworkChangeNotifier)((Object)iterator2)).mNativeChangeNotifiers.iterator();
        while (iterator.hasNext()) {
            ((NetworkChangeNotifier)((Object)iterator2)).nativeNotifyConnectionTypeChanged(iterator.next(), n2, l2);
        }
        Iterator<ConnectionTypeObserver> iterator2 = ((NetworkChangeNotifier)((Object)iterator2)).mConnectionTypeObservers.iterator();
        while (iterator2.hasNext()) {
            ((ConnectionTypeObserver)iterator2.next()).onConnectionTypeChanged(n2);
        }
    }

    public static void addConnectionTypeObserver(ConnectionTypeObserver connectionTypeObserver) {
        NetworkChangeNotifier.getInstance().mConnectionTypeObservers.a(connectionTypeObserver);
    }

    private void addConnectionTypeObserverInternal(ConnectionTypeObserver connectionTypeObserver) {
        this.mConnectionTypeObservers.a(connectionTypeObserver);
    }

    public static void removeConnectionTypeObserver(ConnectionTypeObserver connectionTypeObserver) {
        NetworkChangeNotifier.getInstance().mConnectionTypeObservers.b(connectionTypeObserver);
    }

    private void removeConnectionTypeObserverInternal(ConnectionTypeObserver connectionTypeObserver) {
        this.mConnectionTypeObservers.b(connectionTypeObserver);
    }

    private boolean isProcessBoundToNetworkInternal() {
        int n2 = Build.VERSION.SDK_INT;
        if (n2 < 21) {
            return false;
        }
        if (n2 < 23) {
            return ConnectivityManager.getProcessDefaultNetwork() != null;
        }
        return this.mConnectivityManager.getBoundNetworkForProcess() != null;
    }

    public static boolean isProcessBoundToNetwork() {
        return NetworkChangeNotifier.getInstance().isProcessBoundToNetworkInternal();
    }

    private native void nativeNotifyConnectionTypeChanged(long var1, int var3, long var4);

    private native void nativeNotifyMaxBandwidthChanged(long var1, int var3);

    private native void nativeNotifyOfNetworkConnect(long var1, long var3, int var5);

    private native void nativeNotifyOfNetworkSoonToDisconnect(long var1, long var3);

    private native void nativeNotifyOfNetworkDisconnect(long var1, long var3);

    private native void nativeNotifyPurgeActiveNetworkList(long var1, long[] var3);

    public static b getAutoDetectorForTest() {
        return NetworkChangeNotifier.getInstance().mAutoDetector;
    }

    public static boolean isOnline() {
        return NetworkChangeNotifier.getInstance().getCurrentConnectionType() != 6;
    }

    public static /* synthetic */ void access$000(NetworkChangeNotifier networkChangeNotifier, int n2) {
        networkChangeNotifier.mCurrentConnectionType = n2;
        networkChangeNotifier.notifyObserversOfConnectionTypeChange(n2);
    }

    static {
        $assertionsDisabled = NetworkChangeNotifier.class.desiredAssertionStatus() ^ true;
    }

    public int getCurrentConnectionType() {
        return this.mCurrentConnectionType;
    }

    public int getCurrentConnectionSubtype() {
        Object object = object.mAutoDetector;
        return object == null ? 0 : ((b)((Object)object)).c().a();
    }

    public long getCurrentDefaultNetId() {
        Object object = object.mAutoDetector;
        return object == null ? -1L : ((b)((Object)object)).d();
    }

    public long[] getCurrentNetworksAndTypes() {
        Object object = object.mAutoDetector;
        return object == null ? new long[]{} : ((b)((Object)object)).e();
    }

    public void addNativeObserver(long l2) {
        this.mNativeChangeNotifiers.add(l2);
    }

    public void removeNativeObserver(long l2) {
        this.mNativeChangeNotifiers.remove(l2);
    }

    public boolean registerNetworkCallbackFailed() {
        Object object = object.mAutoDetector;
        boolean bl = object == null ? false : ((b)((Object)object)).o;
        return bl;
    }

    public void notifyObserversOfConnectionTypeChange(int n2) {
        this.notifyObserversOfConnectionTypeChange(n2, this.getCurrentDefaultNetId());
    }

    public void notifyObserversOfConnectionSubtypeChange(int n2) {
        Iterator<Long> iterator = this.mNativeChangeNotifiers.iterator();
        while (iterator.hasNext()) {
            this.nativeNotifyMaxBandwidthChanged(iterator.next(), n2);
        }
    }

    public void notifyObserversOfNetworkConnect(long l2, int n2) {
        Iterator<Long> iterator = this.mNativeChangeNotifiers.iterator();
        while (iterator.hasNext()) {
            this.nativeNotifyOfNetworkConnect(iterator.next(), l2, n2);
        }
    }

    public void notifyObserversOfNetworkSoonToDisconnect(long l2) {
        Iterator<Long> iterator = this.mNativeChangeNotifiers.iterator();
        while (iterator.hasNext()) {
            this.nativeNotifyOfNetworkSoonToDisconnect(iterator.next(), l2);
        }
    }

    public void notifyObserversOfNetworkDisconnect(long l2) {
        Iterator<Long> iterator = this.mNativeChangeNotifiers.iterator();
        while (iterator.hasNext()) {
            this.nativeNotifyOfNetworkDisconnect(iterator.next(), l2);
        }
    }

    public void notifyObserversToPurgeActiveNetworkList(long[] lArray) {
        Iterator<Long> iterator = this.mNativeChangeNotifiers.iterator();
        while (iterator.hasNext()) {
            this.nativeNotifyPurgeActiveNetworkList(iterator.next(), lArray);
        }
    }

    public static interface ConnectionTypeObserver {
        public void onConnectionTypeChanged(int var1);
    }
}

