/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.text.Normalizer;
import java.util.Locale;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="net::android")
public class NetStringUtil {
    public static String convertToUnicode(ByteBuffer byteBuffer, String string2) {
        try {
            return Charset.forName(string2).newDecoder().decode(byteBuffer).toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String convertToUnicodeAndNormalize(ByteBuffer object, String string2) {
        if ((object = NetStringUtil.convertToUnicode((ByteBuffer)object, string2)) == null) {
            return null;
        }
        return Normalizer.normalize((CharSequence)object, Normalizer.Form.NFC);
    }

    public static String convertToUnicodeWithSubstitutions(ByteBuffer byteBuffer, String string2) {
        CharsetDecoder charsetDecoder;
        ByteBuffer byteBuffer2;
        CharsetDecoder charsetDecoder2;
        try {
            CharsetDecoder charsetDecoder3 = Charset.forName(string2).newDecoder();
            charsetDecoder2 = charsetDecoder3;
            byteBuffer2 = byteBuffer;
            charsetDecoder = charsetDecoder3;
            charsetDecoder3.onMalformedInput(CodingErrorAction.REPLACE);
            charsetDecoder3.onUnmappableCharacter(CodingErrorAction.REPLACE);
        }
        catch (Exception exception) {
            return null;
        }
        charsetDecoder.replaceWith("\ufffd");
        return charsetDecoder2.decode(byteBuffer2).toString();
    }

    public static String toUpperCase(String string2) {
        try {
            return string2.toUpperCase(Locale.getDefault());
        }
        catch (Exception exception) {
            return null;
        }
    }
}

