/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.mojo.system.impl;

import a.b.j.b.m;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.mojo.system.impl.CoreImpl;

@JNINamespace(value="mojo::android")
public class BaseRunLoop
implements m {
    public static final /* synthetic */ boolean $assertionsDisabled;
    public long mRunLoopID;
    public final CoreImpl mCore;

    public BaseRunLoop(CoreImpl coreImpl) {
        this.mCore = coreImpl;
        this.mRunLoopID = this.nativeCreateBaseRunLoop();
    }

    public static void runRunnable(Runnable runnable) {
        runnable.run();
    }

    private native long nativeCreateBaseRunLoop();

    private native void nativeRun();

    private native void nativeRunUntilIdle();

    private native void nativeQuit();

    private native void nativePostDelayedTask(long var1, Runnable var3, long var4);

    private native void nativeDeleteMessageLoop(long var1);

    static {
        $assertionsDisabled = BaseRunLoop.class.desiredAssertionStatus() ^ true;
    }

    public void run() {
        if (!$assertionsDisabled && this.mRunLoopID == 0L) {
            throw new AssertionError((Object)"The run loop cannot run once closed");
        }
        this.nativeRun();
    }

    public void runUntilIdle() {
        if (!$assertionsDisabled && this.mRunLoopID == 0L) {
            throw new AssertionError((Object)"The run loop cannot run once closed");
        }
        this.nativeRunUntilIdle();
    }

    public void quit() {
        if (!$assertionsDisabled && this.mRunLoopID == 0L) {
            throw new AssertionError((Object)"The run loop cannot be quitted run once closed");
        }
        this.nativeQuit();
    }

    public void postDelayedTask(Runnable runnable, long l2) {
        if (!$assertionsDisabled && this.mRunLoopID == 0L) {
            throw new AssertionError((Object)"The run loop cannot run tasks once closed");
        }
        BaseRunLoop baseRunLoop = this;
        baseRunLoop.nativePostDelayedTask(baseRunLoop.mRunLoopID, runnable, l2);
    }

    @Override
    public void close() {
        if (this.mRunLoopID == 0L) {
            return;
        }
        if (!$assertionsDisabled && this.mCore.getCurrentRunLoop() != this) {
            throw new AssertionError((Object)"Only the current run loop can be closed");
        }
        BaseRunLoop baseRunLoop = this;
        baseRunLoop.mCore.clearCurrentRunLoop();
        baseRunLoop.nativeDeleteMessageLoop(baseRunLoop.mRunLoopID);
        baseRunLoop.mRunLoopID = 0L;
    }
}

