/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.media;

import a.a.a.a.a;
import a.b.a.e.b;
import a.b.a.g;
import a.b.a.j;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import android.util.Base64InputStream;
import android.view.Surface;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.chromium.base.ContextUtils;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="media")
public class MediaPlayerBridge {
    public static final String TAG = "cr.media";
    public LoadDataUriTask mLoadDataUriTask;
    public MediaPlayer mPlayer;
    public long mNativeMediaPlayerBridge;

    public static MediaPlayerBridge create(long l2) {
        return new MediaPlayerBridge(l2);
    }

    public MediaPlayerBridge(long l2) {
        this.mNativeMediaPlayerBridge = l2;
    }

    public MediaPlayerBridge() {
    }

    private native void nativeOnDidSetDataUriDataSource(long var1, boolean var3);

    private void cancelLoadDataUriTask() {
        LoadDataUriTask loadDataUriTask = this.mLoadDataUriTask;
        if (loadDataUriTask != null) {
            loadDataUriTask.cancel(true);
            this.mLoadDataUriTask = null;
        }
    }

    public void destroy() {
        this.cancelLoadDataUriTask();
        this.mNativeMediaPlayerBridge = 0L;
    }

    public MediaPlayer getLocalPlayer() {
        if (this.mPlayer == null) {
            this.mPlayer = new MediaPlayer();
        }
        return this.mPlayer;
    }

    public void setSurface(Surface surface) {
        this.getLocalPlayer().setSurface(surface);
    }

    public boolean prepareAsync() {
        try {
            this.getLocalPlayer().prepareAsync();
            return true;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = exception;
            j.b(TAG, "Unable to prepare MediaPlayer.", objectArray2);
            return false;
        }
        catch (IllegalStateException illegalStateException) {
            Object[] objectArray = new Object[1];
            Object[] objectArray3 = objectArray;
            objectArray[0] = illegalStateException;
            j.b(TAG, "Unable to prepare MediaPlayer.", objectArray3);
            return false;
        }
    }

    public boolean isPlaying() {
        return this.getLocalPlayer().isPlaying();
    }

    public int getCurrentPosition() {
        return this.getLocalPlayer().getCurrentPosition();
    }

    public int getDuration() {
        return this.getLocalPlayer().getDuration();
    }

    public void release() {
        MediaPlayerBridge mediaPlayerBridge = this;
        mediaPlayerBridge.cancelLoadDataUriTask();
        mediaPlayerBridge.getLocalPlayer().release();
    }

    public void setVolume(double d2) {
        float f2 = (float)d2;
        this.getLocalPlayer().setVolume(f2, f2);
    }

    public void start() {
        this.getLocalPlayer().start();
    }

    public void pause() {
        this.getLocalPlayer().pause();
    }

    public void seekTo(int n2) {
        this.getLocalPlayer().seekTo(n2);
    }

    public boolean setDataSource(String string2, String string3, String string4, boolean bl) {
        HashMap<String, String> hashMap;
        string2 = Uri.parse((String)string2);
        HashMap<String, String> hashMap2 = hashMap;
        hashMap = new HashMap<String, String>();
        if (bl) {
            hashMap2.put("x-hide-urls-from-log", "true");
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            hashMap2.put("Cookie", string3);
        }
        if (!TextUtils.isEmpty((CharSequence)string4)) {
            hashMap2.put("User-Agent", string4);
        }
        if (Build.VERSION.SDK_INT > 19) {
            hashMap2.put("allow-cross-domain-redirect", "false");
        }
        try {
            this.getLocalPlayer().setDataSource(ContextUtils.sApplicationContext, (Uri)string2, hashMap2);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean setDataSourceFromFd(int n2, long l2, long l3) {
        try {
            ParcelFileDescriptor parcelFileDescriptor = ParcelFileDescriptor.adoptFd((int)n2);
            this.getLocalPlayer().setDataSource(parcelFileDescriptor.getFileDescriptor(), l2, l3);
            parcelFileDescriptor.close();
            return true;
        }
        catch (IOException iOException) {
            Object[] objectArray = new Object[]{};
            j.b(TAG, "Failed to set data source from file descriptor: " + iOException, objectArray);
            return false;
        }
    }

    public boolean setDataUriDataSource(String string2) {
        this.cancelLoadDataUriTask();
        if (!string2.startsWith("data:")) {
            return false;
        }
        int n2 = string2.indexOf(44);
        if (n2 == -1) {
            return false;
        }
        String string3 = string2.substring(0, n2);
        string2 = string2.substring(n2 + 1);
        String[] stringArray = string3.substring(5).split(";");
        if (stringArray.length != 2) {
            return false;
        }
        if (!"base64".equals(stringArray[1])) {
            return false;
        }
        this.mLoadDataUriTask = new LoadDataUriTask(string2);
        this.mLoadDataUriTask.executeOnExecutor(b.THREAD_POOL_EXECUTOR);
        return true;
    }

    public void setOnCompletionListener(MediaPlayer.OnCompletionListener onCompletionListener) {
        this.getLocalPlayer().setOnCompletionListener(onCompletionListener);
    }

    public void setOnErrorListener(MediaPlayer.OnErrorListener onErrorListener) {
        this.getLocalPlayer().setOnErrorListener(onErrorListener);
    }

    public void setOnPreparedListener(MediaPlayer.OnPreparedListener onPreparedListener) {
        this.getLocalPlayer().setOnPreparedListener(onPreparedListener);
    }

    public void setOnVideoSizeChangedListener(MediaPlayer.OnVideoSizeChangedListener onVideoSizeChangedListener) {
        this.getLocalPlayer().setOnVideoSizeChangedListener(onVideoSizeChangedListener);
    }

    public AllowedOperations getAllowedOperations() {
        boolean bl;
        boolean bl2;
        block35: {
            boolean bl3;
            block31: {
                block34: {
                    int n2;
                    Method method;
                    Method method2;
                    block33: {
                        block32: {
                            Class<?> clazz;
                            Object object = ((MediaPlayerBridge)object).getLocalPlayer();
                            bl2 = true;
                            bl3 = true;
                            Class<?> clazz2 = object.getClass();
                            Class[] classArray = new Class[2];
                            classArray[0] = Boolean.TYPE;
                            classArray[1] = Boolean.TYPE;
                            Method method3 = clazz2.getDeclaredMethod("getMetadata", classArray);
                            Method method4 = method3;
                            Method method5 = method3;
                            method4.setAccessible(true);
                            Object[] objectArray = new Object[2];
                            objectArray[0] = false;
                            objectArray[1] = false;
                            object = method5.invoke(object, objectArray);
                            if (object == null) break block31;
                            Class<?> clazz3 = clazz = object.getClass();
                            Class[] classArray2 = new Class[1];
                            classArray2[0] = Integer.TYPE;
                            Method method6 = method2 = clazz3.getDeclaredMethod("has", classArray2);
                            Class[] classArray3 = new Class[1];
                            classArray3[0] = Integer.TYPE;
                            Method method7 = method = clazz.getDeclaredMethod("getBoolean", classArray3);
                            Class<?> clazz4 = clazz;
                            Field field = clazz4.getField("SEEK_FORWARD_AVAILABLE");
                            int n3 = (Integer)field.get(null);
                            Field field2 = clazz4.getField("SEEK_BACKWARD_AVAILABLE");
                            n2 = (Integer)field2.get(null);
                            method2.setAccessible(true);
                            method7.setAccessible(true);
                            Object[] objectArray2 = new Object[1];
                            objectArray2[0] = n3;
                            if (!((Boolean)method6.invoke(object, objectArray2)).booleanValue()) break block32;
                            Object[] objectArray3 = new Object[1];
                            objectArray3[0] = n3;
                            if (((Boolean)method.invoke(object, objectArray3)).booleanValue()) break block32;
                            bl2 = false;
                            break block33;
                        }
                        bl2 = true;
                    }
                    Object[] objectArray = new Object[1];
                    objectArray[0] = n2;
                    if (!((Boolean)method2.invoke(object, objectArray)).booleanValue()) break block34;
                    Object[] objectArray4 = new Object[1];
                    try {
                        objectArray4[0] = n2;
                        if (((Boolean)method.invoke(object, objectArray4)).booleanValue()) break block34;
                        bl = false;
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        Object[] objectArray5 = new Object[]{};
                        j.b(TAG, "Cannot find matching fields in Metadata class: " + noSuchFieldException, objectArray5);
                        bl = bl3;
                        break block35;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        Object[] objectArray6 = new Object[]{};
                        j.b(TAG, "Cannot access metadata: " + illegalAccessException, objectArray6);
                        bl = bl3;
                        break block35;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        Object[] objectArray7 = new Object[]{};
                        j.b(TAG, "Cannot invoke MediaPlayer.getMetadata() method: " + invocationTargetException, objectArray7);
                        bl = bl3;
                        break block35;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        Object[] objectArray8 = new Object[]{};
                        j.b(TAG, "Cannot find getMetadata() method: " + noSuchMethodException, objectArray8);
                        bl = bl3;
                    }
                }
                bl = true;
                break block35;
            }
            bl = bl3;
        }
        return new AllowedOperations(bl2, bl);
    }

    protected static class AllowedOperations {
        public final boolean mCanSeekForward;
        public final boolean mCanSeekBackward;

        public AllowedOperations(boolean bl, boolean bl2) {
            this.mCanSeekForward = bl;
            this.mCanSeekBackward = bl2;
        }

        private boolean canSeekForward() {
            return this.mCanSeekForward;
        }

        private boolean canSeekBackward() {
            return this.mCanSeekBackward;
        }
    }

    private class LoadDataUriTask
    extends b<Boolean> {
        public static final /* synthetic */ boolean $assertionsDisabled;
        public final String mData;
        public File mTempFile;

        public LoadDataUriTask(String string2) {
            this.mData = string2;
        }

        private void deleteFile() {
            File file = objectArray.mTempFile;
            if (file == null) {
                return;
            }
            if (!file.delete()) {
                Object[] objectArray = new Object[]{};
                j.b(MediaPlayerBridge.TAG, a.a("Failed to delete temporary file: ").append(objectArray.mTempFile).toString(), objectArray);
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
        }

        static {
            $assertionsDisabled = MediaPlayerBridge.class.desiredAssertionStatus() ^ true;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Boolean doInBackground() {
            Throwable throwable2;
            FileOutputStream fileOutputStream;
            block9: {
                Boolean bl;
                block8: {
                    Boolean bl2;
                    FileOutputStream fileOutputStream2;
                    Object object = null;
                    loadDataUriTask.mTempFile = File.createTempFile("decoded", "mediadata");
                    fileOutputStream = fileOutputStream2;
                    fileOutputStream2 = new FileOutputStream(loadDataUriTask.mTempFile);
                    try {
                        int n2;
                        Base64InputStream base64InputStream;
                        ByteArrayInputStream byteArrayInputStream;
                        object = byteArrayInputStream;
                        byteArrayInputStream = new ByteArrayInputStream(a.b.a.a.a(loadDataUriTask.mData));
                        LoadDataUriTask loadDataUriTask = base64InputStream;
                        base64InputStream = new Base64InputStream((InputStream)object, 0);
                        object = new byte[1024];
                        while ((n2 = loadDataUriTask.read((byte[])object)) != -1) {
                            fileOutputStream.write((byte[])object, 0, n2);
                        }
                        loadDataUriTask.close();
                        bl2 = true;
                    }
                    catch (IOException iOException) {
                        break block8;
                    }
                    g.a(fileOutputStream);
                    return bl2;
                    catch (Throwable throwable2) {
                        fileOutputStream = object;
                        break block9;
                    }
                    catch (IOException iOException) {
                        fileOutputStream = object;
                    }
                }
                try {
                    bl = false;
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                g.a(fileOutputStream);
                return bl;
            }
            g.a(fileOutputStream);
            throw throwable2;
        }

        @Override
        public void onPostExecute(Boolean bl) {
            if (this.isCancelled()) {
                this.deleteFile();
                return;
            }
            if (bl.booleanValue()) {
                try {
                    MediaPlayerBridge.this.getLocalPlayer().setDataSource(ContextUtils.sApplicationContext, Uri.fromFile((File)this.mTempFile));
                }
                catch (IOException iOException) {
                    bl = false;
                }
            }
            this.deleteFile();
            if (!$assertionsDisabled && MediaPlayerBridge.this.mNativeMediaPlayerBridge == 0L) {
                throw new AssertionError();
            }
            MediaPlayerBridge mediaPlayerBridge = MediaPlayerBridge.this;
            mediaPlayerBridge.nativeOnDidSetDataUriDataSource(mediaPlayerBridge.mNativeMediaPlayerBridge, bl);
        }
    }
}

