/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.device.vibration;

import a.b.a.j;
import a.b.g.d.t;
import a.b.j.b.k;
import a.b.o.a.a;
import android.content.Context;
import android.media.AudioManager;
import android.os.Vibrator;
import org.chromium.base.ContextUtils;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="device")
public class VibrationManagerImpl
implements t {
    public static final String TAG = "VibrationManagerImpl";
    public static final long MINIMUM_VIBRATION_DURATION_MS = 1L;
    public static final long MAXIMUM_VIBRATION_DURATION_MS = 10000L;
    public static long sVibrateMilliSecondsForTesting = -1L;
    public static boolean sVibrateCancelledForTesting;
    public final AudioManager mAudioManager;
    public final Vibrator mVibrator;
    public final boolean mHasVibratePermission;

    public VibrationManagerImpl() {
        Context context = ContextUtils.sApplicationContext;
        objectArray.mAudioManager = (AudioManager)context.getSystemService("audio");
        objectArray.mVibrator = (Vibrator)context.getSystemService("vibrator");
        boolean bl = context.checkCallingOrSelfPermission("android.permission.VIBRATE") == 0;
        objectArray.mHasVibratePermission = bl;
        if (!objectArray.mHasVibratePermission) {
            Object[] objectArray = new Object[]{};
            j.d(TAG, "Failed to use vibrate API, requires VIBRATE permission.", objectArray);
        }
    }

    public static void setVibrateMilliSecondsForTesting(long l2) {
        sVibrateMilliSecondsForTesting = l2;
    }

    public static void setVibrateCancelledForTesting(boolean bl) {
        sVibrateCancelledForTesting = bl;
    }

    public static long getVibrateMilliSecondsForTesting() {
        return sVibrateMilliSecondsForTesting;
    }

    public static boolean getVibrateCancelledForTesting() {
        return sVibrateCancelledForTesting;
    }

    @Override
    public void close() {
    }

    @Override
    public void onConnectionError(k k2) {
    }

    @Override
    public void vibrate(long l2, t.c c2) {
        l2 = Math.min(l2, 10000L);
        l2 = Math.max(1L, l2);
        if (this.mAudioManager.getRingerMode() != 0 && this.mHasVibratePermission) {
            this.mVibrator.vibrate(l2);
        }
        sVibrateMilliSecondsForTesting = l2;
        c2.call();
    }

    @Override
    public void cancel(t.a a2) {
        if (this.mHasVibratePermission) {
            this.mVibrator.cancel();
        }
        sVibrateCancelledForTesting = true;
        a2.call();
    }

    public static class Factory
    implements a<t> {
        @Override
        public t createImpl() {
            return new VibrationManagerImpl();
        }
    }
}

