/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.device.gamepad;

import android.annotation.TargetApi;
import android.os.Build;
import android.view.InputDevice;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="content")
public abstract class GamepadMappings {
    public static final String NVIDIA_SHIELD_DEVICE_NAME_PREFIX = "NVIDIA Corporation NVIDIA Controller";
    public static final String MICROSOFT_XBOX_PAD_DEVICE_NAME = "Microsoft X-Box 360 pad";
    public static final String PS3_SIXAXIS_DEVICE_NAME = "Sony PLAYSTATION(R)3 Controller";
    public static final String SAMSUNG_EI_GP20_DEVICE_NAME = "Samsung Game Pad EI-GP20";
    public static final String AMAZON_FIRE_DEVICE_NAME = "Amazon Fire Game Controller";
    public static final int PS_DUALSHOCK_4_VENDOR_ID = 1356;
    public static final int PS_DUALSHOCK_4_PRODUCT_ID = 1476;
    public static final int PS_DUALSHOCK_4_SLIM_PRODUCT_ID = 2508;
    public static final int PS_DUALSHOCK_4_USB_RECEIVER_PRODUCT_ID = 2976;
    public static final int XBOX_ONE_S_2016_FIRMWARE_VENDOR_ID = 1118;
    public static final int XBOX_ONE_S_2016_FIRMWARE_PRODUCT_ID = 736;

    public static GamepadMappings getMappings(InputDevice inputDevice, int[] nArray) {
        GamepadMappings gamepadMappings = null;
        if (Build.VERSION.SDK_INT >= 19) {
            gamepadMappings = GamepadMappings.getMappings(inputDevice.getProductId(), inputDevice.getVendorId());
        }
        if (gamepadMappings == null) {
            gamepadMappings = GamepadMappings.getMappings(inputDevice.getName());
        }
        if (gamepadMappings == null) {
            UnknownGamepadMappings unknownGamepadMappings;
            gamepadMappings = unknownGamepadMappings;
            unknownGamepadMappings = new UnknownGamepadMappings(nArray);
        }
        return gamepadMappings;
    }

    @TargetApi(value=19)
    public static GamepadMappings getMappings(int n2, int n3) {
        if (n3 == 1356 && (n2 == 1476 || n2 == 2508 || n2 == 2976)) {
            return new PS4GamepadMappings();
        }
        if (n3 == 1118 && n2 == 736) {
            return new XboxOneS2016FirmwareMappings(null);
        }
        return null;
    }

    public static GamepadMappings getMappings(String string2) {
        if (!string2.startsWith(NVIDIA_SHIELD_DEVICE_NAME_PREFIX) && !string2.equals(MICROSOFT_XBOX_PAD_DEVICE_NAME)) {
            if (string2.equals(PS3_SIXAXIS_DEVICE_NAME)) {
                return new PS3SixAxisGamepadMappings(null);
            }
            if (string2.equals(SAMSUNG_EI_GP20_DEVICE_NAME)) {
                return new SamsungEIGP20GamepadMappings(null);
            }
            if (string2.equals(AMAZON_FIRE_DEVICE_NAME)) {
                return new AmazonFireGamepadMappings(null);
            }
            return null;
        }
        return new XboxCompatibleGamepadMappings(null);
    }

    public static GamepadMappings getUnknownGamepadMappings(int[] nArray) {
        return new UnknownGamepadMappings(nArray);
    }

    public static void mapCommonXYABButtons(float[] fArray, float[] fArray2) {
        float[] fArray3 = fArray;
        float[] fArray4 = fArray;
        float f2 = fArray2[96];
        float f3 = fArray2[97];
        float f4 = fArray2[99];
        float f5 = fArray2[100];
        fArray3[0] = f2;
        fArray4[1] = f3;
        fArray3[2] = f4;
        fArray4[3] = f5;
    }

    public static void mapCommonStartSelectMetaButtons(float[] fArray, float[] fArray2) {
        float[] fArray3 = fArray;
        float f2 = fArray2[108];
        float f3 = fArray2[109];
        float f4 = fArray2[110];
        fArray3[9] = f2;
        fArray3[8] = f3;
        fArray[16] = f4;
    }

    public static void mapCommonThumbstickButtons(float[] fArray, float[] fArray2) {
        float f2 = fArray2[106];
        float f3 = fArray2[107];
        fArray[10] = f2;
        fArray[11] = f3;
    }

    public static void mapUpperTriggerButtonsToBottomShoulder(float[] fArray, float[] fArray2) {
        float f2 = fArray2[102];
        float f3 = fArray2[103];
        fArray[6] = f2;
        fArray[7] = f3;
    }

    public static void mapTriggerButtonsToTopShoulder(float[] fArray, float[] fArray2) {
        float f2 = fArray2[102];
        float f3 = fArray2[103];
        fArray[4] = f2;
        fArray[5] = f3;
    }

    public static void mapCommonDpadButtons(float[] fArray, float[] fArray2) {
        float[] fArray3 = fArray;
        float[] fArray4 = fArray;
        float f2 = fArray2[20];
        float f3 = fArray2[19];
        float f4 = fArray2[21];
        float f5 = fArray2[22];
        fArray3[13] = f2;
        fArray4[12] = f3;
        fArray3[14] = f4;
        fArray4[15] = f5;
    }

    public static void mapXYAxes(float[] fArray, float[] fArray2) {
        fArray[0] = fArray2[0];
        fArray[1] = fArray2[1];
    }

    public static void mapRXAndRYAxesToRightStick(float[] fArray, float[] fArray2) {
        fArray[2] = fArray2[12];
        fArray[3] = fArray2[13];
    }

    public static void mapZAndRZAxesToRightStick(float[] fArray, float[] fArray2) {
        fArray[2] = fArray2[11];
        fArray[3] = fArray2[14];
    }

    public static void mapPedalAxesToBottomShoulder(float[] fArray, float[] fArray2) {
        float f2 = fArray2[23];
        float f3 = fArray2[22];
        fArray[6] = f2;
        fArray[7] = f3;
    }

    public static void mapTriggerAxesToBottomShoulder(float[] fArray, float[] fArray2) {
        float f2 = fArray2[17];
        float f3 = fArray2[18];
        fArray[6] = f2;
        fArray[7] = f3;
    }

    public static void mapLowerTriggerButtonsToBottomShoulder(float[] fArray, float[] fArray2) {
        float f2 = fArray2[104];
        float f3 = fArray2[105];
        fArray[6] = f2;
        fArray[7] = f3;
    }

    public static float negativeAxisValueAsButton(float f2) {
        return f2 < -0.5f ? 1.0f : 0.0f;
    }

    public static float positiveAxisValueAsButton(float f2) {
        return f2 > 0.5f ? 1.0f : 0.0f;
    }

    public static void mapHatAxisToDpadButtons(float[] fArray, float[] fArray2) {
        float f2 = fArray2[15];
        float f3 = fArray2[16];
        fArray[14] = GamepadMappings.negativeAxisValueAsButton(f2);
        fArray[15] = GamepadMappings.positiveAxisValueAsButton(f2);
        fArray[12] = GamepadMappings.negativeAxisValueAsButton(f3);
        fArray[13] = GamepadMappings.positiveAxisValueAsButton(f3);
    }

    public static /* synthetic */ void access$500(float[] fArray, float[] fArray2) {
        GamepadMappings.mapCommonXYABButtons(fArray, fArray2);
    }

    public static /* synthetic */ void access$600(float[] fArray, float[] fArray2) {
        GamepadMappings.mapTriggerButtonsToTopShoulder(fArray, fArray2);
    }

    public static /* synthetic */ void access$700(float[] fArray, float[] fArray2) {
        GamepadMappings.mapCommonThumbstickButtons(fArray, fArray2);
    }

    public static /* synthetic */ void access$800(float[] fArray, float[] fArray2) {
        GamepadMappings.mapCommonStartSelectMetaButtons(fArray, fArray2);
    }

    public static /* synthetic */ void access$900(float[] fArray, float[] fArray2) {
        GamepadMappings.mapPedalAxesToBottomShoulder(fArray, fArray2);
    }

    public static /* synthetic */ void access$1000(float[] fArray, float[] fArray2) {
        GamepadMappings.mapHatAxisToDpadButtons(fArray, fArray2);
    }

    public static /* synthetic */ void access$1100(float[] fArray, float[] fArray2) {
        GamepadMappings.mapXYAxes(fArray, fArray2);
    }

    public static /* synthetic */ void access$1200(float[] fArray, float[] fArray2) {
        GamepadMappings.mapZAndRZAxesToRightStick(fArray, fArray2);
    }

    public static /* synthetic */ void access$1300(float[] fArray, float[] fArray2) {
        GamepadMappings.mapTriggerAxesToBottomShoulder(fArray, fArray2);
    }

    public static /* synthetic */ void access$1400(float[] fArray, float[] fArray2) {
        GamepadMappings.mapRXAndRYAxesToRightStick(fArray, fArray2);
    }

    public static /* synthetic */ void access$1500(float[] fArray, float[] fArray2) {
        GamepadMappings.mapCommonDpadButtons(fArray, fArray2);
    }

    public static /* synthetic */ void access$1600(float[] fArray, float[] fArray2) {
        GamepadMappings.mapUpperTriggerButtonsToBottomShoulder(fArray, fArray2);
    }

    public static /* synthetic */ void access$1700(float[] fArray, float[] fArray2) {
        GamepadMappings.mapLowerTriggerButtonsToBottomShoulder(fArray, fArray2);
    }

    public boolean isStandard() {
        return true;
    }

    public abstract void mapToStandardGamepad(float[] var1, float[] var2, float[] var3, float[] var4);

    private static class UnknownGamepadMappings
    extends GamepadMappings {
        public int mLeftTriggerAxis = -1;
        public int mRightTriggerAxis = -1;
        public int mRightStickXAxis = -1;
        public int mRightStickYAxis = -1;
        public boolean mUseHatAxes;

        public UnknownGamepadMappings(int[] nArray) {
            int n2 = 0;
            block7: for (int n3 : nArray) {
                switch (n3) {
                    default: {
                        continue block7;
                    }
                    case 18: 
                    case 19: 
                    case 22: {
                        this.mRightTriggerAxis = n3;
                        continue block7;
                    }
                    case 17: 
                    case 23: {
                        this.mLeftTriggerAxis = n3;
                        continue block7;
                    }
                    case 15: 
                    case 16: {
                        ++n2;
                        continue block7;
                    }
                    case 13: 
                    case 14: {
                        this.mRightStickYAxis = n3;
                        continue block7;
                    }
                    case 11: 
                    case 12: {
                        this.mRightStickXAxis = n3;
                    }
                }
            }
            if (n2 == 2) {
                this.mUseHatAxes = true;
            }
        }

        @Override
        public boolean isStandard() {
            return false;
        }

        @Override
        public void mapToStandardGamepad(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
            int n2;
            int n3;
            GamepadMappings.mapCommonXYABButtons(fArray2, fArray4);
            GamepadMappings.mapTriggerButtonsToTopShoulder(fArray2, fArray4);
            GamepadMappings.mapCommonThumbstickButtons(fArray2, fArray4);
            GamepadMappings.mapCommonStartSelectMetaButtons(fArray2, fArray4);
            GamepadMappings.mapXYAxes(fArray, fArray3);
            int n4 = this.mLeftTriggerAxis;
            if (n4 != -1 && (n3 = this.mRightTriggerAxis) != -1) {
                float f2 = fArray3[n4];
                float f3 = fArray3[n3];
                fArray2[6] = f2;
                fArray2[7] = f3;
            } else {
                GamepadMappings.mapLowerTriggerButtonsToBottomShoulder(fArray2, fArray4);
            }
            int n5 = this.mRightStickXAxis;
            if (n5 != -1 && (n2 = this.mRightStickYAxis) != -1) {
                float f4 = fArray3[n5];
                float f5 = fArray3[n2];
                fArray[2] = f4;
                fArray[3] = f5;
            }
            if (this.mUseHatAxes) {
                GamepadMappings.mapHatAxisToDpadButtons(fArray2, fArray3);
            } else {
                GamepadMappings.mapCommonDpadButtons(fArray2, fArray4);
            }
        }
    }

    private static class SamsungEIGP20GamepadMappings
    extends GamepadMappings {
        public SamsungEIGP20GamepadMappings() {
        }

        public /* synthetic */ SamsungEIGP20GamepadMappings(1 var1_1) {
        }

        @Override
        public void mapToStandardGamepad(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
            GamepadMappings.mapCommonXYABButtons(fArray2, fArray4);
            GamepadMappings.mapUpperTriggerButtonsToBottomShoulder(fArray2, fArray4);
            GamepadMappings.mapCommonThumbstickButtons(fArray2, fArray4);
            GamepadMappings.mapCommonStartSelectMetaButtons(fArray2, fArray4);
            GamepadMappings.mapHatAxisToDpadButtons(fArray2, fArray3);
            GamepadMappings.mapXYAxes(fArray, fArray3);
            GamepadMappings.mapRXAndRYAxesToRightStick(fArray, fArray3);
        }
    }

    public static class PS4GamepadMappings
    extends GamepadMappings {
        public static float scaleRxRy(float f2) {
            return 1.0f - (1.0f - f2) / 2.0f;
        }

        @Override
        public void mapToStandardGamepad(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
            float[] fArray5 = fArray2;
            float[] fArray6 = fArray2;
            float f2 = fArray4[96];
            float f3 = fArray4[97];
            float f4 = fArray4[98];
            float f5 = fArray4[99];
            fArray5[0] = f3;
            fArray6[1] = f4;
            fArray5[2] = f2;
            fArray6[3] = f5;
            f2 = fArray4[100];
            f3 = fArray4[101];
            fArray2[4] = f2;
            fArray2[5] = f3;
            f2 = fArray3[12];
            fArray2[6] = PS4GamepadMappings.scaleRxRy(f2);
            fArray2[7] = PS4GamepadMappings.scaleRxRy(fArray3[13]);
            f2 = fArray4[104];
            f3 = fArray4[105];
            fArray2[8] = f2;
            fArray2[9] = f3;
            f2 = fArray4[109];
            f3 = fArray4[108];
            fArray2[10] = f2;
            fArray2[11] = f3;
            fArray2[16] = fArray4[110];
            GamepadMappings.mapHatAxisToDpadButtons(fArray2, fArray3);
            GamepadMappings.mapXYAxes(fArray, fArray3);
            GamepadMappings.mapZAndRZAxesToRightStick(fArray, fArray3);
        }
    }

    private static class PS3SixAxisGamepadMappings
    extends GamepadMappings {
        public PS3SixAxisGamepadMappings() {
        }

        public /* synthetic */ PS3SixAxisGamepadMappings(1 var1_1) {
        }

        @Override
        public void mapToStandardGamepad(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
            float[] fArray5 = fArray2;
            float[] fArray6 = fArray2;
            float f2 = fArray4[96];
            float f3 = fArray4[97];
            float f4 = fArray4[99];
            float f5 = fArray4[100];
            fArray5[0] = f4;
            fArray6[1] = f5;
            fArray5[2] = f2;
            fArray6[3] = f3;
            GamepadMappings.mapTriggerButtonsToTopShoulder(fArray2, fArray4);
            GamepadMappings.mapCommonThumbstickButtons(fArray2, fArray4);
            GamepadMappings.mapCommonDpadButtons(fArray2, fArray4);
            GamepadMappings.mapCommonStartSelectMetaButtons(fArray2, fArray4);
            GamepadMappings.mapTriggerAxesToBottomShoulder(fArray2, fArray3);
            GamepadMappings.mapXYAxes(fArray, fArray3);
            GamepadMappings.mapZAndRZAxesToRightStick(fArray, fArray3);
        }
    }

    private static class XboxOneS2016FirmwareMappings
    extends GamepadMappings {
        public boolean mLeftTriggerActivated;
        public boolean mRightTriggerActivated;

        public XboxOneS2016FirmwareMappings() {
        }

        public /* synthetic */ XboxOneS2016FirmwareMappings(1 var1_1) {
        }

        @Override
        public void mapToStandardGamepad(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
            fArray2[0] = fArray4[96];
            fArray2[1] = fArray4[97];
            fArray2[2] = fArray4[98];
            fArray2[3] = fArray4[99];
            fArray2[4] = fArray4[100];
            fArray2[5] = fArray4[101];
            fArray2[8] = fArray4[102];
            fArray2[9] = fArray4[103];
            fArray2[10] = fArray4[104];
            fArray2[11] = fArray4[105];
            if (fArray3[11] != 0.0f) {
                this.mLeftTriggerActivated = true;
            }
            if (fArray3[14] != 0.0f) {
                this.mRightTriggerActivated = true;
            }
            fArray2[6] = this.mLeftTriggerActivated ? (fArray3[11] + 1.0f) / 2.0f : 0.0f;
            fArray2[7] = this.mRightTriggerActivated ? (fArray3[14] + 1.0f) / 2.0f : 0.0f;
            GamepadMappings.mapHatAxisToDpadButtons(fArray2, fArray3);
            GamepadMappings.mapXYAxes(fArray, fArray3);
            GamepadMappings.mapRXAndRYAxesToRightStick(fArray, fArray3);
        }
    }

    private static class XboxCompatibleGamepadMappings
    extends GamepadMappings {
        public XboxCompatibleGamepadMappings() {
        }

        public /* synthetic */ XboxCompatibleGamepadMappings(1 var1_1) {
        }

        @Override
        public void mapToStandardGamepad(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
            GamepadMappings.mapCommonXYABButtons(fArray2, fArray4);
            GamepadMappings.mapTriggerButtonsToTopShoulder(fArray2, fArray4);
            GamepadMappings.mapCommonThumbstickButtons(fArray2, fArray4);
            GamepadMappings.mapCommonStartSelectMetaButtons(fArray2, fArray4);
            GamepadMappings.mapTriggerAxesToBottomShoulder(fArray2, fArray3);
            GamepadMappings.mapHatAxisToDpadButtons(fArray2, fArray3);
            GamepadMappings.mapXYAxes(fArray, fArray3);
            GamepadMappings.mapZAndRZAxesToRightStick(fArray, fArray3);
        }
    }

    private static class AmazonFireGamepadMappings
    extends GamepadMappings {
        public AmazonFireGamepadMappings() {
        }

        public /* synthetic */ AmazonFireGamepadMappings(1 var1_1) {
        }

        @Override
        public void mapToStandardGamepad(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
            GamepadMappings.mapCommonXYABButtons(fArray2, fArray4);
            GamepadMappings.mapTriggerButtonsToTopShoulder(fArray2, fArray4);
            GamepadMappings.mapCommonThumbstickButtons(fArray2, fArray4);
            GamepadMappings.mapCommonStartSelectMetaButtons(fArray2, fArray4);
            GamepadMappings.mapPedalAxesToBottomShoulder(fArray2, fArray3);
            GamepadMappings.mapHatAxisToDpadButtons(fArray2, fArray3);
            GamepadMappings.mapXYAxes(fArray, fArray3);
            GamepadMappings.mapZAndRZAxesToRightStick(fArray, fArray3);
        }
    }
}

