/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content_public.browser;

import android.content.Intent;
import android.graphics.Rect;
import android.view.ActionMode;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import org.chromium.content.browser.selection.SelectionPopupControllerImpl;

public abstract class ActionModeCallbackHelper {
    public static final String TAG = "ActionModeHelper";
    public static final int MAX_SEARCH_QUERY_LENGTH = 1000;
    public static final int MENU_ITEM_SHARE = 1;
    public static final int MENU_ITEM_WEB_SEARCH = 2;
    public static final int MENU_ITEM_PROCESS_TEXT = 4;
    public static final EmptyActionCallback EMPTY_CALLBACK = new EmptyActionCallback(null);

    public static String sanitizeQuery(String string2, int n2) {
        return SelectionPopupControllerImpl.sanitizeQuery(string2, n2);
    }

    public abstract boolean supportsFloatingActionMode();

    public abstract boolean isActionModeValid();

    public abstract void finishActionMode();

    public abstract String getSelectedText();

    public abstract void onReceivedProcessTextResult(int var1, Intent var2);

    public abstract void setAllowedMenuItems(int var1);

    public abstract void onCreateActionMode(ActionMode var1, Menu var2);

    public abstract boolean onPrepareActionMode(ActionMode var1, Menu var2);

    public abstract boolean onActionItemClicked(ActionMode var1, MenuItem var2);

    public abstract void onDestroyActionMode();

    public abstract void onGetContentRect(ActionMode var1, View var2, Rect var3);

    private static class EmptyActionCallback
    implements ActionMode.Callback {
        public EmptyActionCallback() {
        }

        public /* synthetic */ EmptyActionCallback(1 var1_1) {
        }

        public boolean onCreateActionMode(ActionMode actionMode, Menu menu2) {
            return false;
        }

        public boolean onPrepareActionMode(ActionMode actionMode, Menu menu2) {
            return false;
        }

        public boolean onActionItemClicked(ActionMode actionMode, MenuItem menuItem) {
            return false;
        }

        public void onDestroyActionMode(ActionMode actionMode) {
        }
    }
}

