/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.accessibility;

import android.annotation.TargetApi;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.accessibility.AccessibilityNodeInfo;
import java.util.Arrays;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.content.browser.accessibility.LollipopWebContentsAccessibility;
import org.chromium.content_public.browser.WebContents;

@JNINamespace(value="content")
@TargetApi(value=26)
public class OWebContentsAccessibility
extends LollipopWebContentsAccessibility {
    public static final /* synthetic */ boolean $assertionsDisabled;

    public OWebContentsAccessibility(WebContents webContents) {
        super(webContents);
    }

    static {
        $assertionsDisabled = OWebContentsAccessibility.class.desiredAssertionStatus() ^ true;
    }

    @Override
    public void setAccessibilityNodeInfoOAttributes(AccessibilityNodeInfo accessibilityNodeInfo, boolean bl) {
        if (!bl) {
            return;
        }
        accessibilityNodeInfo.setAvailableExtraData(Arrays.asList("android.view.accessibility.extra.DATA_TEXT_CHARACTER_LOCATION_KEY"));
    }

    @Override
    public void setAccessibilityNodeInfoKitKatAttributes(AccessibilityNodeInfo accessibilityNodeInfo, boolean bl, boolean bl2, String string2, String string3, String string4, int n2, int n3, boolean bl3, boolean bl4) {
        super.setAccessibilityNodeInfoKitKatAttributes(accessibilityNodeInfo, bl, bl2, string2, string3, string4, n2, n3, bl3, bl4);
        accessibilityNodeInfo.setHintText((CharSequence)string4);
    }

    public void addExtraDataToAccessibilityNodeInfo(int n2, AccessibilityNodeInfo accessibilityNodeInfo, String string2, Bundle bundle) {
        if (!string2.equals("android.view.accessibility.extra.DATA_TEXT_CHARACTER_LOCATION_KEY")) {
            return;
        }
        OWebContentsAccessibility oWebContentsAccessibility = this;
        if (!oWebContentsAccessibility.nativeAreInlineTextBoxesLoaded(oWebContentsAccessibility.mNativeObj, n2)) {
            OWebContentsAccessibility oWebContentsAccessibility2 = this;
            oWebContentsAccessibility2.nativeLoadInlineTextBoxes(oWebContentsAccessibility2.mNativeObj, n2);
        }
        Bundle bundle2 = bundle;
        int n3 = bundle2.getInt("android.view.accessibility.extra.DATA_TEXT_CHARACTER_LOCATION_ARG_START_INDEX", -1);
        int n4 = bundle2.getInt("android.view.accessibility.extra.DATA_TEXT_CHARACTER_LOCATION_ARG_LENGTH", -1);
        if (n4 > 0 && n3 >= 0) {
            OWebContentsAccessibility oWebContentsAccessibility3 = this;
            int[] nArray = oWebContentsAccessibility3.nativeGetCharacterBoundingBoxes(oWebContentsAccessibility3.mNativeObj, n2, n3, n4);
            if (nArray == null) {
                return;
            }
            if (!$assertionsDisabled && nArray.length != n4 * 4) {
                throw new AssertionError();
            }
            RectF[] rectFArray = new RectF[n4];
            for (int i2 = 0; i2 < n4; ++i2) {
                Rect rect;
                Rect rect2 = rect;
                int n5 = i2 * 4;
                this.convertWebRectToAndroidCoordinates(new Rect(nArray[n5 + 0], nArray[n5 + 1], nArray[n5 + 2], nArray[n5 + 3]));
                rectFArray[i2] = new RectF(rect2);
            }
            accessibilityNodeInfo.getExtras().putParcelableArray(string2, (Parcelable[])rectFArray);
            return;
        }
    }
}

