/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import a.b.a.l;
import a.b.d.a.m;
import a.b.d.a.n;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.content_public.browser.WebContents;
import org.chromium.services.media_session.MediaImage;
import org.chromium.services.media_session.MediaMetadata;

@JNINamespace(value="content")
public class MediaSessionImpl
extends m {
    public static final /* synthetic */ boolean $assertionsDisabled;
    public long mNativeMediaSessionAndroid;
    public l<n> mObservers;
    public l.b<n> mObserversIterator;

    public static MediaSessionImpl fromWebContents(WebContents webContents) {
        return MediaSessionImpl.nativeGetMediaSessionFromWebContents(webContents);
    }

    private boolean hasObservers() {
        return this.mObservers.isEmpty() ^ true;
    }

    private void mediaSessionDestroyed() {
        ((l.a)this.mObserversIterator).b();
        while (this.mObserversIterator.hasNext()) {
            ((n)this.mObserversIterator.next()).a();
        }
        ((l.a)this.mObserversIterator).b();
        while (this.mObserversIterator.hasNext()) {
            ((n)this.mObserversIterator.next()).b();
        }
        this.mObservers.clear();
        this.mNativeMediaSessionAndroid = 0L;
    }

    private void mediaSessionStateChanged(boolean bl, boolean bl2) {
        ((l.a)this.mObserversIterator).b();
        while (this.mObserversIterator.hasNext()) {
            ((n)this.mObserversIterator.next()).a(bl, bl2);
        }
    }

    private void mediaSessionMetadataChanged(MediaMetadata mediaMetadata) {
        ((l.a)this.mObserversIterator).b();
        while (this.mObserversIterator.hasNext()) {
            ((n)this.mObserversIterator.next()).a(mediaMetadata);
        }
    }

    private void mediaSessionActionsChanged(int[] nArray) {
        HashSet<Integer> hashSet;
        HashSet<Integer> hashSet2 = hashSet;
        hashSet = new HashSet<Integer>();
        int n2 = nArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            hashSet2.add(nArray[i2]);
        }
        ((l.a)this.mObserversIterator).b();
        while (this.mObserversIterator.hasNext()) {
            ((n)this.mObserversIterator.next()).a(hashSet2);
        }
    }

    private void mediaSessionArtworkChanged(MediaImage[] object) {
        object = Arrays.asList(object);
        ((l.a)this.mObserversIterator).b();
        while (this.mObserversIterator.hasNext()) {
            ((n)this.mObserversIterator.next()).a((List<MediaImage>)object);
        }
    }

    public static MediaSessionImpl create(long l2) {
        return new MediaSessionImpl(l2);
    }

    public MediaSessionImpl(long l2) {
        this.mNativeMediaSessionAndroid = l2;
        this.mObservers = new l();
        this.mObserversIterator = this.mObservers.a();
    }

    private native void nativeResume(long var1);

    private native void nativeSuspend(long var1);

    private native void nativeStop(long var1);

    private native void nativeSeek(long var1, long var3);

    private native void nativeDidReceiveAction(long var1, int var3);

    private native void nativeRequestSystemAudioFocus(long var1);

    public static native MediaSessionImpl nativeGetMediaSessionFromWebContents(WebContents var0);

    static {
        $assertionsDisabled = MediaSessionImpl.class.desiredAssertionStatus() ^ true;
    }

    public void addObserver(n n2) {
        this.mObservers.a(n2);
    }

    public void removeObserver(n n2) {
        this.mObservers.b(n2);
    }

    @Override
    public l.b<n> getObserversForTesting() {
        return this.mObservers.a();
    }

    @Override
    public void resume() {
        MediaSessionImpl mediaSessionImpl = this;
        mediaSessionImpl.nativeResume(mediaSessionImpl.mNativeMediaSessionAndroid);
    }

    @Override
    public void suspend() {
        MediaSessionImpl mediaSessionImpl = this;
        mediaSessionImpl.nativeSuspend(mediaSessionImpl.mNativeMediaSessionAndroid);
    }

    @Override
    public void stop() {
        MediaSessionImpl mediaSessionImpl = this;
        mediaSessionImpl.nativeStop(mediaSessionImpl.mNativeMediaSessionAndroid);
    }

    @Override
    public void seek(long l2) {
        if (!$assertionsDisabled && l2 != 0L) {
            throw new AssertionError((Object)"Attempted to seek by an unspecified number of milliseconds");
        }
        MediaSessionImpl mediaSessionImpl = this;
        mediaSessionImpl.nativeSeek(mediaSessionImpl.mNativeMediaSessionAndroid, l2);
    }

    @Override
    public void didReceiveAction(int n2) {
        MediaSessionImpl mediaSessionImpl = this;
        mediaSessionImpl.nativeDidReceiveAction(mediaSessionImpl.mNativeMediaSessionAndroid, n2);
    }

    @Override
    public void requestSystemAudioFocus() {
        MediaSessionImpl mediaSessionImpl = this;
        mediaSessionImpl.nativeRequestSystemAudioFocus(mediaSessionImpl.mNativeMediaSessionAndroid);
    }
}

