/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import a.b.a.e;
import a.b.a.l;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.support.annotation.AnyThread;
import android.support.annotation.MainThread;
import android.support.annotation.Nullable;
import android.view.Window;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;
import org.chromium.base.ThreadUtils;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="base::android")
public class ApplicationStatus {
    public static final String TOOLBAR_CALLBACK_INTERNAL_WRAPPER_CLASS = "android.support.v7.internal.app.ToolbarActionBar$ToolbarCallbackWrapper";
    public static final String TOOLBAR_CALLBACK_WRAPPER_CLASS = "android.support.v7.app.ToolbarActionBar$ToolbarCallbackWrapper";
    public static final String WINDOW_PROFILER_CALLBACK = "com.android.tools.profiler.support.event.WindowProfilerCallback";
    public static final Map<Activity, ActivityInfo> sActivityInfo;
    @SuppressLint(value={"SupportAnnotationUsage"})
    @GuardedBy(value="sActivityInfo")
    public static int sCurrentApplicationState;
    @SuppressLint(value={"StaticFieldLeak"})
    public static Activity sActivity;
    public static ApplicationStateListener sNativeApplicationStateListener;
    public static final l<ActivityStateListener> sGeneralActivityStateListeners;
    public static final l<ApplicationStateListener> sApplicationStateListeners;
    public static final l<WindowFocusChangedListener> sWindowFocusListeners;
    public static final /* synthetic */ boolean $assertionsDisabled;

    @MainThread
    public static void registerWindowFocusChangedListener(WindowFocusChangedListener windowFocusChangedListener) {
        if (!$assertionsDisabled && !ApplicationStatus.isInitialized()) {
            throw new AssertionError();
        }
        sWindowFocusListeners.a(windowFocusChangedListener);
    }

    @MainThread
    public static void unregisterWindowFocusChangedListener(WindowFocusChangedListener windowFocusChangedListener) {
        sWindowFocusListeners.b(windowFocusChangedListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInitialized() {
        Map<Activity, ActivityInfo> map = sActivityInfo;
        synchronized (map) {
            boolean bl = sCurrentApplicationState != 0;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @MainThread
    public static void initialize(Application object) {
        if (!$assertionsDisabled && ApplicationStatus.isInitialized()) {
            throw new AssertionError();
        }
        Object object2 = object;
        object = sActivityInfo;
        synchronized (object) {
            sCurrentApplicationState = 4;
        }
        ApplicationStatus.registerWindowFocusChangedListener(new WindowFocusChangedListener(){

            @Override
            public void onWindowFocusChanged(Activity activity, boolean bl) {
                if (bl && activity != sActivity) {
                    int n2 = ApplicationStatus.getStateForActivity(activity);
                    if (n2 != 6 && n2 != 5) {
                        sActivity = activity;
                    }
                    return;
                }
            }
        });
        object2.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){
            public static final /* synthetic */ boolean $assertionsDisabled;

            private void checkCallback(Activity activity) {
                if (e.c) {
                    Class<?> clazz = activity.getWindow().getCallback().getClass();
                    if (!($assertionsDisabled || Proxy.isProxyClass(clazz) || clazz.getName().equals(ApplicationStatus.TOOLBAR_CALLBACK_WRAPPER_CLASS) || clazz.getName().equals(ApplicationStatus.TOOLBAR_CALLBACK_INTERNAL_WRAPPER_CLASS) || clazz.getName().equals(ApplicationStatus.WINDOW_PROFILER_CALLBACK))) {
                        throw new AssertionError();
                    }
                }
            }

            static {
                $assertionsDisabled = ApplicationStatus.class.desiredAssertionStatus() ^ true;
            }

            public void onActivityCreated(Activity activity, Bundle bundle) {
                Activity activity2 = activity;
                ApplicationStatus.onStateChange(activity2, 1);
                2 this_ = activity2.getWindow().getCallback();
                activity2.getWindow().setCallback((Window.Callback)Proxy.newProxyInstance(Window.Callback.class.getClassLoader(), new Class[]{Window.Callback.class}, (InvocationHandler)new WindowCallbackProxy(activity, (Window.Callback)this_)));
            }

            public void onActivityDestroyed(Activity activity) {
                Activity activity2 = activity;
                ApplicationStatus.onStateChange(activity2, 6);
                this.checkCallback(activity2);
            }

            public void onActivityPaused(Activity activity) {
                Activity activity2 = activity;
                ApplicationStatus.onStateChange(activity2, 4);
                this.checkCallback(activity2);
            }

            public void onActivityResumed(Activity activity) {
                Activity activity2 = activity;
                ApplicationStatus.onStateChange(activity2, 3);
                this.checkCallback(activity2);
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
                this.checkCallback(activity);
            }

            public void onActivityStarted(Activity activity) {
                Activity activity2 = activity;
                ApplicationStatus.onStateChange(activity2, 2);
                this.checkCallback(activity2);
            }

            public void onActivityStopped(Activity activity) {
                Activity activity2 = activity;
                ApplicationStatus.onStateChange(activity2, 5);
                this.checkCallback(activity2);
            }
        });
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void onStateChange(Activity var0, int var1_3) {
        if (var0 == null) {
            throw new IllegalArgumentException("null activity is not supported");
        }
        if (ApplicationStatus.sActivity == null || var1_3 == 1 || var1_3 == 3 || var1_3 == 2) {
            ApplicationStatus.sActivity = var0;
        }
        var2_5 = ApplicationStatus.getStateForApplication();
        var3_6 = ApplicationStatus.sActivityInfo;
        synchronized (var3_6) {
            if (var1_3 != 1) ** GOTO lbl14
            if (!ApplicationStatus.$assertionsDisabled && ApplicationStatus.sActivityInfo.containsKey(var0)) {
                throw new AssertionError();
            }
            ApplicationStatus.sActivityInfo.put(var0, new ActivityInfo());
lbl14:
            // 2 sources

            var4_7 = ApplicationStatus.sActivityInfo.get(var0);
            var4_7.setStatus(var1_3);
            if (var1_3 == 6) {
                ApplicationStatus.sActivityInfo.remove(var0);
                if (var0 == ApplicationStatus.sActivity) {
                }
            }
            ** GOTO lbl26
            {
                catch (Throwable var0_2) {}
                {
                    throw var0_2;
                }
            }
            {
                ApplicationStatus.sActivity = null;
lbl26:
                // 2 sources

                ApplicationStatus.sCurrentApplicationState = ApplicationStatus.determineApplicationStateLocked();
                // MONITOREXIT @DISABLED, blocks:[1, 3] lbl28 : MonitorExitStatement: MONITOREXIT : var3_6
                var3_6 = var4_7.getListeners().iterator();
            }
        }
        while (var3_6.hasNext()) {
            ((ActivityStateListener)var3_6.next()).onActivityStateChange(var0, var1_3);
        }
        var3_6 = ApplicationStatus.sGeneralActivityStateListeners.iterator();
        while (var3_6.hasNext()) {
            var3_6.next().onActivityStateChange(var0, var1_3);
        }
        var0_1 = ApplicationStatus.getStateForApplication();
        if (var0_1 != var2_5) {
            var1_4 = ApplicationStatus.sApplicationStateListeners.iterator();
            while (var1_4.hasNext()) {
                var1_4.next().onApplicationStateChange(var0_1);
            }
        }
    }

    @MainThread
    public static void onStateChangeForTesting(Activity activity, int n2) {
        ApplicationStatus.onStateChange(activity, n2);
    }

    @MainThread
    public static Activity getLastTrackedFocusedActivity() {
        return sActivity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    public static List<Activity> getRunningActivities() {
        if (!$assertionsDisabled && !ApplicationStatus.isInitialized()) {
            throw new AssertionError();
        }
        Map<Activity, ActivityInfo> map = sActivityInfo;
        synchronized (map) {
            return new ArrayList<Activity>(sActivityInfo.keySet());
        }
    }

    @AnyThread
    public static int getStateForActivity(@Nullable Activity object) {
        if (!$assertionsDisabled && !ApplicationStatus.isInitialized()) {
            throw new AssertionError();
        }
        if (object == null) {
            return 6;
        }
        return (object = sActivityInfo.get(object)) != null ? ((ActivityInfo)object).getStatus() : 6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    public static int getStateForApplication() {
        Map<Activity, ActivityInfo> map = sActivityInfo;
        synchronized (map) {
            return sCurrentApplicationState;
        }
    }

    @AnyThread
    public static boolean hasVisibleActivities() {
        if (!$assertionsDisabled && !ApplicationStatus.isInitialized()) {
            throw new AssertionError();
        }
        int n2 = ApplicationStatus.getStateForApplication();
        return n2 == 1 || n2 == 2;
    }

    @AnyThread
    public static boolean isEveryActivityDestroyed() {
        if (!$assertionsDisabled && !ApplicationStatus.isInitialized()) {
            throw new AssertionError();
        }
        return sActivityInfo.isEmpty();
    }

    @MainThread
    public static void registerStateListenerForAllActivities(ActivityStateListener activityStateListener) {
        if (!$assertionsDisabled && !ApplicationStatus.isInitialized()) {
            throw new AssertionError();
        }
        sGeneralActivityStateListeners.a(activityStateListener);
    }

    @MainThread
    @SuppressLint(value={"NewApi"})
    public static void registerStateListenerForActivity(ActivityStateListener activityStateListener, Activity object) {
        if (!$assertionsDisabled && !ApplicationStatus.isInitialized()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && object == null) {
            throw new AssertionError();
        }
        object = sActivityInfo.get(object);
        if (!$assertionsDisabled && ((ActivityInfo)object).getStatus() == 6) {
            throw new AssertionError();
        }
        ((ActivityInfo)object).getListeners().a(activityStateListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @MainThread
    public static void unregisterActivityStateListener(ActivityStateListener activityStateListener) {
        sGeneralActivityStateListeners.b(activityStateListener);
        Map<Activity, ActivityInfo> map = sActivityInfo;
        synchronized (map) {
            Iterator<ActivityInfo> iterator = sActivityInfo.values().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return;
                }
                iterator.next().getListeners().b(activityStateListener);
            }
        }
    }

    @MainThread
    public static void registerApplicationStateListener(ApplicationStateListener applicationStateListener) {
        sApplicationStateListeners.a(applicationStateListener);
    }

    @MainThread
    public static void unregisterApplicationStateListener(ApplicationStateListener applicationStateListener) {
        sApplicationStateListeners.b(applicationStateListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public static void destroyForJUnitTests() {
        Map<Activity, ActivityInfo> map = sActivityInfo;
        synchronized (map) {
            sApplicationStateListeners.clear();
            sGeneralActivityStateListeners.clear();
            sActivityInfo.clear();
            sWindowFocusListeners.clear();
            sCurrentApplicationState = 0;
            sActivity = null;
            sNativeApplicationStateListener = null;
            return;
        }
    }

    public static void registerThreadSafeNativeApplicationStateListener() {
        ThreadUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (sNativeApplicationStateListener != null) {
                    return;
                }
                sNativeApplicationStateListener = new ApplicationStateListener(){

                    @Override
                    public void onApplicationStateChange(int n2) {
                        ApplicationStatus.nativeOnApplicationStateChange(n2);
                    }
                };
                sApplicationStateListeners.a(sNativeApplicationStateListener);
            }
        });
    }

    @GuardedBy(value="sActivityInfo")
    public static int determineApplicationStateLocked() {
        boolean bl = false;
        boolean bl2 = false;
        Iterator<ActivityInfo> iterator = sActivityInfo.values().iterator();
        while (iterator.hasNext()) {
            int n2 = iterator.next().getStatus();
            if (n2 != 4 && n2 != 5 && n2 != 6) {
                return 1;
            }
            if (n2 == 4) {
                bl = true;
                continue;
            }
            if (n2 != 5) continue;
            bl2 = true;
        }
        if (bl) {
            return 2;
        }
        if (bl2) {
            return 3;
        }
        return 4;
    }

    public static native void nativeOnApplicationStateChange(int var0);

    public static /* synthetic */ l access$000() {
        return sWindowFocusListeners;
    }

    public static /* synthetic */ Activity access$100() {
        return sActivity;
    }

    public static /* synthetic */ Activity access$102(Activity activity) {
        sActivity = activity;
        return sActivity;
    }

    public static /* synthetic */ void access$200(Activity activity, int n2) {
        ApplicationStatus.onStateChange(activity, n2);
    }

    public static /* synthetic */ ApplicationStateListener access$400() {
        return sNativeApplicationStateListener;
    }

    public static /* synthetic */ ApplicationStateListener access$402(ApplicationStateListener applicationStateListener) {
        sNativeApplicationStateListener = applicationStateListener;
        return sNativeApplicationStateListener;
    }

    public static /* synthetic */ void access$500(int n2) {
        ApplicationStatus.nativeOnApplicationStateChange(n2);
    }

    static {
        $assertionsDisabled = ApplicationStatus.class.desiredAssertionStatus() ^ true;
        sActivityInfo = Collections.synchronizedMap(new HashMap());
        sCurrentApplicationState = 0;
        sGeneralActivityStateListeners = new l();
        sApplicationStateListeners = new l();
        sWindowFocusListeners = new l();
    }

    private static class WindowCallbackProxy
    implements InvocationHandler {
        public final Window.Callback mCallback;
        public final Activity mActivity;

        public WindowCallbackProxy(Activity activity, Window.Callback callback) {
            this.mCallback = callback;
            this.mActivity = activity;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) {
            if (method.getName().equals("onWindowFocusChanged") && objectArray.length == 1 && objectArray[0] instanceof Boolean) {
                this.onWindowFocusChanged((Boolean)objectArray[0]);
                return null;
            }
            try {
                return method.invoke((Object)this.mCallback, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getCause() instanceof AbstractMethodError) {
                    throw invocationTargetException.getCause();
                }
                throw invocationTargetException;
            }
        }

        public void onWindowFocusChanged(boolean bl) {
            this.mCallback.onWindowFocusChanged(bl);
            Iterator<WindowFocusChangedListener> iterator = sWindowFocusListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onWindowFocusChanged(this.mActivity, bl);
            }
        }
    }

    public static interface WindowFocusChangedListener {
        public void onWindowFocusChanged(Activity var1, boolean var2);
    }

    public static interface ActivityStateListener {
        public void onActivityStateChange(Activity var1, int var2);
    }

    public static interface ApplicationStateListener {
        public void onApplicationStateChange(int var1);
    }

    private static class ActivityInfo {
        public int mStatus = 6;
        public l<ActivityStateListener> mListeners = new l();

        public ActivityInfo() {
        }

        public /* synthetic */ ActivityInfo(1 var1_1) {
            this();
        }

        public int getStatus() {
            return this.mStatus;
        }

        public void setStatus(int n2) {
            this.mStatus = n2;
        }

        public l<ActivityStateListener> getListeners() {
            return this.mListeners;
        }
    }
}

