
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/viz/public/interfaces/compositing/quads.mojom
//

package com.vccorp.viz.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class TileQuadState extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 32;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public com.vccorp.gfx.mojom.RectF texCoordRect;
    public com.vccorp.gfx.mojom.Size textureSize;
    public boolean swizzleContents;
    public boolean isPremultiplied;
    public int resourceId;
    public boolean nearestNeighbor;
    public boolean forceAntiAliasingOff;

    private TileQuadState(int version) {
        super(STRUCT_SIZE, version);
    }

    public TileQuadState() {
        this(0);
    }

    public static TileQuadState deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static TileQuadState deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static TileQuadState decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        TileQuadState result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new TileQuadState(elementsOrVersion);
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                result.texCoordRect = com.vccorp.gfx.mojom.RectF.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                result.textureSize = com.vccorp.gfx.mojom.Size.decode(decoder1);
                }
                {
                    
                result.swizzleContents = decoder0.readBoolean(24, 0);
                }
                {
                    
                result.isPremultiplied = decoder0.readBoolean(24, 1);
                }
                {
                    
                result.nearestNeighbor = decoder0.readBoolean(24, 2);
                }
                {
                    
                result.forceAntiAliasingOff = decoder0.readBoolean(24, 3);
                }
                {
                    
                result.resourceId = decoder0.readInt(28);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.texCoordRect, 8, false);
        
        encoder0.encode(this.textureSize, 16, false);
        
        encoder0.encode(this.swizzleContents, 24, 0);
        
        encoder0.encode(this.isPremultiplied, 24, 1);
        
        encoder0.encode(this.nearestNeighbor, 24, 2);
        
        encoder0.encode(this.forceAntiAliasingOff, 24, 3);
        
        encoder0.encode(this.resourceId, 28);
    }
}