
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/viz/public/interfaces/compositing/compositor_frame_metadata.mojom
//

package com.vccorp.viz.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class CompositorFrameMetadata extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 136;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(136, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public float deviceScaleFactor;
    public com.vccorp.gfx.mojom.Vector2dF rootScrollOffset;
    public float pageScaleFactor;
    public com.vccorp.gfx.mojom.SizeF scrollableViewportSize;
    public boolean mayContainVideo;
    public boolean isResourcelessSoftwareDrawWithScrollOrAnimation;
    public int rootBackgroundColor;
    public com.vccorp.ui.mojom.LatencyInfo[] latencyInfo;
    public SurfaceRange[] referencedSurfaces;
    public FrameDeadline deadline;
    public SurfaceId[] activationDependencies;
    public int contentSourceId;
    public BeginFrameAck beginFrameAck;
    public int frameToken;
    public boolean sendFrameTokenToEmbedder;
    public float minPageScaleFactor;
    public float maxPageScaleFactor;
    public com.vccorp.gfx.mojom.SizeF rootLayerSize;
    public boolean rootOverflowYHidden;
    public float topControlsHeight;
    public float topControlsShownRatio;
    public com.vccorp.mojo_base.mojom.TimeTicks localSurfaceIdAllocationTime;
    public float bottomControlsHeight;
    public float bottomControlsShownRatio;
    public Selection selection;

    private CompositorFrameMetadata(int version) {
        super(STRUCT_SIZE, version);
    }

    public CompositorFrameMetadata() {
        this(0);
    }

    public static CompositorFrameMetadata deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static CompositorFrameMetadata deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static CompositorFrameMetadata decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        CompositorFrameMetadata result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new CompositorFrameMetadata(elementsOrVersion);
                {
                    
                result.deviceScaleFactor = decoder0.readFloat(8);
                }
                {
                    
                result.pageScaleFactor = decoder0.readFloat(12);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                result.rootScrollOffset = com.vccorp.gfx.mojom.Vector2dF.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                result.scrollableViewportSize = com.vccorp.gfx.mojom.SizeF.decode(decoder1);
                }
                {
                    
                result.mayContainVideo = decoder0.readBoolean(32, 0);
                }
                {
                    
                result.isResourcelessSoftwareDrawWithScrollOrAnimation = decoder0.readBoolean(32, 1);
                }
                {
                    
                result.sendFrameTokenToEmbedder = decoder0.readBoolean(32, 2);
                }
                {
                    
                result.rootOverflowYHidden = decoder0.readBoolean(32, 3);
                }
                {
                    
                result.rootBackgroundColor = decoder0.readInt(36);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(40, false);
                {
                    com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    result.latencyInfo = new com.vccorp.ui.mojom.LatencyInfo[si1.elementsOrVersion];
                    for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                        
                        com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                        result.latencyInfo[i1] = com.vccorp.ui.mojom.LatencyInfo.decode(decoder2);
                    }
                }
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(48, false);
                {
                    com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    result.referencedSurfaces = new SurfaceRange[si1.elementsOrVersion];
                    for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                        
                        com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                        result.referencedSurfaces[i1] = SurfaceRange.decode(decoder2);
                    }
                }
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(56, false);
                result.deadline = FrameDeadline.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(64, false);
                {
                    com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    result.activationDependencies = new SurfaceId[si1.elementsOrVersion];
                    for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                        
                        com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                        result.activationDependencies[i1] = SurfaceId.decode(decoder2);
                    }
                }
                }
                {
                    
                result.contentSourceId = decoder0.readInt(72);
                }
                {
                    
                result.frameToken = decoder0.readInt(76);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(80, false);
                result.beginFrameAck = BeginFrameAck.decode(decoder1);
                }
                {
                    
                result.minPageScaleFactor = decoder0.readFloat(88);
                }
                {
                    
                result.maxPageScaleFactor = decoder0.readFloat(92);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(96, false);
                result.rootLayerSize = com.vccorp.gfx.mojom.SizeF.decode(decoder1);
                }
                {
                    
                result.topControlsHeight = decoder0.readFloat(104);
                }
                {
                    
                result.topControlsShownRatio = decoder0.readFloat(108);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(112, false);
                result.localSurfaceIdAllocationTime = com.vccorp.mojo_base.mojom.TimeTicks.decode(decoder1);
                }
                {
                    
                result.bottomControlsHeight = decoder0.readFloat(120);
                }
                {
                    
                result.bottomControlsShownRatio = decoder0.readFloat(124);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(128, false);
                result.selection = Selection.decode(decoder1);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.deviceScaleFactor, 8);
        
        encoder0.encode(this.pageScaleFactor, 12);
        
        encoder0.encode(this.rootScrollOffset, 16, false);
        
        encoder0.encode(this.scrollableViewportSize, 24, false);
        
        encoder0.encode(this.mayContainVideo, 32, 0);
        
        encoder0.encode(this.isResourcelessSoftwareDrawWithScrollOrAnimation, 32, 1);
        
        encoder0.encode(this.sendFrameTokenToEmbedder, 32, 2);
        
        encoder0.encode(this.rootOverflowYHidden, 32, 3);
        
        encoder0.encode(this.rootBackgroundColor, 36);
        
        if (this.latencyInfo == null) {
            encoder0.encodeNullPointer(40, false);
        } else {
            org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.latencyInfo.length, 40, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            for (int i0 = 0; i0 < this.latencyInfo.length; ++i0) {
                
                encoder1.encode(this.latencyInfo[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
            }
        }
        
        if (this.referencedSurfaces == null) {
            encoder0.encodeNullPointer(48, false);
        } else {
            org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.referencedSurfaces.length, 48, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            for (int i0 = 0; i0 < this.referencedSurfaces.length; ++i0) {
                
                encoder1.encode(this.referencedSurfaces[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
            }
        }
        
        encoder0.encode(this.deadline, 56, false);
        
        if (this.activationDependencies == null) {
            encoder0.encodeNullPointer(64, false);
        } else {
            org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.activationDependencies.length, 64, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            for (int i0 = 0; i0 < this.activationDependencies.length; ++i0) {
                
                encoder1.encode(this.activationDependencies[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
            }
        }
        
        encoder0.encode(this.contentSourceId, 72);
        
        encoder0.encode(this.frameToken, 76);
        
        encoder0.encode(this.beginFrameAck, 80, false);
        
        encoder0.encode(this.minPageScaleFactor, 88);
        
        encoder0.encode(this.maxPageScaleFactor, 92);
        
        encoder0.encode(this.rootLayerSize, 96, false);
        
        encoder0.encode(this.topControlsHeight, 104);
        
        encoder0.encode(this.topControlsShownRatio, 108);
        
        encoder0.encode(this.localSurfaceIdAllocationTime, 112, false);
        
        encoder0.encode(this.bottomControlsHeight, 120);
        
        encoder0.encode(this.bottomControlsShownRatio, 124);
        
        encoder0.encode(this.selection, 128, false);
    }
}