
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/proxy_resolver/public/mojom/proxy_resolver.mojom
//

package com.vccorp.proxy_resolver.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class ProxyResolverRequestClient_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<ProxyResolverRequestClient, ProxyResolverRequestClient.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<ProxyResolverRequestClient, ProxyResolverRequestClient.Proxy>() {

        @Override
        public String getName() {
            return "proxy_resolver.mojom.ProxyResolverRequestClient";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, ProxyResolverRequestClient impl) {
            return new Stub(core, impl);
        }

        @Override
        public ProxyResolverRequestClient[] buildArray(int size) {
          return new ProxyResolverRequestClient[size];
        }
    };


    private static final int REPORT_RESULT_ORDINAL = 0;

    private static final int ALERT_ORDINAL = 1;

    private static final int ON_ERROR_ORDINAL = 2;

    private static final int RESOLVE_DNS_ORDINAL = 3;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements ProxyResolverRequestClient.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void reportResult(
int error, ProxyInfo proxyInfo) {

            ProxyResolverRequestClientReportResultParams _message = new ProxyResolverRequestClientReportResultParams();

            _message.error = error;

            _message.proxyInfo = proxyInfo;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(REPORT_RESULT_ORDINAL)));

        }


        @Override
        public void alert(
String error) {

            ProxyResolverRequestClientAlertParams _message = new ProxyResolverRequestClientAlertParams();

            _message.error = error;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ALERT_ORDINAL)));

        }


        @Override
        public void onError(
int lineNumber, String error) {

            ProxyResolverRequestClientOnErrorParams _message = new ProxyResolverRequestClientOnErrorParams();

            _message.lineNumber = lineNumber;

            _message.error = error;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_ERROR_ORDINAL)));

        }


        @Override
        public void resolveDns(
String host, int operation, HostResolverRequestClient client) {

            ProxyResolverRequestClientResolveDnsParams _message = new ProxyResolverRequestClientResolveDnsParams();

            _message.host = host;

            _message.operation = operation;

            _message.client = client;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(RESOLVE_DNS_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<ProxyResolverRequestClient> {

        Stub(com.vccorp.mojo.system.Core core, ProxyResolverRequestClient impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                ProxyResolverRequestClient_Internal.MANAGER, messageWithHeader);





                    case REPORT_RESULT_ORDINAL: {

                        ProxyResolverRequestClientReportResultParams data =
                                ProxyResolverRequestClientReportResultParams.deserialize(messageWithHeader.getPayload());

                        getImpl().reportResult(data.error, data.proxyInfo);
                        return true;
                    }





                    case ALERT_ORDINAL: {

                        ProxyResolverRequestClientAlertParams data =
                                ProxyResolverRequestClientAlertParams.deserialize(messageWithHeader.getPayload());

                        getImpl().alert(data.error);
                        return true;
                    }





                    case ON_ERROR_ORDINAL: {

                        ProxyResolverRequestClientOnErrorParams data =
                                ProxyResolverRequestClientOnErrorParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onError(data.lineNumber, data.error);
                        return true;
                    }





                    case RESOLVE_DNS_ORDINAL: {

                        ProxyResolverRequestClientResolveDnsParams data =
                                ProxyResolverRequestClientResolveDnsParams.deserialize(messageWithHeader.getPayload());

                        getImpl().resolveDns(data.host, data.operation, data.client);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), ProxyResolverRequestClient_Internal.MANAGER, messageWithHeader, receiver);










                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class ProxyResolverRequestClientReportResultParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int error;
        public ProxyInfo proxyInfo;

        private ProxyResolverRequestClientReportResultParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ProxyResolverRequestClientReportResultParams() {
            this(0);
        }

        public static ProxyResolverRequestClientReportResultParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ProxyResolverRequestClientReportResultParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ProxyResolverRequestClientReportResultParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ProxyResolverRequestClientReportResultParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ProxyResolverRequestClientReportResultParams(elementsOrVersion);
                    {
                        
                    result.error = decoder0.readInt(8);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.proxyInfo = ProxyInfo.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.error, 8);
            
            encoder0.encode(this.proxyInfo, 16, false);
        }
    }



    
    static final class ProxyResolverRequestClientAlertParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String error;

        private ProxyResolverRequestClientAlertParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ProxyResolverRequestClientAlertParams() {
            this(0);
        }

        public static ProxyResolverRequestClientAlertParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ProxyResolverRequestClientAlertParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ProxyResolverRequestClientAlertParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ProxyResolverRequestClientAlertParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ProxyResolverRequestClientAlertParams(elementsOrVersion);
                    {
                        
                    result.error = decoder0.readString(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.error, 8, false);
        }
    }



    
    static final class ProxyResolverRequestClientOnErrorParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int lineNumber;
        public String error;

        private ProxyResolverRequestClientOnErrorParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ProxyResolverRequestClientOnErrorParams() {
            this(0);
        }

        public static ProxyResolverRequestClientOnErrorParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ProxyResolverRequestClientOnErrorParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ProxyResolverRequestClientOnErrorParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ProxyResolverRequestClientOnErrorParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ProxyResolverRequestClientOnErrorParams(elementsOrVersion);
                    {
                        
                    result.lineNumber = decoder0.readInt(8);
                    }
                    {
                        
                    result.error = decoder0.readString(16, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.lineNumber, 8);
            
            encoder0.encode(this.error, 16, false);
        }
    }



    
    static final class ProxyResolverRequestClientResolveDnsParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String host;
        public int operation;
        public HostResolverRequestClient client;

        private ProxyResolverRequestClientResolveDnsParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ProxyResolverRequestClientResolveDnsParams() {
            this(0);
        }

        public static ProxyResolverRequestClientResolveDnsParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ProxyResolverRequestClientResolveDnsParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ProxyResolverRequestClientResolveDnsParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ProxyResolverRequestClientResolveDnsParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ProxyResolverRequestClientResolveDnsParams(elementsOrVersion);
                    {
                        
                    result.host = decoder0.readString(8, false);
                    }
                    {
                        
                    result.operation = decoder0.readInt(16);
                        HostResolveOperation.validate(result.operation);
                    }
                    {
                        
                    result.client = decoder0.readServiceInterface(20, false, HostResolverRequestClient.MANAGER);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.host, 8, false);
            
            encoder0.encode(this.operation, 16);
            
            encoder0.encode(this.client, 20, false, HostResolverRequestClient.MANAGER);
        }
    }



}
