
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     components/payments/mojom/payment_request_data.mojom
//

package com.vccorp.payments.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class AddressErrors extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 88;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(88, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public String addressLine;
    public String city;
    public String country;
    public String dependentLocality;
    public String organization;
    public String phone;
    public String postalCode;
    public String recipient;
    public String region;
    public String sortingCode;

    private AddressErrors(int version) {
        super(STRUCT_SIZE, version);
    }

    public AddressErrors() {
        this(0);
    }

    public static AddressErrors deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static AddressErrors deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static AddressErrors decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        AddressErrors result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new AddressErrors(elementsOrVersion);
                {
                    
                result.addressLine = decoder0.readString(8, false);
                }
                {
                    
                result.city = decoder0.readString(16, false);
                }
                {
                    
                result.country = decoder0.readString(24, false);
                }
                {
                    
                result.dependentLocality = decoder0.readString(32, false);
                }
                {
                    
                result.organization = decoder0.readString(40, false);
                }
                {
                    
                result.phone = decoder0.readString(48, false);
                }
                {
                    
                result.postalCode = decoder0.readString(56, false);
                }
                {
                    
                result.recipient = decoder0.readString(64, false);
                }
                {
                    
                result.region = decoder0.readString(72, false);
                }
                {
                    
                result.sortingCode = decoder0.readString(80, false);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.addressLine, 8, false);
        
        encoder0.encode(this.city, 16, false);
        
        encoder0.encode(this.country, 24, false);
        
        encoder0.encode(this.dependentLocality, 32, false);
        
        encoder0.encode(this.organization, 40, false);
        
        encoder0.encode(this.phone, 48, false);
        
        encoder0.encode(this.postalCode, 56, false);
        
        encoder0.encode(this.recipient, 64, false);
        
        encoder0.encode(this.region, 72, false);
        
        encoder0.encode(this.sortingCode, 80, false);
    }
}