
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/network/public/mojom/network_interface.mojom
//

package com.vccorp.network.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class NetworkInterface extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 48;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(48, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public String name;
    public String friendlyName;
    public int interfaceIndex;
    public int type;
    public IpAddress address;
    public int prefixLength;
    public int ipAddressAttributes;

    private NetworkInterface(int version) {
        super(STRUCT_SIZE, version);
    }

    public NetworkInterface() {
        this(0);
    }

    public static NetworkInterface deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static NetworkInterface deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static NetworkInterface decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        NetworkInterface result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new NetworkInterface(elementsOrVersion);
                {
                    
                result.name = decoder0.readString(8, false);
                }
                {
                    
                result.friendlyName = decoder0.readString(16, false);
                }
                {
                    
                result.interfaceIndex = decoder0.readInt(24);
                }
                {
                    
                result.type = decoder0.readInt(28);
                    ConnectionType.validate(result.type);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, false);
                result.address = IpAddress.decode(decoder1);
                }
                {
                    
                result.prefixLength = decoder0.readInt(40);
                }
                {
                    
                result.ipAddressAttributes = decoder0.readInt(44);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.name, 8, false);
        
        encoder0.encode(this.friendlyName, 16, false);
        
        encoder0.encode(this.interfaceIndex, 24);
        
        encoder0.encode(this.type, 28);
        
        encoder0.encode(this.address, 32, false);
        
        encoder0.encode(this.prefixLength, 40);
        
        encoder0.encode(this.ipAddressAttributes, 44);
    }
}