
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/network/public/mojom/network_context.mojom
//

package com.vccorp.network.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class NetworkContextParams extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 192;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(192, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public String contextName;
    public String userAgent;
    public String acceptLanguage;
    public boolean enableBrotli;
    public String quicUserAgentId;
    public boolean enableReferrers;
    public boolean validateReferrerPolicyOnInitialRequest;
    public com.vccorp.proxy_resolver.mojom.ProxyResolverFactory proxyResolverFactory;
    public com.vccorp.mojo_base.mojom.FilePath cookiePath;
    public boolean enableEncryptedCookies;
    public boolean restoreOldSessionCookies;
    public boolean persistSessionCookies;
    public boolean httpCacheEnabled;
    public int httpCacheMaxSize;
    public com.vccorp.mojo_base.mojom.FilePath httpCachePath;
    public com.vccorp.mojo_base.mojom.FilePath httpServerPropertiesPath;
    public com.vccorp.mojo_base.mojom.FilePath transportSecurityPersisterPath;
    public boolean enableFtpUrlSupport;
    public boolean checkClearTextPermitted;
    public boolean enforceChromeCtPolicy;
    public boolean http09OnNonDefaultPortsEnabled;
    public boolean disableIdleSocketsCloseOnMemoryPressure;
    public SslConfig initialSslConfig;
    public com.vccorp.mojo.bindings.InterfaceRequest<SslConfigClient> sslConfigClientRequest;
    public ProxyConfigWithAnnotation initialProxyConfig;
    public com.vccorp.mojo.bindings.InterfaceRequest<ProxyConfigClient> proxyConfigClientRequest;
    public CustomProxyConfig initialCustomProxyConfig;
    public com.vccorp.mojo.bindings.InterfaceRequest<CustomProxyConfigClient> customProxyConfigClientRequest;
    public ProxyConfigPollerClient proxyConfigPollerClient;
    public ProxyErrorClient proxyErrorClient;
    public boolean pacQuickCheckEnabled;
    public boolean enableCertificateReporting;
    public boolean enableExpectCtReporting;
    public CtLogInfo[] ctLogs;
    public CookieManagerParams cookieManagerParams;
    public boolean enableDomainReliability;
    public String domainReliabilityUploadReporter;
    public boolean discardDomainReliablityUploads;
    public com.vccorp.mojo_base.mojom.TimeDelta reportingDeliveryInterval;
    public boolean skipReportingSendPermissionCheck;
    public boolean primaryNetworkContext;
    public CorsOriginAccessPatterns[] corsOriginAccessList;
    public String[] corsExemptHeaderList;

    private NetworkContextParams(int version) {
        super(STRUCT_SIZE, version);
        this.enableBrotli = (boolean) true;
        this.enableReferrers = (boolean) true;
        this.validateReferrerPolicyOnInitialRequest = (boolean) true;
        this.enableEncryptedCookies = (boolean) true;
        this.restoreOldSessionCookies = (boolean) false;
        this.persistSessionCookies = (boolean) false;
        this.httpCacheEnabled = (boolean) true;
        this.httpCacheMaxSize = (int) 0;
        this.enableFtpUrlSupport = (boolean) false;
        this.checkClearTextPermitted = (boolean) false;
        this.enforceChromeCtPolicy = (boolean) false;
        this.http09OnNonDefaultPortsEnabled = (boolean) false;
        this.disableIdleSocketsCloseOnMemoryPressure = (boolean) false;
        this.pacQuickCheckEnabled = (boolean) true;
        this.enableCertificateReporting = (boolean) false;
        this.enableExpectCtReporting = (boolean) false;
        this.enableDomainReliability = (boolean) false;
        this.discardDomainReliablityUploads = (boolean) false;
        this.skipReportingSendPermissionCheck = (boolean) false;
        this.primaryNetworkContext = (boolean) false;
    }

    public NetworkContextParams() {
        this(0);
    }

    public static NetworkContextParams deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static NetworkContextParams deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static NetworkContextParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        NetworkContextParams result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new NetworkContextParams(elementsOrVersion);
                {
                    
                result.contextName = decoder0.readString(8, true);
                }
                {
                    
                result.userAgent = decoder0.readString(16, false);
                }
                {
                    
                result.acceptLanguage = decoder0.readString(24, false);
                }
                {
                    
                result.enableBrotli = decoder0.readBoolean(32, 0);
                }
                {
                    
                result.enableReferrers = decoder0.readBoolean(32, 1);
                }
                {
                    
                result.validateReferrerPolicyOnInitialRequest = decoder0.readBoolean(32, 2);
                }
                {
                    
                result.enableEncryptedCookies = decoder0.readBoolean(32, 3);
                }
                {
                    
                result.restoreOldSessionCookies = decoder0.readBoolean(32, 4);
                }
                {
                    
                result.persistSessionCookies = decoder0.readBoolean(32, 5);
                }
                {
                    
                result.httpCacheEnabled = decoder0.readBoolean(32, 6);
                }
                {
                    
                result.enableFtpUrlSupport = decoder0.readBoolean(32, 7);
                }
                {
                    
                result.checkClearTextPermitted = decoder0.readBoolean(33, 0);
                }
                {
                    
                result.enforceChromeCtPolicy = decoder0.readBoolean(33, 1);
                }
                {
                    
                result.http09OnNonDefaultPortsEnabled = decoder0.readBoolean(33, 2);
                }
                {
                    
                result.disableIdleSocketsCloseOnMemoryPressure = decoder0.readBoolean(33, 3);
                }
                {
                    
                result.pacQuickCheckEnabled = decoder0.readBoolean(33, 4);
                }
                {
                    
                result.enableCertificateReporting = decoder0.readBoolean(33, 5);
                }
                {
                    
                result.enableExpectCtReporting = decoder0.readBoolean(33, 6);
                }
                {
                    
                result.enableDomainReliability = decoder0.readBoolean(33, 7);
                }
                {
                    
                result.discardDomainReliablityUploads = decoder0.readBoolean(34, 0);
                }
                {
                    
                result.skipReportingSendPermissionCheck = decoder0.readBoolean(34, 1);
                }
                {
                    
                result.primaryNetworkContext = decoder0.readBoolean(34, 2);
                }
                {
                    
                result.httpCacheMaxSize = decoder0.readInt(36);
                }
                {
                    
                result.quicUserAgentId = decoder0.readString(40, false);
                }
                {
                    
                result.proxyResolverFactory = decoder0.readServiceInterface(48, true, com.vccorp.proxy_resolver.mojom.ProxyResolverFactory.MANAGER);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(56, true);
                result.cookiePath = com.vccorp.mojo_base.mojom.FilePath.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(64, true);
                result.httpCachePath = com.vccorp.mojo_base.mojom.FilePath.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(72, true);
                result.httpServerPropertiesPath = com.vccorp.mojo_base.mojom.FilePath.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(80, true);
                result.transportSecurityPersisterPath = com.vccorp.mojo_base.mojom.FilePath.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(88, true);
                result.initialSslConfig = SslConfig.decode(decoder1);
                }
                {
                    
                result.sslConfigClientRequest = decoder0.readInterfaceRequest(96, true);
                }
                {
                    
                result.proxyConfigClientRequest = decoder0.readInterfaceRequest(100, true);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(104, true);
                result.initialProxyConfig = ProxyConfigWithAnnotation.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(112, true);
                result.initialCustomProxyConfig = CustomProxyConfig.decode(decoder1);
                }
                {
                    
                result.customProxyConfigClientRequest = decoder0.readInterfaceRequest(120, true);
                }
                {
                    
                result.proxyConfigPollerClient = decoder0.readServiceInterface(124, true, ProxyConfigPollerClient.MANAGER);
                }
                {
                    
                result.proxyErrorClient = decoder0.readServiceInterface(132, true, ProxyErrorClient.MANAGER);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(144, false);
                {
                    com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    result.ctLogs = new CtLogInfo[si1.elementsOrVersion];
                    for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                        
                        com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                        result.ctLogs[i1] = CtLogInfo.decode(decoder2);
                    }
                }
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(152, true);
                result.cookieManagerParams = CookieManagerParams.decode(decoder1);
                }
                {
                    
                result.domainReliabilityUploadReporter = decoder0.readString(160, false);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(168, true);
                result.reportingDeliveryInterval = com.vccorp.mojo_base.mojom.TimeDelta.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(176, false);
                {
                    com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    result.corsOriginAccessList = new CorsOriginAccessPatterns[si1.elementsOrVersion];
                    for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                        
                        com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                        result.corsOriginAccessList[i1] = CorsOriginAccessPatterns.decode(decoder2);
                    }
                }
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(184, false);
                {
                    com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    result.corsExemptHeaderList = new String[si1.elementsOrVersion];
                    for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                        
                        result.corsExemptHeaderList[i1] = decoder1.readString(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                    }
                }
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.contextName, 8, true);
        
        encoder0.encode(this.userAgent, 16, false);
        
        encoder0.encode(this.acceptLanguage, 24, false);
        
        encoder0.encode(this.enableBrotli, 32, 0);
        
        encoder0.encode(this.enableReferrers, 32, 1);
        
        encoder0.encode(this.validateReferrerPolicyOnInitialRequest, 32, 2);
        
        encoder0.encode(this.enableEncryptedCookies, 32, 3);
        
        encoder0.encode(this.restoreOldSessionCookies, 32, 4);
        
        encoder0.encode(this.persistSessionCookies, 32, 5);
        
        encoder0.encode(this.httpCacheEnabled, 32, 6);
        
        encoder0.encode(this.enableFtpUrlSupport, 32, 7);
        
        encoder0.encode(this.checkClearTextPermitted, 33, 0);
        
        encoder0.encode(this.enforceChromeCtPolicy, 33, 1);
        
        encoder0.encode(this.http09OnNonDefaultPortsEnabled, 33, 2);
        
        encoder0.encode(this.disableIdleSocketsCloseOnMemoryPressure, 33, 3);
        
        encoder0.encode(this.pacQuickCheckEnabled, 33, 4);
        
        encoder0.encode(this.enableCertificateReporting, 33, 5);
        
        encoder0.encode(this.enableExpectCtReporting, 33, 6);
        
        encoder0.encode(this.enableDomainReliability, 33, 7);
        
        encoder0.encode(this.discardDomainReliablityUploads, 34, 0);
        
        encoder0.encode(this.skipReportingSendPermissionCheck, 34, 1);
        
        encoder0.encode(this.primaryNetworkContext, 34, 2);
        
        encoder0.encode(this.httpCacheMaxSize, 36);
        
        encoder0.encode(this.quicUserAgentId, 40, false);
        
        encoder0.encode(this.proxyResolverFactory, 48, true, com.vccorp.proxy_resolver.mojom.ProxyResolverFactory.MANAGER);
        
        encoder0.encode(this.cookiePath, 56, true);
        
        encoder0.encode(this.httpCachePath, 64, true);
        
        encoder0.encode(this.httpServerPropertiesPath, 72, true);
        
        encoder0.encode(this.transportSecurityPersisterPath, 80, true);
        
        encoder0.encode(this.initialSslConfig, 88, true);
        
        encoder0.encode(this.sslConfigClientRequest, 96, true);
        
        encoder0.encode(this.proxyConfigClientRequest, 100, true);
        
        encoder0.encode(this.initialProxyConfig, 104, true);
        
        encoder0.encode(this.initialCustomProxyConfig, 112, true);
        
        encoder0.encode(this.customProxyConfigClientRequest, 120, true);
        
        encoder0.encode(this.proxyConfigPollerClient, 124, true, ProxyConfigPollerClient.MANAGER);
        
        encoder0.encode(this.proxyErrorClient, 132, true, ProxyErrorClient.MANAGER);
        
        if (this.ctLogs == null) {
            encoder0.encodeNullPointer(144, false);
        } else {
            org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.ctLogs.length, 144, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            for (int i0 = 0; i0 < this.ctLogs.length; ++i0) {
                
                encoder1.encode(this.ctLogs[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
            }
        }
        
        encoder0.encode(this.cookieManagerParams, 152, true);
        
        encoder0.encode(this.domainReliabilityUploadReporter, 160, false);
        
        encoder0.encode(this.reportingDeliveryInterval, 168, true);
        
        if (this.corsOriginAccessList == null) {
            encoder0.encodeNullPointer(176, false);
        } else {
            org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.corsOriginAccessList.length, 176, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            for (int i0 = 0; i0 < this.corsOriginAccessList.length; ++i0) {
                
                encoder1.encode(this.corsOriginAccessList[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
            }
        }
        
        if (this.corsExemptHeaderList == null) {
            encoder0.encodeNullPointer(184, false);
        } else {
            org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.corsExemptHeaderList.length, 184, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            for (int i0 = 0; i0 < this.corsExemptHeaderList.length; ++i0) {
                
                encoder1.encode(this.corsExemptHeaderList[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
            }
        }
    }
}