
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/network/public/mojom/network_service.mojom
//

package com.vccorp.network.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class HttpAuthStaticParams extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 32;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public String[] supportedSchemes;
    public String gssapiLibraryName;
    public boolean allowGssapiLibraryLoad;

    private HttpAuthStaticParams(int version) {
        super(STRUCT_SIZE, version);
        this.allowGssapiLibraryLoad = (boolean) true;
    }

    public HttpAuthStaticParams() {
        this(0);
    }

    public static HttpAuthStaticParams deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static HttpAuthStaticParams deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static HttpAuthStaticParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        HttpAuthStaticParams result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new HttpAuthStaticParams(elementsOrVersion);
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                {
                    com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    result.supportedSchemes = new String[si1.elementsOrVersion];
                    for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                        
                        result.supportedSchemes[i1] = decoder1.readString(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                    }
                }
                }
                {
                    
                result.gssapiLibraryName = decoder0.readString(16, false);
                }
                {
                    
                result.allowGssapiLibraryLoad = decoder0.readBoolean(24, 0);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        if (this.supportedSchemes == null) {
            encoder0.encodeNullPointer(8, false);
        } else {
            org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.supportedSchemes.length, 8, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            for (int i0 = 0; i0 < this.supportedSchemes.length; ++i0) {
                
                encoder1.encode(this.supportedSchemes[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
            }
        }
        
        encoder0.encode(this.gssapiLibraryName, 16, false);
        
        encoder0.encode(this.allowGssapiLibraryLoad, 24, 0);
    }
}