
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/document_metadata/copyless_paste.mojom
//

package com.vccorp.blink.mojom.document_metadata;

import com.vccorp.mojo.bindings.DeserializationException;


public final class Values extends com.vccorp.mojo.bindings.Union {

    public static final class Tag {
        public static final int BoolValues = 0;
        public static final int LongValues = 1;
        public static final int StringValues = 2;
        public static final int EntityValues = 3;
    };
    private boolean[] mBoolValues;
    private long[] mLongValues;
    private String[] mStringValues;
    private Entity[] mEntityValues;

    public void setBoolValues(boolean[] boolValues) {
        this.mTag = Tag.BoolValues;
        this.mBoolValues = boolValues;
    }

    public boolean[] getBoolValues() {
        assert this.mTag == Tag.BoolValues;
        return this.mBoolValues;
    }

    public void setLongValues(long[] longValues) {
        this.mTag = Tag.LongValues;
        this.mLongValues = longValues;
    }

    public long[] getLongValues() {
        assert this.mTag == Tag.LongValues;
        return this.mLongValues;
    }

    public void setStringValues(String[] stringValues) {
        this.mTag = Tag.StringValues;
        this.mStringValues = stringValues;
    }

    public String[] getStringValues() {
        assert this.mTag == Tag.StringValues;
        return this.mStringValues;
    }

    public void setEntityValues(Entity[] entityValues) {
        this.mTag = Tag.EntityValues;
        this.mEntityValues = entityValues;
    }

    public Entity[] getEntityValues() {
        assert this.mTag == Tag.EntityValues;
        return this.mEntityValues;
    }


    @Override
    public final void encode(org.chromium.mojo.bindings.Encoder encoder0, int offset) {
        encoder0.encode(com.vccorp.mojo.bindings.BindingsHelper.UNION_SIZE, offset);
        encoder0.encode(this.mTag, offset + 4);
        switch (mTag) {
            case Tag.BoolValues: {
                
                encoder0.encode(this.mBoolValues, offset + 8, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                break;
            }
            case Tag.LongValues: {
                
                encoder0.encode(this.mLongValues, offset + 8, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                break;
            }
            case Tag.StringValues: {
                
                if (this.mStringValues == null) {
                    encoder0.encodeNullPointer(offset + 8, false);
                } else {
                    org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.mStringValues.length, offset + 8, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    for (int i0 = 0; i0 < this.mStringValues.length; ++i0) {
                        
                        encoder1.encode(this.mStringValues[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                    }
                }
                break;
            }
            case Tag.EntityValues: {
                
                if (this.mEntityValues == null) {
                    encoder0.encodeNullPointer(offset + 8, false);
                } else {
                    org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.mEntityValues.length, offset + 8, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    for (int i0 = 0; i0 < this.mEntityValues.length; ++i0) {
                        
                        encoder1.encode(this.mEntityValues[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                    }
                }
                break;
            }
            default: {
                break;
            }
        }
    }

    public static Values deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message).decoderForSerializedUnion(), 0);
    }

    public static final Values decode(com.vccorp.mojo.bindings.Decoder decoder0, int offset) {
        com.vccorp.mojo.bindings.DataHeader dataHeader = decoder0.readDataHeaderForUnion(offset);
        if (dataHeader.size == 0) {
            return null;
        }
        Values result = new Values();
        switch (dataHeader.elementsOrVersion) {
            case Tag.BoolValues: {
                
                result.mBoolValues = decoder0.readBooleans(offset + com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                result.mTag = Tag.BoolValues;
                break;
            }
            case Tag.LongValues: {
                
                result.mLongValues = decoder0.readLongs(offset + com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                result.mTag = Tag.LongValues;
                break;
            }
            case Tag.StringValues: {
                
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(offset + com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE, false);
                {
                    com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    result.mStringValues = new String[si1.elementsOrVersion];
                    for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                        
                        result.mStringValues[i1] = decoder1.readString(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                    }
                }
                result.mTag = Tag.StringValues;
                break;
            }
            case Tag.EntityValues: {
                
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(offset + com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE, false);
                {
                    com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    result.mEntityValues = new Entity[si1.elementsOrVersion];
                    for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                        
                        com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                        result.mEntityValues[i1] = Entity.decode(decoder2);
                    }
                }
                result.mTag = Tag.EntityValues;
                break;
            }
            default: {
                break;
            }
        }
        return result;
    }
}