
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/worker/worker_content_settings_proxy.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class WorkerContentSettingsProxy_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<WorkerContentSettingsProxy, WorkerContentSettingsProxy.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<WorkerContentSettingsProxy, WorkerContentSettingsProxy.Proxy>() {

        @Override
        public String getName() {
            return "blink.mojom.WorkerContentSettingsProxy";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, WorkerContentSettingsProxy impl) {
            return new Stub(core, impl);
        }

        @Override
        public WorkerContentSettingsProxy[] buildArray(int size) {
          return new WorkerContentSettingsProxy[size];
        }
    };


    private static final int ALLOW_INDEXED_DB_ORDINAL = 0;

    private static final int ALLOW_CACHE_STORAGE_ORDINAL = 1;

    private static final int REQUEST_FILE_SYSTEM_ACCESS_SYNC_ORDINAL = 2;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements WorkerContentSettingsProxy.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void allowIndexedDb(

AllowIndexedDbResponse callback) {

            WorkerContentSettingsProxyAllowIndexedDbParams _message = new WorkerContentSettingsProxyAllowIndexedDbParams();


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    ALLOW_INDEXED_DB_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new WorkerContentSettingsProxyAllowIndexedDbResponseParamsForwardToCallback(callback));

        }


        @Override
        public void allowCacheStorage(

AllowCacheStorageResponse callback) {

            WorkerContentSettingsProxyAllowCacheStorageParams _message = new WorkerContentSettingsProxyAllowCacheStorageParams();


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    ALLOW_CACHE_STORAGE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new WorkerContentSettingsProxyAllowCacheStorageResponseParamsForwardToCallback(callback));

        }


        @Override
        public void requestFileSystemAccessSync(

RequestFileSystemAccessSyncResponse callback) {

            WorkerContentSettingsProxyRequestFileSystemAccessSyncParams _message = new WorkerContentSettingsProxyRequestFileSystemAccessSyncParams();


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    REQUEST_FILE_SYSTEM_ACCESS_SYNC_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new WorkerContentSettingsProxyRequestFileSystemAccessSyncResponseParamsForwardToCallback(callback));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<WorkerContentSettingsProxy> {

        Stub(com.vccorp.mojo.system.Core core, WorkerContentSettingsProxy impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                WorkerContentSettingsProxy_Internal.MANAGER, messageWithHeader);








                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), WorkerContentSettingsProxy_Internal.MANAGER, messageWithHeader, receiver);







                    case ALLOW_INDEXED_DB_ORDINAL: {

                        WorkerContentSettingsProxyAllowIndexedDbParams.deserialize(messageWithHeader.getPayload());

                        getImpl().allowIndexedDb(new WorkerContentSettingsProxyAllowIndexedDbResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case ALLOW_CACHE_STORAGE_ORDINAL: {

                        WorkerContentSettingsProxyAllowCacheStorageParams.deserialize(messageWithHeader.getPayload());

                        getImpl().allowCacheStorage(new WorkerContentSettingsProxyAllowCacheStorageResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case REQUEST_FILE_SYSTEM_ACCESS_SYNC_ORDINAL: {

                        WorkerContentSettingsProxyRequestFileSystemAccessSyncParams.deserialize(messageWithHeader.getPayload());

                        getImpl().requestFileSystemAccessSync(new WorkerContentSettingsProxyRequestFileSystemAccessSyncResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class WorkerContentSettingsProxyAllowIndexedDbParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private WorkerContentSettingsProxyAllowIndexedDbParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public WorkerContentSettingsProxyAllowIndexedDbParams() {
            this(0);
        }

        public static WorkerContentSettingsProxyAllowIndexedDbParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static WorkerContentSettingsProxyAllowIndexedDbParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static WorkerContentSettingsProxyAllowIndexedDbParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            WorkerContentSettingsProxyAllowIndexedDbParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new WorkerContentSettingsProxyAllowIndexedDbParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class WorkerContentSettingsProxyAllowIndexedDbResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean result;

        private WorkerContentSettingsProxyAllowIndexedDbResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public WorkerContentSettingsProxyAllowIndexedDbResponseParams() {
            this(0);
        }

        public static WorkerContentSettingsProxyAllowIndexedDbResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static WorkerContentSettingsProxyAllowIndexedDbResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static WorkerContentSettingsProxyAllowIndexedDbResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            WorkerContentSettingsProxyAllowIndexedDbResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new WorkerContentSettingsProxyAllowIndexedDbResponseParams(elementsOrVersion);
                    {
                        
                    result.result = decoder0.readBoolean(8, 0);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.result, 8, 0);
        }
    }

    static class WorkerContentSettingsProxyAllowIndexedDbResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final WorkerContentSettingsProxy.AllowIndexedDbResponse mCallback;

        WorkerContentSettingsProxyAllowIndexedDbResponseParamsForwardToCallback(WorkerContentSettingsProxy.AllowIndexedDbResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(ALLOW_INDEXED_DB_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                WorkerContentSettingsProxyAllowIndexedDbResponseParams response = WorkerContentSettingsProxyAllowIndexedDbResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.result);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class WorkerContentSettingsProxyAllowIndexedDbResponseParamsProxyToResponder implements WorkerContentSettingsProxy.AllowIndexedDbResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        WorkerContentSettingsProxyAllowIndexedDbResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Boolean result) {
            WorkerContentSettingsProxyAllowIndexedDbResponseParams _response = new WorkerContentSettingsProxyAllowIndexedDbResponseParams();

            _response.result = result;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    ALLOW_INDEXED_DB_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class WorkerContentSettingsProxyAllowCacheStorageParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private WorkerContentSettingsProxyAllowCacheStorageParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public WorkerContentSettingsProxyAllowCacheStorageParams() {
            this(0);
        }

        public static WorkerContentSettingsProxyAllowCacheStorageParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static WorkerContentSettingsProxyAllowCacheStorageParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static WorkerContentSettingsProxyAllowCacheStorageParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            WorkerContentSettingsProxyAllowCacheStorageParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new WorkerContentSettingsProxyAllowCacheStorageParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class WorkerContentSettingsProxyAllowCacheStorageResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean result;

        private WorkerContentSettingsProxyAllowCacheStorageResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public WorkerContentSettingsProxyAllowCacheStorageResponseParams() {
            this(0);
        }

        public static WorkerContentSettingsProxyAllowCacheStorageResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static WorkerContentSettingsProxyAllowCacheStorageResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static WorkerContentSettingsProxyAllowCacheStorageResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            WorkerContentSettingsProxyAllowCacheStorageResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new WorkerContentSettingsProxyAllowCacheStorageResponseParams(elementsOrVersion);
                    {
                        
                    result.result = decoder0.readBoolean(8, 0);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.result, 8, 0);
        }
    }

    static class WorkerContentSettingsProxyAllowCacheStorageResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final WorkerContentSettingsProxy.AllowCacheStorageResponse mCallback;

        WorkerContentSettingsProxyAllowCacheStorageResponseParamsForwardToCallback(WorkerContentSettingsProxy.AllowCacheStorageResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(ALLOW_CACHE_STORAGE_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                WorkerContentSettingsProxyAllowCacheStorageResponseParams response = WorkerContentSettingsProxyAllowCacheStorageResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.result);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class WorkerContentSettingsProxyAllowCacheStorageResponseParamsProxyToResponder implements WorkerContentSettingsProxy.AllowCacheStorageResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        WorkerContentSettingsProxyAllowCacheStorageResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Boolean result) {
            WorkerContentSettingsProxyAllowCacheStorageResponseParams _response = new WorkerContentSettingsProxyAllowCacheStorageResponseParams();

            _response.result = result;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    ALLOW_CACHE_STORAGE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class WorkerContentSettingsProxyRequestFileSystemAccessSyncParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private WorkerContentSettingsProxyRequestFileSystemAccessSyncParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public WorkerContentSettingsProxyRequestFileSystemAccessSyncParams() {
            this(0);
        }

        public static WorkerContentSettingsProxyRequestFileSystemAccessSyncParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static WorkerContentSettingsProxyRequestFileSystemAccessSyncParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static WorkerContentSettingsProxyRequestFileSystemAccessSyncParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            WorkerContentSettingsProxyRequestFileSystemAccessSyncParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new WorkerContentSettingsProxyRequestFileSystemAccessSyncParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class WorkerContentSettingsProxyRequestFileSystemAccessSyncResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean result;

        private WorkerContentSettingsProxyRequestFileSystemAccessSyncResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public WorkerContentSettingsProxyRequestFileSystemAccessSyncResponseParams() {
            this(0);
        }

        public static WorkerContentSettingsProxyRequestFileSystemAccessSyncResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static WorkerContentSettingsProxyRequestFileSystemAccessSyncResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static WorkerContentSettingsProxyRequestFileSystemAccessSyncResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            WorkerContentSettingsProxyRequestFileSystemAccessSyncResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new WorkerContentSettingsProxyRequestFileSystemAccessSyncResponseParams(elementsOrVersion);
                    {
                        
                    result.result = decoder0.readBoolean(8, 0);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.result, 8, 0);
        }
    }

    static class WorkerContentSettingsProxyRequestFileSystemAccessSyncResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final WorkerContentSettingsProxy.RequestFileSystemAccessSyncResponse mCallback;

        WorkerContentSettingsProxyRequestFileSystemAccessSyncResponseParamsForwardToCallback(WorkerContentSettingsProxy.RequestFileSystemAccessSyncResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(REQUEST_FILE_SYSTEM_ACCESS_SYNC_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                WorkerContentSettingsProxyRequestFileSystemAccessSyncResponseParams response = WorkerContentSettingsProxyRequestFileSystemAccessSyncResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.result);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class WorkerContentSettingsProxyRequestFileSystemAccessSyncResponseParamsProxyToResponder implements WorkerContentSettingsProxy.RequestFileSystemAccessSyncResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        WorkerContentSettingsProxyRequestFileSystemAccessSyncResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Boolean result) {
            WorkerContentSettingsProxyRequestFileSystemAccessSyncResponseParams _response = new WorkerContentSettingsProxyRequestFileSystemAccessSyncResponseParams();

            _response.result = result;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    REQUEST_FILE_SYSTEM_ACCESS_SYNC_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



}
