
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/service_worker/service_worker_object.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class ServiceWorkerObjectInfo extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 40;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(40, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public long versionId;
    public int state;
    public com.vccorp.url.mojom.Url url;
    public com.vccorp.mojo.bindings.AssociatedInterfaceNotSupported hostPtrInfo;
    public com.vccorp.mojo.bindings.AssociatedInterfaceRequestNotSupported request;

    private ServiceWorkerObjectInfo(int version) {
        super(STRUCT_SIZE, version);
        this.versionId = (long) ServiceWorkerObjectConstants.INVALID_SERVICE_WORKER_VERSION_ID;
        this.state = (int) ServiceWorkerState.UNKNOWN;
    }

    public ServiceWorkerObjectInfo() {
        this(0);
    }

    public static ServiceWorkerObjectInfo deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static ServiceWorkerObjectInfo deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static ServiceWorkerObjectInfo decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        ServiceWorkerObjectInfo result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new ServiceWorkerObjectInfo(elementsOrVersion);
                {
                    
                result.versionId = decoder0.readLong(8);
                }
                {
                    
                result.state = decoder0.readInt(16);
                    ServiceWorkerState.validate(result.state);
                }
                {
                    
                result.request = decoder0.readAssociatedInterfaceRequestNotSupported(20, false);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                result.url = com.vccorp.url.mojom.Url.decode(decoder1);
                }
                {
                    
                result.hostPtrInfo = decoder0.readAssociatedServiceInterfaceNotSupported(32, false);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.versionId, 8);
        
        encoder0.encode(this.state, 16);
        
        encoder0.encode(this.request, 20, false);
        
        encoder0.encode(this.url, 24, false);
        
        encoder0.encode(this.hostPtrInfo, 32, false);
    }
}