
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/service_worker/service_worker_event_status.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;

public final class ServiceWorkerEventStatus {
    private static final boolean IS_EXTENSIBLE = false;

    public static final int COMPLETED = 0;
    public static final int REJECTED = 1; // COMPLETED + 1
    public static final int ABORTED = 2; // REJECTED + 1
    public static final int TIMEOUT = 3; // ABORTED + 1
    public static final int MAX = ServiceWorkerEventStatus.TIMEOUT;

    public static boolean isKnownValue(int value) {
        return value >= 0 && value <= 3;
    }

    public static void validate(int value) {
        if (IS_EXTENSIBLE || isKnownValue(value)) return;
        throw new DeserializationException("Invalid enum value.");
    }

    private ServiceWorkerEventStatus() {}
}