
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/service_worker/service_worker_client.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class ServiceWorkerClientInfo extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 56;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(56, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public com.vccorp.url.mojom.Url url;
    public int frameType;
    public String clientUuid;
    public int clientType;
    public boolean pageHidden;
    public boolean isFocused;
    public com.vccorp.mojo_base.mojom.TimeTicks lastFocusTime;
    public com.vccorp.mojo_base.mojom.TimeTicks creationTime;

    private ServiceWorkerClientInfo(int version) {
        super(STRUCT_SIZE, version);
        this.frameType = (int) com.vccorp.network.mojom.RequestContextFrameType.NONE;
        this.pageHidden = (boolean) true;
        this.isFocused = (boolean) false;
    }

    public ServiceWorkerClientInfo() {
        this(0);
    }

    public static ServiceWorkerClientInfo deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static ServiceWorkerClientInfo deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static ServiceWorkerClientInfo decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        ServiceWorkerClientInfo result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new ServiceWorkerClientInfo(elementsOrVersion);
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                result.url = com.vccorp.url.mojom.Url.decode(decoder1);
                }
                {
                    
                result.frameType = decoder0.readInt(16);
                    com.vccorp.network.mojom.RequestContextFrameType.validate(result.frameType);
                }
                {
                    
                result.clientType = decoder0.readInt(20);
                    ServiceWorkerClientType.validate(result.clientType);
                }
                {
                    
                result.clientUuid = decoder0.readString(24, false);
                }
                {
                    
                result.pageHidden = decoder0.readBoolean(32, 0);
                }
                {
                    
                result.isFocused = decoder0.readBoolean(32, 1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(40, false);
                result.lastFocusTime = com.vccorp.mojo_base.mojom.TimeTicks.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(48, false);
                result.creationTime = com.vccorp.mojo_base.mojom.TimeTicks.decode(decoder1);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.url, 8, false);
        
        encoder0.encode(this.frameType, 16);
        
        encoder0.encode(this.clientType, 20);
        
        encoder0.encode(this.clientUuid, 24, false);
        
        encoder0.encode(this.pageHidden, 32, 0);
        
        encoder0.encode(this.isFocused, 32, 1);
        
        encoder0.encode(this.lastFocusTime, 40, false);
        
        encoder0.encode(this.creationTime, 48, false);
    }
}