
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/notifications/notification_service.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class NotificationService_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<NotificationService, NotificationService.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<NotificationService, NotificationService.Proxy>() {

        @Override
        public String getName() {
            return "blink.mojom.NotificationService";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, NotificationService impl) {
            return new Stub(core, impl);
        }

        @Override
        public NotificationService[] buildArray(int size) {
          return new NotificationService[size];
        }
    };


    private static final int GET_PERMISSION_STATUS_ORDINAL = 0;

    private static final int DISPLAY_NON_PERSISTENT_NOTIFICATION_ORDINAL = 1;

    private static final int CLOSE_NON_PERSISTENT_NOTIFICATION_ORDINAL = 2;

    private static final int DISPLAY_PERSISTENT_NOTIFICATION_ORDINAL = 3;

    private static final int CLOSE_PERSISTENT_NOTIFICATION_ORDINAL = 4;

    private static final int GET_NOTIFICATIONS_ORDINAL = 5;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements NotificationService.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void getPermissionStatus(

GetPermissionStatusResponse callback) {

            NotificationServiceGetPermissionStatusParams _message = new NotificationServiceGetPermissionStatusParams();


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_PERMISSION_STATUS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NotificationServiceGetPermissionStatusResponseParamsForwardToCallback(callback));

        }


        @Override
        public void displayNonPersistentNotification(
String token, NotificationData notificationData, NotificationResources notificationResources, NonPersistentNotificationListener eventListener) {

            NotificationServiceDisplayNonPersistentNotificationParams _message = new NotificationServiceDisplayNonPersistentNotificationParams();

            _message.token = token;

            _message.notificationData = notificationData;

            _message.notificationResources = notificationResources;

            _message.eventListener = eventListener;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(DISPLAY_NON_PERSISTENT_NOTIFICATION_ORDINAL)));

        }


        @Override
        public void closeNonPersistentNotification(
String token) {

            NotificationServiceCloseNonPersistentNotificationParams _message = new NotificationServiceCloseNonPersistentNotificationParams();

            _message.token = token;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(CLOSE_NON_PERSISTENT_NOTIFICATION_ORDINAL)));

        }


        @Override
        public void displayPersistentNotification(
long serviceWorkerRegistrationId, NotificationData notificationData, NotificationResources notificationResources, 
DisplayPersistentNotificationResponse callback) {

            NotificationServiceDisplayPersistentNotificationParams _message = new NotificationServiceDisplayPersistentNotificationParams();

            _message.serviceWorkerRegistrationId = serviceWorkerRegistrationId;

            _message.notificationData = notificationData;

            _message.notificationResources = notificationResources;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DISPLAY_PERSISTENT_NOTIFICATION_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NotificationServiceDisplayPersistentNotificationResponseParamsForwardToCallback(callback));

        }


        @Override
        public void closePersistentNotification(
String notificationId) {

            NotificationServiceClosePersistentNotificationParams _message = new NotificationServiceClosePersistentNotificationParams();

            _message.notificationId = notificationId;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(CLOSE_PERSISTENT_NOTIFICATION_ORDINAL)));

        }


        @Override
        public void getNotifications(
long serviceWorkerRegistrationId, String filterTag, boolean includeTriggered, 
GetNotificationsResponse callback) {

            NotificationServiceGetNotificationsParams _message = new NotificationServiceGetNotificationsParams();

            _message.serviceWorkerRegistrationId = serviceWorkerRegistrationId;

            _message.filterTag = filterTag;

            _message.includeTriggered = includeTriggered;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_NOTIFICATIONS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NotificationServiceGetNotificationsResponseParamsForwardToCallback(callback));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<NotificationService> {

        Stub(com.vccorp.mojo.system.Core core, NotificationService impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                NotificationService_Internal.MANAGER, messageWithHeader);







                    case DISPLAY_NON_PERSISTENT_NOTIFICATION_ORDINAL: {

                        NotificationServiceDisplayNonPersistentNotificationParams data =
                                NotificationServiceDisplayNonPersistentNotificationParams.deserialize(messageWithHeader.getPayload());

                        getImpl().displayNonPersistentNotification(data.token, data.notificationData, data.notificationResources, data.eventListener);
                        return true;
                    }





                    case CLOSE_NON_PERSISTENT_NOTIFICATION_ORDINAL: {

                        NotificationServiceCloseNonPersistentNotificationParams data =
                                NotificationServiceCloseNonPersistentNotificationParams.deserialize(messageWithHeader.getPayload());

                        getImpl().closeNonPersistentNotification(data.token);
                        return true;
                    }







                    case CLOSE_PERSISTENT_NOTIFICATION_ORDINAL: {

                        NotificationServiceClosePersistentNotificationParams data =
                                NotificationServiceClosePersistentNotificationParams.deserialize(messageWithHeader.getPayload());

                        getImpl().closePersistentNotification(data.notificationId);
                        return true;
                    }




                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), NotificationService_Internal.MANAGER, messageWithHeader, receiver);







                    case GET_PERMISSION_STATUS_ORDINAL: {

                        NotificationServiceGetPermissionStatusParams.deserialize(messageWithHeader.getPayload());

                        getImpl().getPermissionStatus(new NotificationServiceGetPermissionStatusResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }











                    case DISPLAY_PERSISTENT_NOTIFICATION_ORDINAL: {

                        NotificationServiceDisplayPersistentNotificationParams data =
                                NotificationServiceDisplayPersistentNotificationParams.deserialize(messageWithHeader.getPayload());

                        getImpl().displayPersistentNotification(data.serviceWorkerRegistrationId, data.notificationData, data.notificationResources, new NotificationServiceDisplayPersistentNotificationResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }









                    case GET_NOTIFICATIONS_ORDINAL: {

                        NotificationServiceGetNotificationsParams data =
                                NotificationServiceGetNotificationsParams.deserialize(messageWithHeader.getPayload());

                        getImpl().getNotifications(data.serviceWorkerRegistrationId, data.filterTag, data.includeTriggered, new NotificationServiceGetNotificationsResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class NotificationServiceGetPermissionStatusParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private NotificationServiceGetPermissionStatusParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NotificationServiceGetPermissionStatusParams() {
            this(0);
        }

        public static NotificationServiceGetPermissionStatusParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NotificationServiceGetPermissionStatusParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NotificationServiceGetPermissionStatusParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NotificationServiceGetPermissionStatusParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NotificationServiceGetPermissionStatusParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class NotificationServiceGetPermissionStatusResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int status;

        private NotificationServiceGetPermissionStatusResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NotificationServiceGetPermissionStatusResponseParams() {
            this(0);
        }

        public static NotificationServiceGetPermissionStatusResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NotificationServiceGetPermissionStatusResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NotificationServiceGetPermissionStatusResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NotificationServiceGetPermissionStatusResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NotificationServiceGetPermissionStatusResponseParams(elementsOrVersion);
                    {
                        
                    result.status = decoder0.readInt(8);
                        PermissionStatus.validate(result.status);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.status, 8);
        }
    }

    static class NotificationServiceGetPermissionStatusResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NotificationService.GetPermissionStatusResponse mCallback;

        NotificationServiceGetPermissionStatusResponseParamsForwardToCallback(NotificationService.GetPermissionStatusResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(GET_PERMISSION_STATUS_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                NotificationServiceGetPermissionStatusResponseParams response = NotificationServiceGetPermissionStatusResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.status);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NotificationServiceGetPermissionStatusResponseParamsProxyToResponder implements NotificationService.GetPermissionStatusResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NotificationServiceGetPermissionStatusResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer status) {
            NotificationServiceGetPermissionStatusResponseParams _response = new NotificationServiceGetPermissionStatusResponseParams();

            _response.status = status;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_PERMISSION_STATUS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NotificationServiceDisplayNonPersistentNotificationParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 40;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(40, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String token;
        public NotificationData notificationData;
        public NotificationResources notificationResources;
        public NonPersistentNotificationListener eventListener;

        private NotificationServiceDisplayNonPersistentNotificationParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NotificationServiceDisplayNonPersistentNotificationParams() {
            this(0);
        }

        public static NotificationServiceDisplayNonPersistentNotificationParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NotificationServiceDisplayNonPersistentNotificationParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NotificationServiceDisplayNonPersistentNotificationParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NotificationServiceDisplayNonPersistentNotificationParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NotificationServiceDisplayNonPersistentNotificationParams(elementsOrVersion);
                    {
                        
                    result.token = decoder0.readString(8, false);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.notificationData = NotificationData.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                    result.notificationResources = NotificationResources.decode(decoder1);
                    }
                    {
                        
                    result.eventListener = decoder0.readServiceInterface(32, false, NonPersistentNotificationListener.MANAGER);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.token, 8, false);
            
            encoder0.encode(this.notificationData, 16, false);
            
            encoder0.encode(this.notificationResources, 24, false);
            
            encoder0.encode(this.eventListener, 32, false, NonPersistentNotificationListener.MANAGER);
        }
    }



    
    static final class NotificationServiceCloseNonPersistentNotificationParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String token;

        private NotificationServiceCloseNonPersistentNotificationParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NotificationServiceCloseNonPersistentNotificationParams() {
            this(0);
        }

        public static NotificationServiceCloseNonPersistentNotificationParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NotificationServiceCloseNonPersistentNotificationParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NotificationServiceCloseNonPersistentNotificationParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NotificationServiceCloseNonPersistentNotificationParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NotificationServiceCloseNonPersistentNotificationParams(elementsOrVersion);
                    {
                        
                    result.token = decoder0.readString(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.token, 8, false);
        }
    }



    
    static final class NotificationServiceDisplayPersistentNotificationParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public long serviceWorkerRegistrationId;
        public NotificationData notificationData;
        public NotificationResources notificationResources;

        private NotificationServiceDisplayPersistentNotificationParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NotificationServiceDisplayPersistentNotificationParams() {
            this(0);
        }

        public static NotificationServiceDisplayPersistentNotificationParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NotificationServiceDisplayPersistentNotificationParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NotificationServiceDisplayPersistentNotificationParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NotificationServiceDisplayPersistentNotificationParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NotificationServiceDisplayPersistentNotificationParams(elementsOrVersion);
                    {
                        
                    result.serviceWorkerRegistrationId = decoder0.readLong(8);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.notificationData = NotificationData.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                    result.notificationResources = NotificationResources.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.serviceWorkerRegistrationId, 8);
            
            encoder0.encode(this.notificationData, 16, false);
            
            encoder0.encode(this.notificationResources, 24, false);
        }
    }



    
    static final class NotificationServiceDisplayPersistentNotificationResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int error;

        private NotificationServiceDisplayPersistentNotificationResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NotificationServiceDisplayPersistentNotificationResponseParams() {
            this(0);
        }

        public static NotificationServiceDisplayPersistentNotificationResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NotificationServiceDisplayPersistentNotificationResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NotificationServiceDisplayPersistentNotificationResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NotificationServiceDisplayPersistentNotificationResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NotificationServiceDisplayPersistentNotificationResponseParams(elementsOrVersion);
                    {
                        
                    result.error = decoder0.readInt(8);
                        PersistentNotificationError.validate(result.error);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.error, 8);
        }
    }

    static class NotificationServiceDisplayPersistentNotificationResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NotificationService.DisplayPersistentNotificationResponse mCallback;

        NotificationServiceDisplayPersistentNotificationResponseParamsForwardToCallback(NotificationService.DisplayPersistentNotificationResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(DISPLAY_PERSISTENT_NOTIFICATION_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                NotificationServiceDisplayPersistentNotificationResponseParams response = NotificationServiceDisplayPersistentNotificationResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.error);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NotificationServiceDisplayPersistentNotificationResponseParamsProxyToResponder implements NotificationService.DisplayPersistentNotificationResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NotificationServiceDisplayPersistentNotificationResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer error) {
            NotificationServiceDisplayPersistentNotificationResponseParams _response = new NotificationServiceDisplayPersistentNotificationResponseParams();

            _response.error = error;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DISPLAY_PERSISTENT_NOTIFICATION_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NotificationServiceClosePersistentNotificationParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String notificationId;

        private NotificationServiceClosePersistentNotificationParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NotificationServiceClosePersistentNotificationParams() {
            this(0);
        }

        public static NotificationServiceClosePersistentNotificationParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NotificationServiceClosePersistentNotificationParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NotificationServiceClosePersistentNotificationParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NotificationServiceClosePersistentNotificationParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NotificationServiceClosePersistentNotificationParams(elementsOrVersion);
                    {
                        
                    result.notificationId = decoder0.readString(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.notificationId, 8, false);
        }
    }



    
    static final class NotificationServiceGetNotificationsParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public long serviceWorkerRegistrationId;
        public String filterTag;
        public boolean includeTriggered;

        private NotificationServiceGetNotificationsParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NotificationServiceGetNotificationsParams() {
            this(0);
        }

        public static NotificationServiceGetNotificationsParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NotificationServiceGetNotificationsParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NotificationServiceGetNotificationsParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NotificationServiceGetNotificationsParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NotificationServiceGetNotificationsParams(elementsOrVersion);
                    {
                        
                    result.serviceWorkerRegistrationId = decoder0.readLong(8);
                    }
                    {
                        
                    result.filterTag = decoder0.readString(16, false);
                    }
                    {
                        
                    result.includeTriggered = decoder0.readBoolean(24, 0);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.serviceWorkerRegistrationId, 8);
            
            encoder0.encode(this.filterTag, 16, false);
            
            encoder0.encode(this.includeTriggered, 24, 0);
        }
    }



    
    static final class NotificationServiceGetNotificationsResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String[] notificationIds;
        public NotificationData[] notificationDatas;

        private NotificationServiceGetNotificationsResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NotificationServiceGetNotificationsResponseParams() {
            this(0);
        }

        public static NotificationServiceGetNotificationsResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NotificationServiceGetNotificationsResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NotificationServiceGetNotificationsResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NotificationServiceGetNotificationsResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NotificationServiceGetNotificationsResponseParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.notificationIds = new String[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            result.notificationIds[i1] = decoder1.readString(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                        }
                    }
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.notificationDatas = new NotificationData[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                            result.notificationDatas[i1] = NotificationData.decode(decoder2);
                        }
                    }
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            if (this.notificationIds == null) {
                encoder0.encodeNullPointer(8, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.notificationIds.length, 8, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.notificationIds.length; ++i0) {
                    
                    encoder1.encode(this.notificationIds[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
            
            if (this.notificationDatas == null) {
                encoder0.encodeNullPointer(16, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.notificationDatas.length, 16, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.notificationDatas.length; ++i0) {
                    
                    encoder1.encode(this.notificationDatas[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
        }
    }

    static class NotificationServiceGetNotificationsResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NotificationService.GetNotificationsResponse mCallback;

        NotificationServiceGetNotificationsResponseParamsForwardToCallback(NotificationService.GetNotificationsResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(GET_NOTIFICATIONS_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                NotificationServiceGetNotificationsResponseParams response = NotificationServiceGetNotificationsResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.notificationIds, response.notificationDatas);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NotificationServiceGetNotificationsResponseParamsProxyToResponder implements NotificationService.GetNotificationsResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NotificationServiceGetNotificationsResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(String[] notificationIds, NotificationData[] notificationDatas) {
            NotificationServiceGetNotificationsResponseParams _response = new NotificationServiceGetNotificationsResponseParams();

            _response.notificationIds = notificationIds;

            _response.notificationDatas = notificationDatas;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_NOTIFICATIONS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



}
