
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/choosers/file_chooser.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class FileChooserFileInfo extends com.vccorp.mojo.bindings.Union {

    public static final class Tag {
        public static final int NativeFile = 0;
        public static final int FileSystem = 1;
    };
    private NativeFileInfo mNativeFile;
    private FileSystemFileInfo mFileSystem;

    public void setNativeFile(NativeFileInfo nativeFile) {
        this.mTag = Tag.NativeFile;
        this.mNativeFile = nativeFile;
    }

    public NativeFileInfo getNativeFile() {
        assert this.mTag == Tag.NativeFile;
        return this.mNativeFile;
    }

    public void setFileSystem(FileSystemFileInfo fileSystem) {
        this.mTag = Tag.FileSystem;
        this.mFileSystem = fileSystem;
    }

    public FileSystemFileInfo getFileSystem() {
        assert this.mTag == Tag.FileSystem;
        return this.mFileSystem;
    }


    @Override
    public final void encode(org.chromium.mojo.bindings.Encoder encoder0, int offset) {
        encoder0.encode(com.vccorp.mojo.bindings.BindingsHelper.UNION_SIZE, offset);
        encoder0.encode(this.mTag, offset + 4);
        switch (mTag) {
            case Tag.NativeFile: {
                
                encoder0.encode(this.mNativeFile, offset + 8, false);
                break;
            }
            case Tag.FileSystem: {
                
                encoder0.encode(this.mFileSystem, offset + 8, false);
                break;
            }
            default: {
                break;
            }
        }
    }

    public static FileChooserFileInfo deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message).decoderForSerializedUnion(), 0);
    }

    public static final FileChooserFileInfo decode(com.vccorp.mojo.bindings.Decoder decoder0, int offset) {
        com.vccorp.mojo.bindings.DataHeader dataHeader = decoder0.readDataHeaderForUnion(offset);
        if (dataHeader.size == 0) {
            return null;
        }
        FileChooserFileInfo result = new FileChooserFileInfo();
        switch (dataHeader.elementsOrVersion) {
            case Tag.NativeFile: {
                
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(offset + com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE, false);
                result.mNativeFile = NativeFileInfo.decode(decoder1);
                result.mTag = Tag.NativeFile;
                break;
            }
            case Tag.FileSystem: {
                
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(offset + com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE, false);
                result.mFileSystem = FileSystemFileInfo.decode(decoder1);
                result.mTag = Tag.FileSystem;
                break;
            }
            default: {
                break;
            }
        }
        return result;
    }
}