
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/service_worker/embedded_worker.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class EmbeddedWorkerInstanceClient_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<EmbeddedWorkerInstanceClient, EmbeddedWorkerInstanceClient.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<EmbeddedWorkerInstanceClient, EmbeddedWorkerInstanceClient.Proxy>() {

        @Override
        public String getName() {
            return "blink.mojom.EmbeddedWorkerInstanceClient";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, EmbeddedWorkerInstanceClient impl) {
            return new Stub(core, impl);
        }

        @Override
        public EmbeddedWorkerInstanceClient[] buildArray(int size) {
          return new EmbeddedWorkerInstanceClient[size];
        }
    };


    private static final int START_WORKER_ORDINAL = 0;

    private static final int STOP_WORKER_ORDINAL = 1;

    private static final int RESUME_AFTER_DOWNLOAD_ORDINAL = 2;

    private static final int ADD_MESSAGE_TO_CONSOLE_ORDINAL = 3;

    private static final int BIND_DEV_TOOLS_AGENT_ORDINAL = 4;

    private static final int UPDATE_SUBRESOURCE_LOADER_FACTORIES_ORDINAL = 5;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements EmbeddedWorkerInstanceClient.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void startWorker(
EmbeddedWorkerStartParams params) {

            EmbeddedWorkerInstanceClientStartWorkerParams _message = new EmbeddedWorkerInstanceClientStartWorkerParams();

            _message.params = params;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(START_WORKER_ORDINAL)));

        }


        @Override
        public void stopWorker(
) {

            EmbeddedWorkerInstanceClientStopWorkerParams _message = new EmbeddedWorkerInstanceClientStopWorkerParams();


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(STOP_WORKER_ORDINAL)));

        }


        @Override
        public void resumeAfterDownload(
) {

            EmbeddedWorkerInstanceClientResumeAfterDownloadParams _message = new EmbeddedWorkerInstanceClientResumeAfterDownloadParams();


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(RESUME_AFTER_DOWNLOAD_ORDINAL)));

        }


        @Override
        public void addMessageToConsole(
int level, String message) {

            EmbeddedWorkerInstanceClientAddMessageToConsoleParams _message = new EmbeddedWorkerInstanceClientAddMessageToConsoleParams();

            _message.level = level;

            _message.message = message;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ADD_MESSAGE_TO_CONSOLE_ORDINAL)));

        }


        @Override
        public void bindDevToolsAgent(
com.vccorp.mojo.bindings.AssociatedInterfaceNotSupported agentHost, com.vccorp.mojo.bindings.AssociatedInterfaceRequestNotSupported agent) {

            EmbeddedWorkerInstanceClientBindDevToolsAgentParams _message = new EmbeddedWorkerInstanceClientBindDevToolsAgentParams();

            _message.agentHost = agentHost;

            _message.agent = agent;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(BIND_DEV_TOOLS_AGENT_ORDINAL)));

        }


        @Override
        public void updateSubresourceLoaderFactories(
UrlLoaderFactoryBundle subresourceLoaderFactories) {

            EmbeddedWorkerInstanceClientUpdateSubresourceLoaderFactoriesParams _message = new EmbeddedWorkerInstanceClientUpdateSubresourceLoaderFactoriesParams();

            _message.subresourceLoaderFactories = subresourceLoaderFactories;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(UPDATE_SUBRESOURCE_LOADER_FACTORIES_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<EmbeddedWorkerInstanceClient> {

        Stub(com.vccorp.mojo.system.Core core, EmbeddedWorkerInstanceClient impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                EmbeddedWorkerInstanceClient_Internal.MANAGER, messageWithHeader);





                    case START_WORKER_ORDINAL: {

                        EmbeddedWorkerInstanceClientStartWorkerParams data =
                                EmbeddedWorkerInstanceClientStartWorkerParams.deserialize(messageWithHeader.getPayload());

                        getImpl().startWorker(data.params);
                        return true;
                    }





                    case STOP_WORKER_ORDINAL: {

                        EmbeddedWorkerInstanceClientStopWorkerParams.deserialize(messageWithHeader.getPayload());

                        getImpl().stopWorker();
                        return true;
                    }





                    case RESUME_AFTER_DOWNLOAD_ORDINAL: {

                        EmbeddedWorkerInstanceClientResumeAfterDownloadParams.deserialize(messageWithHeader.getPayload());

                        getImpl().resumeAfterDownload();
                        return true;
                    }





                    case ADD_MESSAGE_TO_CONSOLE_ORDINAL: {

                        EmbeddedWorkerInstanceClientAddMessageToConsoleParams data =
                                EmbeddedWorkerInstanceClientAddMessageToConsoleParams.deserialize(messageWithHeader.getPayload());

                        getImpl().addMessageToConsole(data.level, data.message);
                        return true;
                    }





                    case BIND_DEV_TOOLS_AGENT_ORDINAL: {

                        EmbeddedWorkerInstanceClientBindDevToolsAgentParams data =
                                EmbeddedWorkerInstanceClientBindDevToolsAgentParams.deserialize(messageWithHeader.getPayload());

                        getImpl().bindDevToolsAgent(data.agentHost, data.agent);
                        return true;
                    }





                    case UPDATE_SUBRESOURCE_LOADER_FACTORIES_ORDINAL: {

                        EmbeddedWorkerInstanceClientUpdateSubresourceLoaderFactoriesParams data =
                                EmbeddedWorkerInstanceClientUpdateSubresourceLoaderFactoriesParams.deserialize(messageWithHeader.getPayload());

                        getImpl().updateSubresourceLoaderFactories(data.subresourceLoaderFactories);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), EmbeddedWorkerInstanceClient_Internal.MANAGER, messageWithHeader, receiver);














                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class EmbeddedWorkerInstanceClientStartWorkerParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public EmbeddedWorkerStartParams params;

        private EmbeddedWorkerInstanceClientStartWorkerParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public EmbeddedWorkerInstanceClientStartWorkerParams() {
            this(0);
        }

        public static EmbeddedWorkerInstanceClientStartWorkerParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static EmbeddedWorkerInstanceClientStartWorkerParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static EmbeddedWorkerInstanceClientStartWorkerParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            EmbeddedWorkerInstanceClientStartWorkerParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new EmbeddedWorkerInstanceClientStartWorkerParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.params = EmbeddedWorkerStartParams.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.params, 8, false);
        }
    }



    
    static final class EmbeddedWorkerInstanceClientStopWorkerParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private EmbeddedWorkerInstanceClientStopWorkerParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public EmbeddedWorkerInstanceClientStopWorkerParams() {
            this(0);
        }

        public static EmbeddedWorkerInstanceClientStopWorkerParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static EmbeddedWorkerInstanceClientStopWorkerParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static EmbeddedWorkerInstanceClientStopWorkerParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            EmbeddedWorkerInstanceClientStopWorkerParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new EmbeddedWorkerInstanceClientStopWorkerParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class EmbeddedWorkerInstanceClientResumeAfterDownloadParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private EmbeddedWorkerInstanceClientResumeAfterDownloadParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public EmbeddedWorkerInstanceClientResumeAfterDownloadParams() {
            this(0);
        }

        public static EmbeddedWorkerInstanceClientResumeAfterDownloadParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static EmbeddedWorkerInstanceClientResumeAfterDownloadParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static EmbeddedWorkerInstanceClientResumeAfterDownloadParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            EmbeddedWorkerInstanceClientResumeAfterDownloadParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new EmbeddedWorkerInstanceClientResumeAfterDownloadParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class EmbeddedWorkerInstanceClientAddMessageToConsoleParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int level;
        public String message;

        private EmbeddedWorkerInstanceClientAddMessageToConsoleParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public EmbeddedWorkerInstanceClientAddMessageToConsoleParams() {
            this(0);
        }

        public static EmbeddedWorkerInstanceClientAddMessageToConsoleParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static EmbeddedWorkerInstanceClientAddMessageToConsoleParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static EmbeddedWorkerInstanceClientAddMessageToConsoleParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            EmbeddedWorkerInstanceClientAddMessageToConsoleParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new EmbeddedWorkerInstanceClientAddMessageToConsoleParams(elementsOrVersion);
                    {
                        
                    result.level = decoder0.readInt(8);
                        ConsoleMessageLevel.validate(result.level);
                    }
                    {
                        
                    result.message = decoder0.readString(16, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.level, 8);
            
            encoder0.encode(this.message, 16, false);
        }
    }



    
    static final class EmbeddedWorkerInstanceClientBindDevToolsAgentParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo.bindings.AssociatedInterfaceNotSupported agentHost;
        public com.vccorp.mojo.bindings.AssociatedInterfaceRequestNotSupported agent;

        private EmbeddedWorkerInstanceClientBindDevToolsAgentParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public EmbeddedWorkerInstanceClientBindDevToolsAgentParams() {
            this(0);
        }

        public static EmbeddedWorkerInstanceClientBindDevToolsAgentParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static EmbeddedWorkerInstanceClientBindDevToolsAgentParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static EmbeddedWorkerInstanceClientBindDevToolsAgentParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            EmbeddedWorkerInstanceClientBindDevToolsAgentParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new EmbeddedWorkerInstanceClientBindDevToolsAgentParams(elementsOrVersion);
                    {
                        
                    result.agentHost = decoder0.readAssociatedServiceInterfaceNotSupported(8, false);
                    }
                    {
                        
                    result.agent = decoder0.readAssociatedInterfaceRequestNotSupported(16, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.agentHost, 8, false);
            
            encoder0.encode(this.agent, 16, false);
        }
    }



    
    static final class EmbeddedWorkerInstanceClientUpdateSubresourceLoaderFactoriesParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public UrlLoaderFactoryBundle subresourceLoaderFactories;

        private EmbeddedWorkerInstanceClientUpdateSubresourceLoaderFactoriesParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public EmbeddedWorkerInstanceClientUpdateSubresourceLoaderFactoriesParams() {
            this(0);
        }

        public static EmbeddedWorkerInstanceClientUpdateSubresourceLoaderFactoriesParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static EmbeddedWorkerInstanceClientUpdateSubresourceLoaderFactoriesParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static EmbeddedWorkerInstanceClientUpdateSubresourceLoaderFactoriesParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            EmbeddedWorkerInstanceClientUpdateSubresourceLoaderFactoriesParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new EmbeddedWorkerInstanceClientUpdateSubresourceLoaderFactoriesParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.subresourceLoaderFactories = UrlLoaderFactoryBundle.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.subresourceLoaderFactories, 8, false);
        }
    }



}
