
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/devtools/devtools_agent.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class DevToolsSession_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<DevToolsSession, DevToolsSession.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<DevToolsSession, DevToolsSession.Proxy>() {

        @Override
        public String getName() {
            return "blink.mojom.DevToolsSession";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, DevToolsSession impl) {
            return new Stub(core, impl);
        }

        @Override
        public DevToolsSession[] buildArray(int size) {
          return new DevToolsSession[size];
        }
    };


    private static final int DISPATCH_PROTOCOL_COMMAND_ORDINAL = 0;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements DevToolsSession.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void dispatchProtocolCommand(
int callId, String method, DevToolsMessage message) {

            DevToolsSessionDispatchProtocolCommandParams _message = new DevToolsSessionDispatchProtocolCommandParams();

            _message.callId = callId;

            _message.method = method;

            _message.message = message;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(DISPATCH_PROTOCOL_COMMAND_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<DevToolsSession> {

        Stub(com.vccorp.mojo.system.Core core, DevToolsSession impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                DevToolsSession_Internal.MANAGER, messageWithHeader);





                    case DISPATCH_PROTOCOL_COMMAND_ORDINAL: {

                        DevToolsSessionDispatchProtocolCommandParams data =
                                DevToolsSessionDispatchProtocolCommandParams.deserialize(messageWithHeader.getPayload());

                        getImpl().dispatchProtocolCommand(data.callId, data.method, data.message);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), DevToolsSession_Internal.MANAGER, messageWithHeader, receiver);




                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class DevToolsSessionDispatchProtocolCommandParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int callId;
        public String method;
        public DevToolsMessage message;

        private DevToolsSessionDispatchProtocolCommandParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public DevToolsSessionDispatchProtocolCommandParams() {
            this(0);
        }

        public static DevToolsSessionDispatchProtocolCommandParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static DevToolsSessionDispatchProtocolCommandParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static DevToolsSessionDispatchProtocolCommandParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            DevToolsSessionDispatchProtocolCommandParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new DevToolsSessionDispatchProtocolCommandParams(elementsOrVersion);
                    {
                        
                    result.callId = decoder0.readInt(8);
                    }
                    {
                        
                    result.method = decoder0.readString(16, false);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                    result.message = DevToolsMessage.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.callId, 8);
            
            encoder0.encode(this.method, 16, false);
            
            encoder0.encode(this.message, 24, false);
        }
    }



}
