
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/devtools/devtools_agent.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class DevToolsSessionHost_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<DevToolsSessionHost, DevToolsSessionHost.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<DevToolsSessionHost, DevToolsSessionHost.Proxy>() {

        @Override
        public String getName() {
            return "blink.mojom.DevToolsSessionHost";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, DevToolsSessionHost impl) {
            return new Stub(core, impl);
        }

        @Override
        public DevToolsSessionHost[] buildArray(int size) {
          return new DevToolsSessionHost[size];
        }
    };


    private static final int DISPATCH_PROTOCOL_RESPONSE_ORDINAL = 0;

    private static final int DISPATCH_PROTOCOL_NOTIFICATION_ORDINAL = 1;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements DevToolsSessionHost.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void dispatchProtocolResponse(
DevToolsMessage message, int callId, DevToolsSessionState updates) {

            DevToolsSessionHostDispatchProtocolResponseParams _message = new DevToolsSessionHostDispatchProtocolResponseParams();

            _message.message = message;

            _message.callId = callId;

            _message.updates = updates;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(DISPATCH_PROTOCOL_RESPONSE_ORDINAL)));

        }


        @Override
        public void dispatchProtocolNotification(
DevToolsMessage message, DevToolsSessionState updates) {

            DevToolsSessionHostDispatchProtocolNotificationParams _message = new DevToolsSessionHostDispatchProtocolNotificationParams();

            _message.message = message;

            _message.updates = updates;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(DISPATCH_PROTOCOL_NOTIFICATION_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<DevToolsSessionHost> {

        Stub(com.vccorp.mojo.system.Core core, DevToolsSessionHost impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                DevToolsSessionHost_Internal.MANAGER, messageWithHeader);





                    case DISPATCH_PROTOCOL_RESPONSE_ORDINAL: {

                        DevToolsSessionHostDispatchProtocolResponseParams data =
                                DevToolsSessionHostDispatchProtocolResponseParams.deserialize(messageWithHeader.getPayload());

                        getImpl().dispatchProtocolResponse(data.message, data.callId, data.updates);
                        return true;
                    }





                    case DISPATCH_PROTOCOL_NOTIFICATION_ORDINAL: {

                        DevToolsSessionHostDispatchProtocolNotificationParams data =
                                DevToolsSessionHostDispatchProtocolNotificationParams.deserialize(messageWithHeader.getPayload());

                        getImpl().dispatchProtocolNotification(data.message, data.updates);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), DevToolsSessionHost_Internal.MANAGER, messageWithHeader, receiver);






                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class DevToolsSessionHostDispatchProtocolResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public DevToolsMessage message;
        public int callId;
        public DevToolsSessionState updates;

        private DevToolsSessionHostDispatchProtocolResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public DevToolsSessionHostDispatchProtocolResponseParams() {
            this(0);
        }

        public static DevToolsSessionHostDispatchProtocolResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static DevToolsSessionHostDispatchProtocolResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static DevToolsSessionHostDispatchProtocolResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            DevToolsSessionHostDispatchProtocolResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new DevToolsSessionHostDispatchProtocolResponseParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.message = DevToolsMessage.decode(decoder1);
                    }
                    {
                        
                    result.callId = decoder0.readInt(16);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, true);
                    result.updates = DevToolsSessionState.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.message, 8, false);
            
            encoder0.encode(this.callId, 16);
            
            encoder0.encode(this.updates, 24, true);
        }
    }



    
    static final class DevToolsSessionHostDispatchProtocolNotificationParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public DevToolsMessage message;
        public DevToolsSessionState updates;

        private DevToolsSessionHostDispatchProtocolNotificationParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public DevToolsSessionHostDispatchProtocolNotificationParams() {
            this(0);
        }

        public static DevToolsSessionHostDispatchProtocolNotificationParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static DevToolsSessionHostDispatchProtocolNotificationParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static DevToolsSessionHostDispatchProtocolNotificationParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            DevToolsSessionHostDispatchProtocolNotificationParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new DevToolsSessionHostDispatchProtocolNotificationParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.message = DevToolsMessage.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, true);
                    result.updates = DevToolsSessionState.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.message, 8, false);
            
            encoder0.encode(this.updates, 16, true);
        }
    }



}
