
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/devtools/devtools_frontend.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class DevToolsFrontend_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<DevToolsFrontend, DevToolsFrontend.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<DevToolsFrontend, DevToolsFrontend.Proxy>() {

        @Override
        public String getName() {
            return "blink.mojom.DevToolsFrontend";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, DevToolsFrontend impl) {
            return new Stub(core, impl);
        }

        @Override
        public DevToolsFrontend[] buildArray(int size) {
          return new DevToolsFrontend[size];
        }
    };


    private static final int SETUP_DEV_TOOLS_FRONTEND_ORDINAL = 0;

    private static final int SETUP_DEV_TOOLS_EXTENSION_API_ORDINAL = 1;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements DevToolsFrontend.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void setupDevToolsFrontend(
String apiScript, com.vccorp.mojo.bindings.AssociatedInterfaceNotSupported host) {

            DevToolsFrontendSetupDevToolsFrontendParams _message = new DevToolsFrontendSetupDevToolsFrontendParams();

            _message.apiScript = apiScript;

            _message.host = host;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(SETUP_DEV_TOOLS_FRONTEND_ORDINAL)));

        }


        @Override
        public void setupDevToolsExtensionApi(
String extensionApi) {

            DevToolsFrontendSetupDevToolsExtensionApiParams _message = new DevToolsFrontendSetupDevToolsExtensionApiParams();

            _message.extensionApi = extensionApi;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(SETUP_DEV_TOOLS_EXTENSION_API_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<DevToolsFrontend> {

        Stub(com.vccorp.mojo.system.Core core, DevToolsFrontend impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                DevToolsFrontend_Internal.MANAGER, messageWithHeader);





                    case SETUP_DEV_TOOLS_FRONTEND_ORDINAL: {

                        DevToolsFrontendSetupDevToolsFrontendParams data =
                                DevToolsFrontendSetupDevToolsFrontendParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setupDevToolsFrontend(data.apiScript, data.host);
                        return true;
                    }





                    case SETUP_DEV_TOOLS_EXTENSION_API_ORDINAL: {

                        DevToolsFrontendSetupDevToolsExtensionApiParams data =
                                DevToolsFrontendSetupDevToolsExtensionApiParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setupDevToolsExtensionApi(data.extensionApi);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), DevToolsFrontend_Internal.MANAGER, messageWithHeader, receiver);






                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class DevToolsFrontendSetupDevToolsFrontendParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String apiScript;
        public com.vccorp.mojo.bindings.AssociatedInterfaceNotSupported host;

        private DevToolsFrontendSetupDevToolsFrontendParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public DevToolsFrontendSetupDevToolsFrontendParams() {
            this(0);
        }

        public static DevToolsFrontendSetupDevToolsFrontendParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static DevToolsFrontendSetupDevToolsFrontendParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static DevToolsFrontendSetupDevToolsFrontendParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            DevToolsFrontendSetupDevToolsFrontendParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new DevToolsFrontendSetupDevToolsFrontendParams(elementsOrVersion);
                    {
                        
                    result.apiScript = decoder0.readString(8, false);
                    }
                    {
                        
                    result.host = decoder0.readAssociatedServiceInterfaceNotSupported(16, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.apiScript, 8, false);
            
            encoder0.encode(this.host, 16, false);
        }
    }



    
    static final class DevToolsFrontendSetupDevToolsExtensionApiParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String extensionApi;

        private DevToolsFrontendSetupDevToolsExtensionApiParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public DevToolsFrontendSetupDevToolsExtensionApiParams() {
            this(0);
        }

        public static DevToolsFrontendSetupDevToolsExtensionApiParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static DevToolsFrontendSetupDevToolsExtensionApiParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static DevToolsFrontendSetupDevToolsExtensionApiParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            DevToolsFrontendSetupDevToolsExtensionApiParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new DevToolsFrontendSetupDevToolsExtensionApiParams(elementsOrVersion);
                    {
                        
                    result.extensionApi = decoder0.readString(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.extensionApi, 8, false);
        }
    }



}
