
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/clipboard/clipboard.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class ClipboardHost_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<ClipboardHost, ClipboardHost.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<ClipboardHost, ClipboardHost.Proxy>() {

        @Override
        public String getName() {
            return "blink.mojom.ClipboardHost";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, ClipboardHost impl) {
            return new Stub(core, impl);
        }

        @Override
        public ClipboardHost[] buildArray(int size) {
          return new ClipboardHost[size];
        }
    };


    private static final int GET_SEQUENCE_NUMBER_ORDINAL = 0;

    private static final int IS_FORMAT_AVAILABLE_ORDINAL = 1;

    private static final int READ_AVAILABLE_TYPES_ORDINAL = 2;

    private static final int READ_TEXT_ORDINAL = 3;

    private static final int READ_HTML_ORDINAL = 4;

    private static final int READ_RTF_ORDINAL = 5;

    private static final int READ_IMAGE_ORDINAL = 6;

    private static final int READ_CUSTOM_DATA_ORDINAL = 7;

    private static final int WRITE_TEXT_ORDINAL = 8;

    private static final int WRITE_HTML_ORDINAL = 9;

    private static final int WRITE_SMART_PASTE_MARKER_ORDINAL = 10;

    private static final int WRITE_CUSTOM_DATA_ORDINAL = 11;

    private static final int WRITE_BOOKMARK_ORDINAL = 12;

    private static final int WRITE_IMAGE_ORDINAL = 13;

    private static final int COMMIT_WRITE_ORDINAL = 14;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements ClipboardHost.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void getSequenceNumber(
int buffer, 
GetSequenceNumberResponse callback) {

            ClipboardHostGetSequenceNumberParams _message = new ClipboardHostGetSequenceNumberParams();

            _message.buffer = buffer;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_SEQUENCE_NUMBER_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new ClipboardHostGetSequenceNumberResponseParamsForwardToCallback(callback));

        }


        @Override
        public void isFormatAvailable(
int format, int buffer, 
IsFormatAvailableResponse callback) {

            ClipboardHostIsFormatAvailableParams _message = new ClipboardHostIsFormatAvailableParams();

            _message.format = format;

            _message.buffer = buffer;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    IS_FORMAT_AVAILABLE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new ClipboardHostIsFormatAvailableResponseParamsForwardToCallback(callback));

        }


        @Override
        public void readAvailableTypes(
int buffer, 
ReadAvailableTypesResponse callback) {

            ClipboardHostReadAvailableTypesParams _message = new ClipboardHostReadAvailableTypesParams();

            _message.buffer = buffer;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    READ_AVAILABLE_TYPES_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new ClipboardHostReadAvailableTypesResponseParamsForwardToCallback(callback));

        }


        @Override
        public void readText(
int buffer, 
ReadTextResponse callback) {

            ClipboardHostReadTextParams _message = new ClipboardHostReadTextParams();

            _message.buffer = buffer;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    READ_TEXT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new ClipboardHostReadTextResponseParamsForwardToCallback(callback));

        }


        @Override
        public void readHtml(
int buffer, 
ReadHtmlResponse callback) {

            ClipboardHostReadHtmlParams _message = new ClipboardHostReadHtmlParams();

            _message.buffer = buffer;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    READ_HTML_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new ClipboardHostReadHtmlResponseParamsForwardToCallback(callback));

        }


        @Override
        public void readRtf(
int buffer, 
ReadRtfResponse callback) {

            ClipboardHostReadRtfParams _message = new ClipboardHostReadRtfParams();

            _message.buffer = buffer;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    READ_RTF_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new ClipboardHostReadRtfResponseParamsForwardToCallback(callback));

        }


        @Override
        public void readImage(
int buffer, 
ReadImageResponse callback) {

            ClipboardHostReadImageParams _message = new ClipboardHostReadImageParams();

            _message.buffer = buffer;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    READ_IMAGE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new ClipboardHostReadImageResponseParamsForwardToCallback(callback));

        }


        @Override
        public void readCustomData(
int buffer, com.vccorp.mojo_base.mojom.String16 type,
ReadCustomDataResponse callback) {

            ClipboardHostReadCustomDataParams _message = new ClipboardHostReadCustomDataParams();

            _message.buffer = buffer;

            _message.type = type;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    READ_CUSTOM_DATA_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new ClipboardHostReadCustomDataResponseParamsForwardToCallback(callback));

        }


        @Override
        public void writeText(
int buffer, com.vccorp.mojo_base.mojom.BigString16 text) {

            ClipboardHostWriteTextParams _message = new ClipboardHostWriteTextParams();

            _message.buffer = buffer;

            _message.text = text;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(WRITE_TEXT_ORDINAL)));

        }


        @Override
        public void writeHtml(
int buffer, com.vccorp.mojo_base.mojom.BigString16 markup, com.vccorp.url.mojom.Url url) {

            ClipboardHostWriteHtmlParams _message = new ClipboardHostWriteHtmlParams();

            _message.buffer = buffer;

            _message.markup = markup;

            _message.url = url;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(WRITE_HTML_ORDINAL)));

        }


        @Override
        public void writeSmartPasteMarker(
int buffer) {

            ClipboardHostWriteSmartPasteMarkerParams _message = new ClipboardHostWriteSmartPasteMarkerParams();

            _message.buffer = buffer;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(WRITE_SMART_PASTE_MARKER_ORDINAL)));

        }


        @Override
        public void writeCustomData(
int buffer, java.util.Map<com.vccorp.mojo_base.mojom.String16, com.vccorp.mojo_base.mojom.BigString16> data) {

            ClipboardHostWriteCustomDataParams _message = new ClipboardHostWriteCustomDataParams();

            _message.buffer = buffer;

            _message.data = data;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(WRITE_CUSTOM_DATA_ORDINAL)));

        }


        @Override
        public void writeBookmark(
int buffer, String url, com.vccorp.mojo_base.mojom.String16 title) {

            ClipboardHostWriteBookmarkParams _message = new ClipboardHostWriteBookmarkParams();

            _message.buffer = buffer;

            _message.url = url;

            _message.title = title;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(WRITE_BOOKMARK_ORDINAL)));

        }


        @Override
        public void writeImage(
int buffer, com.vccorp.skia.mojom.Bitmap image) {

            ClipboardHostWriteImageParams _message = new ClipboardHostWriteImageParams();

            _message.buffer = buffer;

            _message.image = image;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(WRITE_IMAGE_ORDINAL)));

        }


        @Override
        public void commitWrite(
int buffer) {

            ClipboardHostCommitWriteParams _message = new ClipboardHostCommitWriteParams();

            _message.buffer = buffer;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(COMMIT_WRITE_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<ClipboardHost> {

        Stub(com.vccorp.mojo.system.Core core, ClipboardHost impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                ClipboardHost_Internal.MANAGER, messageWithHeader);





















                    case WRITE_TEXT_ORDINAL: {

                        ClipboardHostWriteTextParams data =
                                ClipboardHostWriteTextParams.deserialize(messageWithHeader.getPayload());

                        getImpl().writeText(data.buffer, data.text);
                        return true;
                    }





                    case WRITE_HTML_ORDINAL: {

                        ClipboardHostWriteHtmlParams data =
                                ClipboardHostWriteHtmlParams.deserialize(messageWithHeader.getPayload());

                        getImpl().writeHtml(data.buffer, data.markup, data.url);
                        return true;
                    }





                    case WRITE_SMART_PASTE_MARKER_ORDINAL: {

                        ClipboardHostWriteSmartPasteMarkerParams data =
                                ClipboardHostWriteSmartPasteMarkerParams.deserialize(messageWithHeader.getPayload());

                        getImpl().writeSmartPasteMarker(data.buffer);
                        return true;
                    }





                    case WRITE_CUSTOM_DATA_ORDINAL: {

                        ClipboardHostWriteCustomDataParams data =
                                ClipboardHostWriteCustomDataParams.deserialize(messageWithHeader.getPayload());

                        getImpl().writeCustomData(data.buffer, data.data);
                        return true;
                    }





                    case WRITE_BOOKMARK_ORDINAL: {

                        ClipboardHostWriteBookmarkParams data =
                                ClipboardHostWriteBookmarkParams.deserialize(messageWithHeader.getPayload());

                        getImpl().writeBookmark(data.buffer, data.url, data.title);
                        return true;
                    }





                    case WRITE_IMAGE_ORDINAL: {

                        ClipboardHostWriteImageParams data =
                                ClipboardHostWriteImageParams.deserialize(messageWithHeader.getPayload());

                        getImpl().writeImage(data.buffer, data.image);
                        return true;
                    }





                    case COMMIT_WRITE_ORDINAL: {

                        ClipboardHostCommitWriteParams data =
                                ClipboardHostCommitWriteParams.deserialize(messageWithHeader.getPayload());

                        getImpl().commitWrite(data.buffer);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), ClipboardHost_Internal.MANAGER, messageWithHeader, receiver);







                    case GET_SEQUENCE_NUMBER_ORDINAL: {

                        ClipboardHostGetSequenceNumberParams data =
                                ClipboardHostGetSequenceNumberParams.deserialize(messageWithHeader.getPayload());

                        getImpl().getSequenceNumber(data.buffer, new ClipboardHostGetSequenceNumberResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case IS_FORMAT_AVAILABLE_ORDINAL: {

                        ClipboardHostIsFormatAvailableParams data =
                                ClipboardHostIsFormatAvailableParams.deserialize(messageWithHeader.getPayload());

                        getImpl().isFormatAvailable(data.format, data.buffer, new ClipboardHostIsFormatAvailableResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case READ_AVAILABLE_TYPES_ORDINAL: {

                        ClipboardHostReadAvailableTypesParams data =
                                ClipboardHostReadAvailableTypesParams.deserialize(messageWithHeader.getPayload());

                        getImpl().readAvailableTypes(data.buffer, new ClipboardHostReadAvailableTypesResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case READ_TEXT_ORDINAL: {

                        ClipboardHostReadTextParams data =
                                ClipboardHostReadTextParams.deserialize(messageWithHeader.getPayload());

                        getImpl().readText(data.buffer, new ClipboardHostReadTextResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case READ_HTML_ORDINAL: {

                        ClipboardHostReadHtmlParams data =
                                ClipboardHostReadHtmlParams.deserialize(messageWithHeader.getPayload());

                        getImpl().readHtml(data.buffer, new ClipboardHostReadHtmlResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case READ_RTF_ORDINAL: {

                        ClipboardHostReadRtfParams data =
                                ClipboardHostReadRtfParams.deserialize(messageWithHeader.getPayload());

                        getImpl().readRtf(data.buffer, new ClipboardHostReadRtfResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case READ_IMAGE_ORDINAL: {

                        ClipboardHostReadImageParams data =
                                ClipboardHostReadImageParams.deserialize(messageWithHeader.getPayload());

                        getImpl().readImage(data.buffer, new ClipboardHostReadImageResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case READ_CUSTOM_DATA_ORDINAL: {

                        ClipboardHostReadCustomDataParams data =
                                ClipboardHostReadCustomDataParams.deserialize(messageWithHeader.getPayload());

                        getImpl().readCustomData(data.buffer, data.type, new ClipboardHostReadCustomDataResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
















                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class ClipboardHostGetSequenceNumberParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int buffer;

        private ClipboardHostGetSequenceNumberParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ClipboardHostGetSequenceNumberParams() {
            this(0);
        }

        public static ClipboardHostGetSequenceNumberParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ClipboardHostGetSequenceNumberParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ClipboardHostGetSequenceNumberParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ClipboardHostGetSequenceNumberParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ClipboardHostGetSequenceNumberParams(elementsOrVersion);
                    {
                        
                    result.buffer = decoder0.readInt(8);
                        ClipboardBuffer.validate(result.buffer);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.buffer, 8);
        }
    }



    
    static final class ClipboardHostGetSequenceNumberResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public long result;

        private ClipboardHostGetSequenceNumberResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ClipboardHostGetSequenceNumberResponseParams() {
            this(0);
        }

        public static ClipboardHostGetSequenceNumberResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ClipboardHostGetSequenceNumberResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ClipboardHostGetSequenceNumberResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ClipboardHostGetSequenceNumberResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ClipboardHostGetSequenceNumberResponseParams(elementsOrVersion);
                    {
                        
                    result.result = decoder0.readLong(8);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.result, 8);
        }
    }

    static class ClipboardHostGetSequenceNumberResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final ClipboardHost.GetSequenceNumberResponse mCallback;

        ClipboardHostGetSequenceNumberResponseParamsForwardToCallback(ClipboardHost.GetSequenceNumberResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(GET_SEQUENCE_NUMBER_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                ClipboardHostGetSequenceNumberResponseParams response = ClipboardHostGetSequenceNumberResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.result);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class ClipboardHostGetSequenceNumberResponseParamsProxyToResponder implements ClipboardHost.GetSequenceNumberResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        ClipboardHostGetSequenceNumberResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Long result) {
            ClipboardHostGetSequenceNumberResponseParams _response = new ClipboardHostGetSequenceNumberResponseParams();

            _response.result = result;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_SEQUENCE_NUMBER_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class ClipboardHostIsFormatAvailableParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int format;
        public int buffer;

        private ClipboardHostIsFormatAvailableParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ClipboardHostIsFormatAvailableParams() {
            this(0);
        }

        public static ClipboardHostIsFormatAvailableParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ClipboardHostIsFormatAvailableParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ClipboardHostIsFormatAvailableParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ClipboardHostIsFormatAvailableParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ClipboardHostIsFormatAvailableParams(elementsOrVersion);
                    {
                        
                    result.format = decoder0.readInt(8);
                        ClipboardFormat.validate(result.format);
                    }
                    {
                        
                    result.buffer = decoder0.readInt(12);
                        ClipboardBuffer.validate(result.buffer);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.format, 8);
            
            encoder0.encode(this.buffer, 12);
        }
    }



    
    static final class ClipboardHostIsFormatAvailableResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean result;

        private ClipboardHostIsFormatAvailableResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ClipboardHostIsFormatAvailableResponseParams() {
            this(0);
        }

        public static ClipboardHostIsFormatAvailableResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ClipboardHostIsFormatAvailableResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ClipboardHostIsFormatAvailableResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ClipboardHostIsFormatAvailableResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ClipboardHostIsFormatAvailableResponseParams(elementsOrVersion);
                    {
                        
                    result.result = decoder0.readBoolean(8, 0);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.result, 8, 0);
        }
    }

    static class ClipboardHostIsFormatAvailableResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final ClipboardHost.IsFormatAvailableResponse mCallback;

        ClipboardHostIsFormatAvailableResponseParamsForwardToCallback(ClipboardHost.IsFormatAvailableResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(IS_FORMAT_AVAILABLE_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                ClipboardHostIsFormatAvailableResponseParams response = ClipboardHostIsFormatAvailableResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.result);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class ClipboardHostIsFormatAvailableResponseParamsProxyToResponder implements ClipboardHost.IsFormatAvailableResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        ClipboardHostIsFormatAvailableResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Boolean result) {
            ClipboardHostIsFormatAvailableResponseParams _response = new ClipboardHostIsFormatAvailableResponseParams();

            _response.result = result;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    IS_FORMAT_AVAILABLE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class ClipboardHostReadAvailableTypesParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int buffer;

        private ClipboardHostReadAvailableTypesParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ClipboardHostReadAvailableTypesParams() {
            this(0);
        }

        public static ClipboardHostReadAvailableTypesParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ClipboardHostReadAvailableTypesParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ClipboardHostReadAvailableTypesParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ClipboardHostReadAvailableTypesParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ClipboardHostReadAvailableTypesParams(elementsOrVersion);
                    {
                        
                    result.buffer = decoder0.readInt(8);
                        ClipboardBuffer.validate(result.buffer);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.buffer, 8);
        }
    }



    
    static final class ClipboardHostReadAvailableTypesResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo_base.mojom.String16[] types;
        public boolean result;

        private ClipboardHostReadAvailableTypesResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ClipboardHostReadAvailableTypesResponseParams() {
            this(0);
        }

        public static ClipboardHostReadAvailableTypesResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ClipboardHostReadAvailableTypesResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ClipboardHostReadAvailableTypesResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ClipboardHostReadAvailableTypesResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ClipboardHostReadAvailableTypesResponseParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.types = new com.vccorp.mojo_base.mojom.String16[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                            result.types[i1] = com.vccorp.mojo_base.mojom.String16.decode(decoder2);
                        }
                    }
                    }
                    {
                        
                    result.result = decoder0.readBoolean(16, 0);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            if (this.types == null) {
                encoder0.encodeNullPointer(8, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.types.length, 8, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.types.length; ++i0) {
                    
                    encoder1.encode(this.types[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
            
            encoder0.encode(this.result, 16, 0);
        }
    }

    static class ClipboardHostReadAvailableTypesResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final ClipboardHost.ReadAvailableTypesResponse mCallback;

        ClipboardHostReadAvailableTypesResponseParamsForwardToCallback(ClipboardHost.ReadAvailableTypesResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(READ_AVAILABLE_TYPES_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                ClipboardHostReadAvailableTypesResponseParams response = ClipboardHostReadAvailableTypesResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.types, response.result);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class ClipboardHostReadAvailableTypesResponseParamsProxyToResponder implements ClipboardHost.ReadAvailableTypesResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        ClipboardHostReadAvailableTypesResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(com.vccorp.mojo_base.mojom.String16[] types, Boolean result) {
            ClipboardHostReadAvailableTypesResponseParams _response = new ClipboardHostReadAvailableTypesResponseParams();

            _response.types = types;

            _response.result = result;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    READ_AVAILABLE_TYPES_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class ClipboardHostReadTextParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int buffer;

        private ClipboardHostReadTextParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ClipboardHostReadTextParams() {
            this(0);
        }

        public static ClipboardHostReadTextParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ClipboardHostReadTextParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ClipboardHostReadTextParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ClipboardHostReadTextParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ClipboardHostReadTextParams(elementsOrVersion);
                    {
                        
                    result.buffer = decoder0.readInt(8);
                        ClipboardBuffer.validate(result.buffer);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.buffer, 8);
        }
    }



    
    static final class ClipboardHostReadTextResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo_base.mojom.BigString16 result;

        private ClipboardHostReadTextResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ClipboardHostReadTextResponseParams() {
            this(0);
        }

        public static ClipboardHostReadTextResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ClipboardHostReadTextResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ClipboardHostReadTextResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ClipboardHostReadTextResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ClipboardHostReadTextResponseParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.result = com.vccorp.mojo_base.mojom.BigString16.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.result, 8, false);
        }
    }

    static class ClipboardHostReadTextResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final ClipboardHost.ReadTextResponse mCallback;

        ClipboardHostReadTextResponseParamsForwardToCallback(ClipboardHost.ReadTextResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(READ_TEXT_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                ClipboardHostReadTextResponseParams response = ClipboardHostReadTextResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.result);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class ClipboardHostReadTextResponseParamsProxyToResponder implements ClipboardHost.ReadTextResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        ClipboardHostReadTextResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(com.vccorp.mojo_base.mojom.BigString16 result) {
            ClipboardHostReadTextResponseParams _response = new ClipboardHostReadTextResponseParams();

            _response.result = result;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    READ_TEXT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class ClipboardHostReadHtmlParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int buffer;

        private ClipboardHostReadHtmlParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ClipboardHostReadHtmlParams() {
            this(0);
        }

        public static ClipboardHostReadHtmlParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ClipboardHostReadHtmlParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ClipboardHostReadHtmlParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ClipboardHostReadHtmlParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ClipboardHostReadHtmlParams(elementsOrVersion);
                    {
                        
                    result.buffer = decoder0.readInt(8);
                        ClipboardBuffer.validate(result.buffer);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.buffer, 8);
        }
    }



    
    static final class ClipboardHostReadHtmlResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo_base.mojom.BigString16 markup;
        public com.vccorp.url.mojom.Url url;
        public int fragmentStart;
        public int fragmentEnd;

        private ClipboardHostReadHtmlResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ClipboardHostReadHtmlResponseParams() {
            this(0);
        }

        public static ClipboardHostReadHtmlResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ClipboardHostReadHtmlResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ClipboardHostReadHtmlResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ClipboardHostReadHtmlResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ClipboardHostReadHtmlResponseParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.markup = com.vccorp.mojo_base.mojom.BigString16.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.url = com.vccorp.url.mojom.Url.decode(decoder1);
                    }
                    {
                        
                    result.fragmentStart = decoder0.readInt(24);
                    }
                    {
                        
                    result.fragmentEnd = decoder0.readInt(28);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.markup, 8, false);
            
            encoder0.encode(this.url, 16, false);
            
            encoder0.encode(this.fragmentStart, 24);
            
            encoder0.encode(this.fragmentEnd, 28);
        }
    }

    static class ClipboardHostReadHtmlResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final ClipboardHost.ReadHtmlResponse mCallback;

        ClipboardHostReadHtmlResponseParamsForwardToCallback(ClipboardHost.ReadHtmlResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(READ_HTML_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                ClipboardHostReadHtmlResponseParams response = ClipboardHostReadHtmlResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.markup, response.url, response.fragmentStart, response.fragmentEnd);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class ClipboardHostReadHtmlResponseParamsProxyToResponder implements ClipboardHost.ReadHtmlResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        ClipboardHostReadHtmlResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(com.vccorp.mojo_base.mojom.BigString16 markup, com.vccorp.url.mojom.Url url, Integer fragmentStart, Integer fragmentEnd) {
            ClipboardHostReadHtmlResponseParams _response = new ClipboardHostReadHtmlResponseParams();

            _response.markup = markup;

            _response.url = url;

            _response.fragmentStart = fragmentStart;

            _response.fragmentEnd = fragmentEnd;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    READ_HTML_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class ClipboardHostReadRtfParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int buffer;

        private ClipboardHostReadRtfParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ClipboardHostReadRtfParams() {
            this(0);
        }

        public static ClipboardHostReadRtfParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ClipboardHostReadRtfParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ClipboardHostReadRtfParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ClipboardHostReadRtfParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ClipboardHostReadRtfParams(elementsOrVersion);
                    {
                        
                    result.buffer = decoder0.readInt(8);
                        ClipboardBuffer.validate(result.buffer);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.buffer, 8);
        }
    }



    
    static final class ClipboardHostReadRtfResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String result;

        private ClipboardHostReadRtfResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ClipboardHostReadRtfResponseParams() {
            this(0);
        }

        public static ClipboardHostReadRtfResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ClipboardHostReadRtfResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ClipboardHostReadRtfResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ClipboardHostReadRtfResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ClipboardHostReadRtfResponseParams(elementsOrVersion);
                    {
                        
                    result.result = decoder0.readString(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.result, 8, false);
        }
    }

    static class ClipboardHostReadRtfResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final ClipboardHost.ReadRtfResponse mCallback;

        ClipboardHostReadRtfResponseParamsForwardToCallback(ClipboardHost.ReadRtfResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(READ_RTF_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                ClipboardHostReadRtfResponseParams response = ClipboardHostReadRtfResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.result);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class ClipboardHostReadRtfResponseParamsProxyToResponder implements ClipboardHost.ReadRtfResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        ClipboardHostReadRtfResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(String result) {
            ClipboardHostReadRtfResponseParams _response = new ClipboardHostReadRtfResponseParams();

            _response.result = result;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    READ_RTF_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class ClipboardHostReadImageParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int buffer;

        private ClipboardHostReadImageParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ClipboardHostReadImageParams() {
            this(0);
        }

        public static ClipboardHostReadImageParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ClipboardHostReadImageParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ClipboardHostReadImageParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ClipboardHostReadImageParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ClipboardHostReadImageParams(elementsOrVersion);
                    {
                        
                    result.buffer = decoder0.readInt(8);
                        ClipboardBuffer.validate(result.buffer);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.buffer, 8);
        }
    }



    
    static final class ClipboardHostReadImageResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.skia.mojom.Bitmap image;

        private ClipboardHostReadImageResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ClipboardHostReadImageResponseParams() {
            this(0);
        }

        public static ClipboardHostReadImageResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ClipboardHostReadImageResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ClipboardHostReadImageResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ClipboardHostReadImageResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ClipboardHostReadImageResponseParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, true);
                    result.image = com.vccorp.skia.mojom.Bitmap.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.image, 8, true);
        }
    }

    static class ClipboardHostReadImageResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final ClipboardHost.ReadImageResponse mCallback;

        ClipboardHostReadImageResponseParamsForwardToCallback(ClipboardHost.ReadImageResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(READ_IMAGE_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                ClipboardHostReadImageResponseParams response = ClipboardHostReadImageResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.image);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class ClipboardHostReadImageResponseParamsProxyToResponder implements ClipboardHost.ReadImageResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        ClipboardHostReadImageResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(com.vccorp.skia.mojom.Bitmap image) {
            ClipboardHostReadImageResponseParams _response = new ClipboardHostReadImageResponseParams();

            _response.image = image;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    READ_IMAGE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class ClipboardHostReadCustomDataParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int buffer;
        public com.vccorp.mojo_base.mojom.String16 type;

        private ClipboardHostReadCustomDataParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ClipboardHostReadCustomDataParams() {
            this(0);
        }

        public static ClipboardHostReadCustomDataParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ClipboardHostReadCustomDataParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ClipboardHostReadCustomDataParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ClipboardHostReadCustomDataParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ClipboardHostReadCustomDataParams(elementsOrVersion);
                    {
                        
                    result.buffer = decoder0.readInt(8);
                        ClipboardBuffer.validate(result.buffer);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.type = com.vccorp.mojo_base.mojom.String16.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.buffer, 8);
            
            encoder0.encode(this.type, 16, false);
        }
    }



    
    static final class ClipboardHostReadCustomDataResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo_base.mojom.BigString16 result;

        private ClipboardHostReadCustomDataResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ClipboardHostReadCustomDataResponseParams() {
            this(0);
        }

        public static ClipboardHostReadCustomDataResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ClipboardHostReadCustomDataResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ClipboardHostReadCustomDataResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ClipboardHostReadCustomDataResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ClipboardHostReadCustomDataResponseParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.result = com.vccorp.mojo_base.mojom.BigString16.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.result, 8, false);
        }
    }

    static class ClipboardHostReadCustomDataResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final ClipboardHost.ReadCustomDataResponse mCallback;

        ClipboardHostReadCustomDataResponseParamsForwardToCallback(ClipboardHost.ReadCustomDataResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(READ_CUSTOM_DATA_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                ClipboardHostReadCustomDataResponseParams response = ClipboardHostReadCustomDataResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.result);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class ClipboardHostReadCustomDataResponseParamsProxyToResponder implements ClipboardHost.ReadCustomDataResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        ClipboardHostReadCustomDataResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(com.vccorp.mojo_base.mojom.BigString16 result) {
            ClipboardHostReadCustomDataResponseParams _response = new ClipboardHostReadCustomDataResponseParams();

            _response.result = result;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    READ_CUSTOM_DATA_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class ClipboardHostWriteTextParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int buffer;
        public com.vccorp.mojo_base.mojom.BigString16 text;

        private ClipboardHostWriteTextParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ClipboardHostWriteTextParams() {
            this(0);
        }

        public static ClipboardHostWriteTextParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ClipboardHostWriteTextParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ClipboardHostWriteTextParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ClipboardHostWriteTextParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ClipboardHostWriteTextParams(elementsOrVersion);
                    {
                        
                    result.buffer = decoder0.readInt(8);
                        ClipboardBuffer.validate(result.buffer);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.text = com.vccorp.mojo_base.mojom.BigString16.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.buffer, 8);
            
            encoder0.encode(this.text, 16, false);
        }
    }



    
    static final class ClipboardHostWriteHtmlParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int buffer;
        public com.vccorp.mojo_base.mojom.BigString16 markup;
        public com.vccorp.url.mojom.Url url;

        private ClipboardHostWriteHtmlParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ClipboardHostWriteHtmlParams() {
            this(0);
        }

        public static ClipboardHostWriteHtmlParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ClipboardHostWriteHtmlParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ClipboardHostWriteHtmlParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ClipboardHostWriteHtmlParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ClipboardHostWriteHtmlParams(elementsOrVersion);
                    {
                        
                    result.buffer = decoder0.readInt(8);
                        ClipboardBuffer.validate(result.buffer);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.markup = com.vccorp.mojo_base.mojom.BigString16.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                    result.url = com.vccorp.url.mojom.Url.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.buffer, 8);
            
            encoder0.encode(this.markup, 16, false);
            
            encoder0.encode(this.url, 24, false);
        }
    }



    
    static final class ClipboardHostWriteSmartPasteMarkerParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int buffer;

        private ClipboardHostWriteSmartPasteMarkerParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ClipboardHostWriteSmartPasteMarkerParams() {
            this(0);
        }

        public static ClipboardHostWriteSmartPasteMarkerParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ClipboardHostWriteSmartPasteMarkerParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ClipboardHostWriteSmartPasteMarkerParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ClipboardHostWriteSmartPasteMarkerParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ClipboardHostWriteSmartPasteMarkerParams(elementsOrVersion);
                    {
                        
                    result.buffer = decoder0.readInt(8);
                        ClipboardBuffer.validate(result.buffer);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.buffer, 8);
        }
    }



    
    static final class ClipboardHostWriteCustomDataParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int buffer;
        public java.util.Map<com.vccorp.mojo_base.mojom.String16, com.vccorp.mojo_base.mojom.BigString16> data;

        private ClipboardHostWriteCustomDataParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ClipboardHostWriteCustomDataParams() {
            this(0);
        }

        public static ClipboardHostWriteCustomDataParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ClipboardHostWriteCustomDataParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ClipboardHostWriteCustomDataParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ClipboardHostWriteCustomDataParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ClipboardHostWriteCustomDataParams(elementsOrVersion);
                    {
                        
                    result.buffer = decoder0.readInt(8);
                        ClipboardBuffer.validate(result.buffer);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    {
                        decoder1.readDataHeaderForMap();
                        com.vccorp.mojo_base.mojom.String16[] keys0;
                        com.vccorp.mojo_base.mojom.BigString16[] values0;
                        {
                            
                            com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE, false);
                            {
                                com.vccorp.mojo.bindings.DataHeader si2 = decoder2.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                                keys0 = new com.vccorp.mojo_base.mojom.String16[si2.elementsOrVersion];
                                for (int i2 = 0; i2 < si2.elementsOrVersion; ++i2) {
                                    
                                    com.vccorp.mojo.bindings.Decoder decoder3 = decoder2.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i2, false);
                                    keys0[i2] = com.vccorp.mojo_base.mojom.String16.decode(decoder3);
                                }
                            }
                        }
                        {
                            
                            com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE, false);
                            {
                                com.vccorp.mojo.bindings.DataHeader si2 = decoder2.readDataHeaderForPointerArray(keys0.length);
                                values0 = new com.vccorp.mojo_base.mojom.BigString16[si2.elementsOrVersion];
                                for (int i2 = 0; i2 < si2.elementsOrVersion; ++i2) {
                                    
                                    com.vccorp.mojo.bindings.Decoder decoder3 = decoder2.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i2, false);
                                    values0[i2] = com.vccorp.mojo_base.mojom.BigString16.decode(decoder3);
                                }
                            }
                        }
                        result.data = new java.util.HashMap<com.vccorp.mojo_base.mojom.String16, com.vccorp.mojo_base.mojom.BigString16>();
                        for (int index0 = 0; index0 < keys0.length; ++index0) {
                            result.data.put(keys0[index0],  values0[index0]);
                        }
                    }
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.buffer, 8);
            
            if (this.data == null) {
                encoder0.encodeNullPointer(16, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encoderForMap(16);
                int size0 = this.data.size();
                com.vccorp.mojo_base.mojom.String16[] keys0 = new com.vccorp.mojo_base.mojom.String16[size0];
                com.vccorp.mojo_base.mojom.BigString16[] values0 = new com.vccorp.mojo_base.mojom.BigString16[size0];
                int index0 = 0;
                for (java.util.Map.Entry<com.vccorp.mojo_base.mojom.String16, com.vccorp.mojo_base.mojom.BigString16> entry0 : this.data.entrySet()) {
                    keys0[index0] = entry0.getKey();
                    values0[index0] = entry0.getValue();
                    ++index0;
                }
                
                {
                    org.chromium.mojo.bindings.Encoder encoder2 = encoder1.encodePointerArray(keys0.length, com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    for (int i1 = 0; i1 < keys0.length; ++i1) {
                        
                        encoder2.encode(keys0[i1], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                    }
                }
                
                {
                    org.chromium.mojo.bindings.Encoder encoder2 = encoder1.encodePointerArray(values0.length, com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    for (int i1 = 0; i1 < values0.length; ++i1) {
                        
                        encoder2.encode(values0[i1], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                    }
                }
            }
        }
    }



    
    static final class ClipboardHostWriteBookmarkParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int buffer;
        public String url;
        public com.vccorp.mojo_base.mojom.String16 title;

        private ClipboardHostWriteBookmarkParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ClipboardHostWriteBookmarkParams() {
            this(0);
        }

        public static ClipboardHostWriteBookmarkParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ClipboardHostWriteBookmarkParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ClipboardHostWriteBookmarkParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ClipboardHostWriteBookmarkParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ClipboardHostWriteBookmarkParams(elementsOrVersion);
                    {
                        
                    result.buffer = decoder0.readInt(8);
                        ClipboardBuffer.validate(result.buffer);
                    }
                    {
                        
                    result.url = decoder0.readString(16, false);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                    result.title = com.vccorp.mojo_base.mojom.String16.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.buffer, 8);
            
            encoder0.encode(this.url, 16, false);
            
            encoder0.encode(this.title, 24, false);
        }
    }



    
    static final class ClipboardHostWriteImageParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int buffer;
        public com.vccorp.skia.mojom.Bitmap image;

        private ClipboardHostWriteImageParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ClipboardHostWriteImageParams() {
            this(0);
        }

        public static ClipboardHostWriteImageParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ClipboardHostWriteImageParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ClipboardHostWriteImageParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ClipboardHostWriteImageParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ClipboardHostWriteImageParams(elementsOrVersion);
                    {
                        
                    result.buffer = decoder0.readInt(8);
                        ClipboardBuffer.validate(result.buffer);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.image = com.vccorp.skia.mojom.Bitmap.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.buffer, 8);
            
            encoder0.encode(this.image, 16, false);
        }
    }



    
    static final class ClipboardHostCommitWriteParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int buffer;

        private ClipboardHostCommitWriteParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ClipboardHostCommitWriteParams() {
            this(0);
        }

        public static ClipboardHostCommitWriteParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ClipboardHostCommitWriteParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ClipboardHostCommitWriteParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ClipboardHostCommitWriteParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ClipboardHostCommitWriteParams(elementsOrVersion);
                    {
                        
                    result.buffer = decoder0.readInt(8);
                        ClipboardBuffer.validate(result.buffer);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.buffer, 8);
        }
    }



}
