/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.base;

import a.b.a.g;
import a.b.a.l;
import a.b.o.d.b;
import android.annotation.TargetApi;
import android.content.ClipData;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.support.v4.view.MarginLayoutParamsCompat;
import android.view.MotionEvent;
import android.view.PointerIcon;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import java.util.Iterator;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="ui")
public class ViewAndroidDelegate {
    public static final /* synthetic */ boolean $assertionsDisabled;
    public ViewGroup mContainerView;
    public int[] mTemporaryContainerLocation = new int[2];
    public l<ContainerViewObserver> mContainerViewObservers = new l();

    public static ViewAndroidDelegate createBasicDelegate(ViewGroup viewGroup) {
        return new ViewAndroidDelegate(viewGroup);
    }

    public ViewAndroidDelegate(ViewGroup viewGroup) {
        this.mContainerView = viewGroup;
    }

    @TargetApi(value=24)
    private boolean startDragAndDrop(String string2, Bitmap bitmap) {
        ImageView imageView;
        if (Build.VERSION.SDK_INT <= 23) {
            return false;
        }
        if ((this = this.getContainerView()) == null) {
            return false;
        }
        ImageView imageView2 = imageView;
        Bitmap bitmap2 = bitmap;
        imageView2(this.getContext());
        imageView2.setImageBitmap(bitmap);
        int n2 = bitmap2.getWidth();
        int n3 = bitmap2.getHeight();
        imageView.layout(0, 0, n2, n3);
        return this.startDragAndDrop(ClipData.newPlainText(null, (CharSequence)string2), new View.DragShadowBuilder((View)imageView2), null, 256);
    }

    private int getXLocationOfContainerViewInWindow() {
        ViewGroup viewGroup = this.getContainerView();
        if (viewGroup == null) {
            return 0;
        }
        viewGroup.getLocationInWindow(this.mTemporaryContainerLocation);
        return this.mTemporaryContainerLocation[0];
    }

    private int getYLocationOfContainerViewInWindow() {
        ViewGroup viewGroup = this.getContainerView();
        if (viewGroup == null) {
            return 0;
        }
        viewGroup.getLocationInWindow(this.mTemporaryContainerLocation);
        return this.mTemporaryContainerLocation[1];
    }

    private int getXLocationOnScreen() {
        ViewGroup viewGroup = this.getContainerView();
        if (viewGroup == null) {
            return 0;
        }
        viewGroup.getLocationOnScreen(this.mTemporaryContainerLocation);
        return this.mTemporaryContainerLocation[0];
    }

    private int getYLocationOnScreen() {
        ViewGroup viewGroup = this.getContainerView();
        if (viewGroup == null) {
            return 0;
        }
        viewGroup.getLocationOnScreen(this.mTemporaryContainerLocation);
        return this.mTemporaryContainerLocation[1];
    }

    private void requestDisallowInterceptTouchEvent() {
        if ((this = this.getContainerView()) != null) {
            this.requestDisallowInterceptTouchEvent(true);
        }
    }

    @TargetApi(value=21)
    private void requestUnbufferedDispatch(MotionEvent motionEvent) {
        if ((this = this.getContainerView()) != null) {
            this.requestUnbufferedDispatch(motionEvent);
        }
    }

    private boolean hasFocus() {
        return (this = this.getContainerView()) == null ? false : g.a((View)this);
    }

    private void requestFocus() {
        if ((this = this.getContainerView()) != null && g.b((View)this) && !this.isFocused()) {
            this.requestFocus();
        }
    }

    public static boolean hasTouchlessEventHandler() {
        boolean bl = b.a != null;
        return bl;
    }

    public static boolean onUnconsumedKeyboardEventAck(int n2) {
        if (!b.b && b.a == null) {
            throw new AssertionError();
        }
        b.a.a(n2);
        return false;
    }

    public static void fallbackCursorModeLockCursor(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        b.a.a(bl, bl2, bl3, bl4);
    }

    public static void fallbackCursorModeSetCursorVisibility(boolean bl) {
        b.a.a(bl);
    }

    static {
        $assertionsDisabled = ViewAndroidDelegate.class.desiredAssertionStatus() ^ true;
    }

    public final void addObserver(ContainerViewObserver containerViewObserver) {
        this.mContainerViewObservers.a(containerViewObserver);
    }

    public final void setContainerView(ViewGroup viewGroup) {
        ViewAndroidDelegate viewAndroidDelegate = iterator;
        ((ViewAndroidDelegate)((Object)iterator)).mContainerView = viewGroup;
        viewAndroidDelegate.updateAnchorViews(viewAndroidDelegate.mContainerView);
        Iterator<ContainerViewObserver> iterator = viewAndroidDelegate.mContainerViewObservers.iterator();
        while (iterator.hasNext()) {
            ((ContainerViewObserver)iterator.next()).onUpdateContainerView(viewGroup);
        }
    }

    public void updateAnchorViews(ViewGroup viewGroup) {
    }

    public View acquireView() {
        if ((this = this.getContainerView()) != null && this.getParent() != null) {
            View view = new View(this.getContext());
            this.addView(view);
            return view;
        }
        return null;
    }

    public void removeView(View view) {
        if ((this = this.getContainerView()) == null) {
            return;
        }
        this.removeView(view);
    }

    public void setViewPosition(View view, float f2, float f3, float f4, float f5, int n2, int n3) {
        FrameLayout.LayoutParams layoutParams;
        if ((viewAndroidDelegate = viewAndroidDelegate.getContainerView()) == null) {
            return;
        }
        int n4 = Math.round(f4);
        int n5 = Math.round(f5);
        if (viewAndroidDelegate.getLayoutDirection() == 1) {
            n2 = viewAndroidDelegate.getMeasuredWidth() - Math.round(f4 + f2);
        }
        if (n4 + n2 > viewAndroidDelegate.getWidth()) {
            n4 = viewAndroidDelegate.getWidth() - n2;
        }
        ViewAndroidDelegate viewAndroidDelegate = layoutParams;
        viewAndroidDelegate(n4, n5);
        MarginLayoutParamsCompat.setMarginStart((ViewGroup.MarginLayoutParams)viewAndroidDelegate, (int)n2);
        layoutParams.topMargin = n3;
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public void onCursorChangedToCustom(Bitmap bitmap, int n2, int n3) {
        if (Build.VERSION.SDK_INT >= 24) {
            ViewAndroidDelegate viewAndroidDelegate = viewAndroidDelegate2;
            ViewAndroidDelegate viewAndroidDelegate2 = PointerIcon.create((Bitmap)bitmap, (float)n2, (float)n3);
            viewAndroidDelegate.getContainerView().setPointerIcon((PointerIcon)viewAndroidDelegate2);
        }
    }

    public void onCursorChanged(int n2) {
        block29: {
            int n3;
            if (Build.VERSION.SDK_INT < 24) {
                return;
            }
            int n4 = n2;
            n2 = 1000;
            switch (n4) {
                default: {
                    break block29;
                }
                case 43: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)"onCursorChangedToCustom must be called instead");
                    }
                    break block29;
                }
                case 42: {
                    n3 = 1021;
                    break;
                }
                case 41: {
                    n3 = 1020;
                    break;
                }
                case 40: {
                    n3 = 1019;
                    break;
                }
                case 39: {
                    n3 = 1018;
                    break;
                }
                case 37: {
                    n3 = 0;
                    break;
                }
                case 36: {
                    n3 = 1011;
                    break;
                }
                case 35: 
                case 38: {
                    n3 = 1012;
                    break;
                }
                case 33: {
                    n3 = 1010;
                    break;
                }
                case 32: {
                    n3 = 1001;
                    break;
                }
                case 31: {
                    n3 = 1006;
                    break;
                }
                case 30: {
                    n3 = 1009;
                    break;
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)"These pointer icon types are not supported");
                    }
                    break block29;
                }
                case 20: 
                case 29: {
                    n3 = 1013;
                    break;
                }
                case 9: 
                case 11: 
                case 17: {
                    n3 = 1017;
                    break;
                }
                case 8: 
                case 12: 
                case 16: {
                    n3 = 1016;
                    break;
                }
                case 7: 
                case 10: 
                case 14: 
                case 19: {
                    n3 = 1015;
                    break;
                }
                case 6: 
                case 13: 
                case 15: 
                case 18: {
                    n3 = 1014;
                    break;
                }
                case 5: {
                    n3 = 1003;
                    break;
                }
                case 4: 
                case 34: {
                    n3 = 1004;
                    break;
                }
                case 3: {
                    n3 = 1008;
                    break;
                }
                case 2: {
                    n3 = 1002;
                    break;
                }
                case 1: {
                    n3 = 1007;
                    break;
                }
                case 0: {
                    n3 = 1000;
                }
            }
            n2 = n3;
        }
        ViewGroup viewGroup = this.getContainerView();
        viewGroup.setPointerIcon(PointerIcon.getSystemIcon((Context)viewGroup.getContext(), (int)n2));
    }

    public void onBackgroundColorChanged(int n2) {
    }

    public void onTopControlsChanged(int n2, int n3) {
    }

    public void onBottomControlsChanged(int n2, int n3) {
    }

    public int getSystemWindowInsetBottom() {
        return 0;
    }

    public final ViewGroup getContainerView() {
        return this.mContainerView;
    }

    public static interface ContainerViewObserver {
        public void onUpdateContainerView(ViewGroup var1);
    }
}

