/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="net::android")
public class AndroidCertVerifyResult {
    public final int mStatus;
    public final boolean mIsIssuedByKnownRoot;
    public final List<X509Certificate> mCertificateChain;

    public AndroidCertVerifyResult(int n2, boolean bl, List<X509Certificate> list) {
        AndroidCertVerifyResult androidCertVerifyResult = this;
        this.mStatus = n2;
        androidCertVerifyResult.mIsIssuedByKnownRoot = bl;
        androidCertVerifyResult.mCertificateChain = new ArrayList<X509Certificate>(list);
    }

    public AndroidCertVerifyResult(int n2) {
        AndroidCertVerifyResult androidCertVerifyResult = this;
        androidCertVerifyResult.mStatus = n2;
        androidCertVerifyResult.mIsIssuedByKnownRoot = false;
        androidCertVerifyResult.mCertificateChain = Collections.emptyList();
    }

    public int getStatus() {
        return this.mStatus;
    }

    public boolean isIssuedByKnownRoot() {
        return this.mIsIssuedByKnownRoot;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[][] getCertificateChainEncoded() {
        byte[][] byArrayArray = new byte[this.mCertificateChain.size()][];
        int n2 = 0;
        try {
            while (true) {
                if (n2 >= this.mCertificateChain.size()) {
                    return byArrayArray;
                }
                byArrayArray[n2] = this.mCertificateChain.get(n2).getEncoded();
                ++n2;
            }
        }
        catch (CertificateEncodingException certificateEncodingException) {
            return new byte[0][];
        }
    }
}

