/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.media;

import a.a.a.a.a;
import a.b.a.j;
import android.annotation.TargetApi;
import android.graphics.ImageFormat;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.opengl.GLES20;
import android.os.Build;
import android.util.SparseArray;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.media.PhotoCapabilities;
import org.chromium.media.VideoCapture;
import org.chromium.media.VideoCaptureFormat;

@JNINamespace(value="media")
@TargetApi(value=15)
public class VideoCaptureCamera
extends VideoCapture
implements Camera.PreviewCallback {
    public static final String TAG = "VideoCapture";
    public static final int GL_TEXTURE_EXTERNAL_OES = 36197;
    public static final int NUM_CAPTURE_BUFFERS = 3;
    public static final SparseArray<String> COLOR_TEMPERATURES_MAP;
    public static final /* synthetic */ boolean $assertionsDisabled;
    public int mExpectedFrameSize;
    public final Object mPhotoTakenCallbackLock = new Object();
    public long mPhotoTakenCallbackId;
    public int mPhotoWidth;
    public int mPhotoHeight;
    public Camera.Area mAreaOfInterest;
    public Camera.Parameters mPreviewParameters;
    public Camera mCamera;
    public ReentrantLock mPreviewBufferLock = new ReentrantLock();
    public boolean mIsRunning;
    public int[] mGlTextures;
    public SurfaceTexture mSurfaceTexture;

    public static Camera.CameraInfo getCameraInfo(int n2) {
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        try {
            Camera.getCameraInfo((int)n2, (Camera.CameraInfo)cameraInfo);
            return cameraInfo;
        }
        catch (RuntimeException runtimeException) {
            Object[] objectArray = new Object[]{};
            j.b(TAG, "getCameraInfo: Camera.getCameraInfo: " + runtimeException, objectArray);
            return null;
        }
    }

    public static Camera.Parameters getCameraParameters(Camera camera) {
        try {
            return camera.getParameters();
        }
        catch (RuntimeException runtimeException) {
            Object[] objectArray = new Object[]{};
            j.b(TAG, "getCameraParameters: android.hardware.Camera.getParameters: " + runtimeException, objectArray);
            if (camera != null) {
                camera.release();
            }
            return null;
        }
    }

    private String getClosestWhiteBalance(int n2, List<String> list) {
        int n3 = Integer.MAX_VALUE;
        String string2 = null;
        for (int i2 = 0; i2 < COLOR_TEMPERATURES_MAP.size(); ++i2) {
            int n4;
            if (!list.contains(COLOR_TEMPERATURES_MAP.valueAt(i2)) || (n4 = Math.abs(n2 - COLOR_TEMPERATURES_MAP.keyAt(i2))) >= n3) {
                n4 = n3;
            } else {
                string2 = (String)COLOR_TEMPERATURES_MAP.valueAt(i2);
            }
            n3 = n4;
        }
        return string2;
    }

    public static int getNumberOfCameras() {
        return Camera.getNumberOfCameras();
    }

    public static int getCaptureApiType(int n2) {
        if (VideoCaptureCamera.getCameraInfo(n2) == null) {
            return 11;
        }
        return 6;
    }

    public static int getFacingMode(int n2) {
        Camera.CameraInfo cameraInfo = VideoCaptureCamera.getCameraInfo(n2);
        if (cameraInfo == null) {
            return 0;
        }
        int n3 = cameraInfo.facing;
        if (n3 != 0) {
            if (n3 != 1) {
                return 0;
            }
            return 1;
        }
        return 2;
    }

    public static String getName(int n2) {
        Object object = VideoCaptureCamera.getCameraInfo(n2);
        if (object == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder().append("camera ").append(n2).append(", facing ");
        object = object.facing == 1 ? "front" : "back";
        return stringBuilder.append((String)object).toString();
    }

    /*
     * Loose catch block
     */
    public static VideoCaptureFormat[] getDeviceSupportedFormats(int n2) {
        Iterator iterator;
        ArrayList<VideoCaptureFormat> arrayList;
        Camera.Parameters parameters;
        Camera camera;
        block17: {
            camera = Camera.open((int)n2);
            parameters = VideoCaptureCamera.getCameraParameters(camera);
            if (parameters != null) break block17;
            return null;
        }
        ArrayList<VideoCaptureFormat> arrayList2 = arrayList;
        arrayList = new ArrayList<VideoCaptureFormat>();
        Iterator iterator2 = null;
        try {
            iterator = parameters.getSupportedPreviewFormats();
        }
        catch (NullPointerException nullPointerException) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = nullPointerException;
            j.b(TAG, "Camera.Parameters.getSupportedPreviewFormats: ", objectArray2);
            iterator = iterator2;
        }
        if (iterator == null) {
            ArrayList arrayList3;
            iterator = arrayList3;
            arrayList3 = new ArrayList();
        }
        if (iterator.size() == 0) {
            iterator.add(0);
        }
        iterator2 = iterator.iterator();
        while (iterator2.hasNext()) {
            Object object;
            Object object2;
            iterator = (Integer)iterator2.next();
            int n3 = 0;
            if ((Integer)((Object)iterator) == 842094169) {
                n3 = 842094169;
            } else if ((Integer)((Object)iterator) == 17) continue;
            iterator = null;
            try {
                object2 = parameters.getSupportedPreviewFpsRange();
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                Object[] objectArray = new Object[1];
                object = objectArray;
                objectArray[0] = stringIndexOutOfBoundsException;
                j.b(TAG, "Camera.Parameters.getSupportedPreviewFpsRange: ", (Object[])object);
                object2 = iterator;
            }
            if (object2 == null) {
                ArrayList arrayList4;
                object2 = arrayList4;
                arrayList4 = new ArrayList();
            }
            if (object2.size() == 0) {
                object2.add(new int[]{0, 0});
            }
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object2 = (int[])iterator.next();
                object = parameters.getSupportedPreviewSizes();
                if (object == null) {
                    ArrayList arrayList5;
                    object = arrayList5;
                    arrayList5 = new ArrayList();
                }
                if (object.size() == 0) {
                    Camera camera2 = camera;
                    camera2.getClass();
                    object.add(new Camera.Size(camera2, 0, 0));
                }
                object = object.iterator();
                while (object.hasNext()) {
                    Camera.Size size = (Camera.Size)object.next();
                    arrayList2.add(new VideoCaptureFormat(size.width, size.height, (int)((object2[1] + 999) / 1000), n3));
                }
            }
        }
        ArrayList<VideoCaptureFormat> arrayList6 = arrayList2;
        camera.release();
        return arrayList6.toArray(new VideoCaptureFormat[arrayList6.size()]);
        catch (RuntimeException runtimeException) {
            Object[] objectArray = new Object[1];
            Object[] objectArray3 = objectArray;
            objectArray[0] = runtimeException;
            j.b(TAG, "Camera.open: ", objectArray3);
            return null;
        }
    }

    public VideoCaptureCamera(int n2, long l2) {
        super(n2, l2);
    }

    private void setPreviewCallback(Camera.PreviewCallback previewCallback) {
        this.mCamera.setPreviewCallbackWithBuffer(previewCallback);
    }

    public static /* synthetic */ long access$102(VideoCaptureCamera videoCaptureCamera, long l2) {
        videoCaptureCamera.mPhotoTakenCallbackId = l2;
        return l2;
    }

    static {
        $assertionsDisabled = VideoCaptureCamera.class.desiredAssertionStatus() ^ true;
        COLOR_TEMPERATURES_MAP = new SparseArray();
        COLOR_TEMPERATURES_MAP.append(2850, (Object)"incandescent");
        COLOR_TEMPERATURES_MAP.append(2950, (Object)"warm-fluorescent");
        COLOR_TEMPERATURES_MAP.append(4250, (Object)"fluorescent");
        COLOR_TEMPERATURES_MAP.append(4600, (Object)"twilight");
        COLOR_TEMPERATURES_MAP.append(5500, (Object)"daylight");
        COLOR_TEMPERATURES_MAP.append(6000, (Object)"cloudy-daylight");
        COLOR_TEMPERATURES_MAP.append(7000, (Object)"shade");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean allocate(int n2, int n3, int n4, boolean bl) {
        Object[] objectArray;
        Integer n5 = n2;
        Object object = n3;
        Object object2 = n4;
        j.a(TAG, "allocate: requested (%d x %d) @%dfps", (Object)n5, object, object2);
        try {
            objectArray.mCamera = Camera.open((int)objectArray.mId);
        }
        catch (RuntimeException runtimeException) {
            Object[] objectArray2 = new Object[]{};
            j.b(TAG, "allocate: Camera.open: " + runtimeException, objectArray2);
            return false;
        }
        n5 = VideoCaptureCamera.getCameraInfo(objectArray.mId);
        if (n5 == null) {
            objectArray.mCamera.release();
            objectArray.mCamera = null;
            return false;
        }
        objectArray.mCameraNativeOrientation = ((Camera.CameraInfo)n5).orientation;
        boolean bl2 = ((Camera.CameraInfo)n5).facing == 0;
        objectArray.mInvertDeviceOrientationReadings = bl2;
        Integer n6 = objectArray.getDeviceRotation();
        object = objectArray.mCameraNativeOrientation;
        object2 = objectArray.mInvertDeviceOrientationReadings;
        j.a(TAG, "allocate: Rotation dev=%d, cam=%d, facing back? %s", (Object)n6, object, object2);
        n6 = VideoCaptureCamera.getCameraParameters(objectArray.mCamera);
        if (n6 == null) {
            objectArray.mCamera = null;
            return false;
        }
        object = n6.getSupportedPreviewFpsRange();
        if (object != null && object.size() != 0) {
            ArrayList arrayList;
            object2 = arrayList;
            arrayList = new ArrayList(object.size());
            object = object.iterator();
            while (object.hasNext()) {
                int[] nArray = (int[])object.next();
                ((ArrayList)object2).add(new VideoCapture.FramerateRange(nArray[0], nArray[1]));
            }
            Object object3 = VideoCapture.getClosestFramerateRange((List<VideoCapture.FramerateRange>)object2, n4 * 1000);
            int[] nArray = new int[2];
            object = nArray;
            object[0] = ((VideoCapture.FramerateRange)object3).min;
            nArray[1] = ((VideoCapture.FramerateRange)object3).max;
            object3 = nArray[0];
            object2 = nArray[1];
            j.a(TAG, "allocate: fps set to [%d-%d]", object3, object2);
            int n7 = Integer.MAX_VALUE;
            object2 = n6.getSupportedPreviewSizes().iterator();
            int n8 = n2;
            int n9 = n3;
            while (object2.hasNext()) {
                int n10;
                Camera.Size size = (Camera.Size)object2.next();
                int n11 = Math.abs(size.width - n2);
                n11 = Math.abs(size.height - n3) + n11;
                Camera.Size size2 = size;
                Integer n12 = size2.width;
                Integer n13 = size2.height;
                Integer n14 = n11;
                j.a(TAG, "allocate: supported (%d, %d), diff=%d", (Object)n12, (Object)n13, (Object)n14);
                if (n11 < n7 && (n10 = size.width) % 32 == 0) {
                    n9 = size.height;
                } else {
                    n10 = n8;
                    n11 = n7;
                }
                n8 = n10;
                n7 = n11;
            }
            if (n7 == Integer.MAX_VALUE) {
                objectArray = new Object[]{};
                j.b(TAG, "allocate: can not find a multiple-of-32 resolution", objectArray);
                return false;
            }
            Object object4 = n8;
            Object object5 = n9;
            j.a(TAG, "allocate: matched (%d x %d)", object4, object5);
            if (n6.isVideoStabilizationSupported()) {
                j.a(TAG, a.a("Image stabilization supported, currently: ").append(n6.getVideoStabilization()).append(", setting it.").toString());
                n6.setVideoStabilization(true);
            } else {
                j.a(TAG, "Image stabilization not supported.");
            }
            if (n6.getSupportedFocusModes().contains("continuous-video")) {
                n6.setFocusMode("continuous-video");
            } else {
                j.a(TAG, "Continuous focus mode not supported.");
            }
            objectArray.mCaptureFormat = new VideoCaptureFormat(n8, n9, (int)(object[1] / 1000), BuggyDeviceHack.getImageFormat());
            n6.setPictureSize(n8, n9);
            n6.setPreviewSize(n8, n9);
            n6.setPreviewFpsRange((int)object[0], (int)object[1]);
            n6.setPreviewFormat(objectArray.mCaptureFormat.mPixelFormat);
            try {
                objectArray.mCamera.setParameters((Camera.Parameters)n6);
            }
            catch (RuntimeException runtimeException) {
                Object[] objectArray4 = new Object[]{};
                j.b(TAG, "setParameters: " + runtimeException, objectArray4);
                return false;
            }
            objectArray.mGlTextures = new int[1];
            GLES20.glGenTextures((int)1, (int[])objectArray.mGlTextures, (int)0);
            GLES20.glBindTexture((int)36197, (int)objectArray.mGlTextures[0]);
            GLES20.glTexParameterf((int)36197, (int)10241, (float)9729.0f);
            GLES20.glTexParameterf((int)36197, (int)10240, (float)9729.0f);
            GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
            GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
            objectArray.mSurfaceTexture = new SurfaceTexture(objectArray.mGlTextures[0]);
            objectArray.mSurfaceTexture.setOnFrameAvailableListener(null);
            try {
                objectArray.mCamera.setPreviewTexture(objectArray.mSurfaceTexture);
            }
            catch (IOException iOException) {
                Object[] objectArray3 = new Object[]{};
                j.b(TAG, "allocate: " + iOException, objectArray3);
                return false;
            }
            objectArray.mCamera.setErrorCallback((Camera.ErrorCallback)(VideoCaptureCamera)objectArray.new CrErrorCallback(null));
            object4 = objectArray.mCaptureFormat;
            int n15 = ((VideoCaptureFormat)object4).mWidth * ((VideoCaptureFormat)object4).mHeight;
            objectArray.mExpectedFrameSize = ImageFormat.getBitsPerPixel((int)((VideoCaptureFormat)object4).mPixelFormat) * n15 / 8;
            n15 = 0;
            while (true) {
                if (n15 >= 3) {
                    return true;
                }
                object5 = new byte[objectArray.mExpectedFrameSize];
                objectArray.mCamera.addCallbackBuffer((byte[])object5);
                ++n15;
            }
        }
        objectArray = new Object[]{};
        j.b(TAG, "allocate: no fps range found", objectArray);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean startCaptureMaybeAsync() {
        Object[] objectArray;
        Object[] objectArray2;
        if (objectArray2.mCamera == null) {
            objectArray2 = new Object[]{};
            j.b(TAG, "startCaptureAsync: mCamera is null", objectArray2);
            return false;
        }
        objectArray2.mPreviewBufferLock.lock();
        try {
            if (objectArray2.mIsRunning) {
                objectArray2.mPreviewBufferLock.unlock();
                return true;
            }
            objectArray = objectArray2;
            objectArray2.mPreviewBufferLock.unlock();
        }
        catch (Throwable throwable) {
            objectArray2.mPreviewBufferLock.unlock();
            throw throwable;
        }
        objectArray.mCamera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)objectArray2);
        try {
            objectArray2.mCamera.startPreview();
        }
        catch (RuntimeException runtimeException) {
            Object[] objectArray22 = new Object[]{};
            j.b(TAG, "startCaptureAsync: Camera.startPreview: " + runtimeException, objectArray22);
            return false;
        }
        objectArray.mPreviewBufferLock.lock();
        try {
            objectArray.nativeOnStarted(objectArray2.mNativeVideoCaptureDeviceAndroid);
            objectArray2.mIsRunning = true;
            objectArray.mPreviewBufferLock.unlock();
            return true;
        }
        catch (Throwable throwable) {
            objectArray2.mPreviewBufferLock.unlock();
            throw throwable;
        }
    }

    @Override
    public boolean stopCaptureAndBlockUntilStopped() {
        Object[] objectArray;
        Object[] objectArray2;
        if (objectArray2.mCamera == null) {
            objectArray2 = new Object[]{};
            j.b(TAG, "stopCaptureAndBlockUntilStopped: mCamera is null", objectArray2);
            return true;
        }
        objectArray2.mPreviewBufferLock.lock();
        try {
            if (!objectArray2.mIsRunning) {
                objectArray2.mPreviewBufferLock.unlock();
                return true;
            }
            objectArray = objectArray2;
        }
        catch (Throwable throwable) {
            objectArray2.mPreviewBufferLock.unlock();
            throw throwable;
        }
        objectArray2.mIsRunning = false;
        objectArray.mPreviewBufferLock.unlock();
        objectArray2.mCamera.stopPreview();
        objectArray2 = null;
        objectArray.mCamera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)objectArray2);
        return true;
    }

    @Override
    public void getPhotoCapabilitiesAsync(long l2) {
        List list;
        ArrayList<Integer> arrayList;
        ArrayList<Integer> arrayList2;
        ArrayList<Integer> arrayList3;
        PhotoCapabilities.Builder builder;
        Object object = VideoCaptureCamera.getCameraParameters(this.mCamera);
        if (object == null) {
            VideoCaptureCamera videoCaptureCamera = this;
            videoCaptureCamera.nativeOnGetPhotoCapabilitiesReply(videoCaptureCamera.mNativeVideoCaptureDeviceAndroid, l2, null);
            return;
        }
        PhotoCapabilities.Builder builder2 = builder;
        builder = new PhotoCapabilities.Builder();
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = object.flatten();
        j.c(TAG, " CAM params: %s", objectArray2);
        builder.setInt(0, 0).setInt(1, 0).setInt(2, 0).setInt(3, 0);
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = 0;
        int n5 = 0;
        for (Camera.Size size : object.getSupportedPictureSizes()) {
            int n6 = size.width;
            if (n6 >= n2) {
                n6 = n2;
            }
            n2 = size.height;
            if (n2 >= n3) {
                n2 = n3;
            }
            n3 = size.width;
            if (n3 <= n4) {
                n3 = n4;
            }
            n4 = size.height;
            if (n4 <= n5) {
                n4 = n5;
            }
            int n7 = n2;
            int n8 = n4;
            n4 = n3;
            n2 = n6;
            n5 = n8;
            n3 = n7;
        }
        Camera.Size size = object.getPreviewSize();
        builder2.setInt(4, n3).setInt(5, n5).setInt(7, 1).setInt(6, size.height).setInt(8, n2).setInt(9, n4).setInt(11, 1).setInt(10, size.width);
        n2 = 0;
        n3 = 0;
        n4 = 0;
        n5 = 0;
        if (object.isZoomSupported()) {
            Camera.Parameters parameters = object;
            n2 = (Integer)parameters.getZoomRatios().get(object.getMaxZoom());
            n3 = (Integer)parameters.getZoomRatios().get(object.getZoom());
            n4 = (Integer)parameters.getZoomRatios().get(0);
            if (parameters.getZoomRatios().size() > 1) {
                n5 = (Integer)object.getZoomRatios().get(1) - (Integer)object.getZoomRatios().get(0);
            }
        }
        double d2 = n4;
        PhotoCapabilities.Builder builder3 = builder2.setDouble(0, d2);
        d2 = n2;
        double d3 = n3;
        PhotoCapabilities.Builder builder4 = builder3.setDouble(1, d2).setDouble(2, d3);
        d3 = n5;
        builder4.setDouble(3, d3);
        Object object2 = object.getSupportedFocusModes();
        if (!$assertionsDisabled && object2 == null) {
            throw new AssertionError((Object)"getSupportedFocusModes() should never return null");
        }
        ArrayList<Integer> arrayList4 = arrayList3;
        arrayList3 = new ArrayList<Integer>(3);
        if (object2.contains("continuous-video") || object2.contains("continuous-picture") || object2.contains("edof")) {
            arrayList4.add(4);
        }
        if (object2.contains("auto") || object2.contains("macro")) {
            arrayList4.add(3);
        }
        if (object2.contains("infinity") || object2.contains("fixed")) {
            arrayList4.add(2);
        }
        builder2.setMeteringModeArray(0, VideoCapture.integerArrayListToArray(arrayList4));
        object2 = object.getFocusMode();
        int n9 = 1;
        if (!(((String)object2).equals("continuous-video") || ((String)object2).equals("continuous-picture") || ((String)object2).equals("edof"))) {
            if (!((String)object2).equals("auto") && !((String)object2).equals("macro")) {
                if (((String)object2).equals("infinity") || ((String)object2).equals("fixed")) {
                    n9 = 2;
                }
            } else {
                n9 = 3;
            }
        } else {
            n9 = 4;
        }
        builder2.setMeteringMode(0, n9);
        object2 = arrayList2;
        new ArrayList<Integer>(2).add(4);
        if (object.isAutoExposureLockSupported()) {
            ((ArrayList)object2).add(2);
        }
        builder2.setMeteringModeArray(1, VideoCapture.integerArrayListToArray((ArrayList<Integer>)object2));
        int n10 = 4;
        if (object.isAutoExposureLockSupported() && object.getAutoExposureLock()) {
            n10 = 2;
        }
        builder2.setMeteringMode(1, n10);
        float f2 = object.getExposureCompensationStep();
        double d4 = f2;
        PhotoCapabilities.Builder builder5 = builder2.setDouble(11, d4);
        d4 = (float)object.getMinExposureCompensation() * f2;
        PhotoCapabilities.Builder builder6 = builder5.setDouble(8, d4);
        d4 = (float)object.getMaxExposureCompensation() * f2;
        double d5 = (float)object.getExposureCompensation() * f2;
        builder6.setDouble(9, d4).setDouble(10, d5);
        ArrayList<Integer> arrayList5 = arrayList;
        arrayList = new ArrayList<Integer>(2);
        List list2 = object.getSupportedWhiteBalance();
        if (list2 != null) {
            if (!list2.isEmpty()) {
                arrayList5.add(4);
            }
            if (object.isAutoWhiteBalanceLockSupported()) {
                arrayList5.add(2);
            }
        }
        builder2.setMeteringModeArray(2, VideoCapture.integerArrayListToArray(arrayList5));
        int n11 = 4;
        if (object.isAutoWhiteBalanceLockSupported() && object.getAutoWhiteBalanceLock()) {
            n11 = 2;
        }
        PhotoCapabilities.Builder builder7 = builder2;
        builder7.setMeteringMode(2, n11);
        SparseArray<String> sparseArray = COLOR_TEMPERATURES_MAP;
        builder7.setInt(12, COLOR_TEMPERATURES_MAP.keyAt(0)).setInt(13, sparseArray.keyAt(sparseArray.size() - 1)).setInt(15, 50);
        if (n11 == 2 && (n11 = COLOR_TEMPERATURES_MAP.indexOfValue((Object)object.getWhiteBalance())) >= 0) {
            builder2.setInt(14, COLOR_TEMPERATURES_MAP.keyAt(n11));
        }
        if ((list = object.getSupportedFlashModes()) != null) {
            ArrayList arrayList6;
            builder2.setBool(0, list.contains("torch")).setBool(1, "torch".equals(object.getFlashMode())).setBool(2, list.contains("red-eye"));
            object = arrayList6;
            arrayList6 = new ArrayList(0);
            if (list.contains("off")) {
                ((ArrayList)object).add(1);
            }
            if (list.contains("auto")) {
                ((ArrayList)object).add(2);
            }
            if (list.contains("on")) {
                ((ArrayList)object).add(3);
            }
            builder2.setFillLightModeArray(VideoCapture.integerArrayListToArray((ArrayList<Integer>)object));
        }
        VideoCaptureCamera videoCaptureCamera = this;
        videoCaptureCamera.nativeOnGetPhotoCapabilitiesReply(videoCaptureCamera.mNativeVideoCaptureDeviceAndroid, l2, builder2.build());
    }

    @Override
    public void setPhotoOptions(double d2, int n2, double d3, int n3, double d4, double d5, double[] dArray, boolean bl, double d6, double d7, int n4, double d8, boolean bl2, boolean bl3, int n5, boolean bl4, boolean bl5, double d9) {
        block38: {
            Object object;
            List list;
            Camera.Parameters parameters = VideoCaptureCamera.getCameraParameters(this.mCamera);
            if (parameters == null) {
                return;
            }
            if (parameters.isZoomSupported() && d2 > 0.0) {
                int n6;
                list = parameters.getZoomRatios();
                for (n6 = 1; n6 < list.size() && !(d2 < (double)((Integer)list.get(n6)).intValue()); ++n6) {
                }
                parameters.setZoom(n6 - 1);
            }
            if (n2 == 2) {
                parameters.setFocusMode("fixed");
            } else if (n2 == 3) {
                parameters.setFocusMode("auto");
            } else if (n2 == 4) {
                parameters.setFocusMode("continuous-picture");
            }
            if (parameters.isAutoExposureLockSupported()) {
                if (n3 == 2) {
                    parameters.setAutoExposureLock(true);
                } else if (n3 != 1) {
                    parameters.setAutoExposureLock(false);
                }
            }
            if (d4 > 0.0) {
                this.mPhotoWidth = (int)Math.round(d4);
            }
            if (d5 > 0.0) {
                this.mPhotoHeight = (int)Math.round(d5);
            }
            if ((list = this.mAreaOfInterest) != null && !((Camera.Area)list).rect.isEmpty() && d2 > 0.0) {
                this.mAreaOfInterest = null;
            }
            if (n2 == 1 || n3 == 1) {
                this.mAreaOfInterest = null;
            }
            boolean bl6 = parameters.getMaxNumMeteringAreas() > 0 || parameters.getMaxNumFocusAreas() > 0;
            if (bl6 && dArray.length > 0) {
                if (!$assertionsDisabled && dArray.length != 2) {
                    throw new AssertionError((Object)"Only 1 point of interest supported");
                }
                if (!($assertionsDisabled || dArray[0] <= 1.0 && dArray[0] >= 0.0)) {
                    throw new AssertionError();
                }
                if (!($assertionsDisabled || dArray[1] <= 1.0 && dArray[1] >= 0.0)) {
                    throw new AssertionError();
                }
                int n7 = (int)(Math.round(dArray[0] * 2000.0) - 1000L);
                int n8 = (int)(Math.round(dArray[1] * 2000.0) - 1000L);
                this.mAreaOfInterest = new Camera.Area(new Rect(Math.max(-1000, n7 - 125), Math.max(-1000, n8 - 125), Math.min(1000, n7 + 125), Math.min(1000, n8 + 125)), 1000);
                String string2 = this.mAreaOfInterest.rect.toString();
                j.a(TAG, "Area of interest %s", (Object)string2);
            }
            if ((object = this.mAreaOfInterest) != null) {
                Camera.Parameters parameters2 = parameters;
                parameters2.setFocusAreas(Arrays.asList(object));
                parameters2.setMeteringAreas(Arrays.asList(this.mAreaOfInterest));
            }
            if (bl) {
                parameters.setExposureCompensation((int)Math.round(d6 / (double)parameters.getExposureCompensationStep()));
            }
            if (n4 == 4 && parameters.getSupportedWhiteBalance() != null) {
                parameters.setWhiteBalance("auto");
            } else if (n4 == 2 && parameters.isAutoWhiteBalanceLockSupported()) {
                parameters.setAutoWhiteBalanceLock(true);
            }
            if (d9 > 0.0) {
                object = this.getClosestWhiteBalance((int)d9, parameters.getSupportedWhiteBalance());
                Double d10 = d9;
                j.a(TAG, " Color temperature (%f ==> %s)", (Object)d10, object);
                if (object != null) {
                    parameters.setWhiteBalance((String)object);
                }
            }
            if (parameters.getSupportedFlashModes() != null) {
                if (bl4 && bl5) {
                    parameters.setFlashMode("torch");
                } else if (n5 != 0) {
                    if (n5 != 1) {
                        if (n5 != 2) {
                            if (n5 == 3) {
                                parameters.setFlashMode("on");
                            }
                        } else {
                            object = bl2 && bl3 ? "red-eye" : "auto";
                            parameters.setFlashMode((String)object);
                        }
                    } else {
                        parameters.setFlashMode("off");
                    }
                }
            }
            try {
                this.mCamera.setParameters(parameters);
                if (n2 == 3) break block38;
                return;
            }
            catch (RuntimeException runtimeException) {
                Object[] objectArray = new Object[1];
                object = objectArray;
                objectArray[0] = runtimeException;
                j.b(TAG, "setParameters: ", object);
                return;
            }
        }
        this.mCamera.autoFocus(new Camera.AutoFocusCallback(){

            public void onAutoFocus(boolean bl, Camera object) {
                String string2 = VideoCaptureCamera.TAG;
                String string3 = "onAutoFocus() finished: %s ";
                object = bl ? "success" : "failed";
                j.a(string2, string3, object);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void takePhotoAsync(long l2) {
        Object[] objectArray;
        if (objectArray.mCamera != null && objectArray.mIsRunning) {
            CrPictureCallback crPictureCallback;
            Object object = objectArray.mPhotoTakenCallbackLock;
            synchronized (object) {
                if (objectArray.mPhotoTakenCallbackId != 0L) {
                    objectArray.notifyTakePhotoError(l2);
                    return;
                }
                objectArray.mPhotoTakenCallbackId = l2;
                // MONITOREXIT @DISABLED, blocks:[0, 2, 12] lbl10 : MonitorExitStatement: MONITOREXIT : var3_3
                objectArray.mPreviewParameters = VideoCaptureCamera.getCameraParameters(objectArray.mCamera);
                if (objectArray.mPreviewParameters == null) {
                    objectArray.notifyTakePhotoError(l2);
                    return;
                }
            }
            object = VideoCaptureCamera.getCameraParameters(objectArray.mCamera);
            if (object == null) {
                objectArray.notifyTakePhotoError(l2);
                return;
            }
            object.setRotation(objectArray.getCameraRotation());
            if (objectArray.mPhotoWidth > 0 || objectArray.mPhotoHeight > 0) {
                void var4_6;
                Object var4_5 = null;
                int n2 = Integer.MAX_VALUE;
                for (Camera.Size size : object.getSupportedPictureSizes()) {
                    void var7_11;
                    int n3 = objectArray.mPhotoWidth;
                    n3 = n3 > 0 ? Math.abs(size.width - n3) : 0;
                    int n4 = objectArray.mPhotoHeight;
                    if ((n3 += (n4 = n4 > 0 ? Math.abs(size.height - n4) : 0)) >= n2) {
                        void var7_13 = var4_6;
                        n3 = n2;
                    }
                    void var4_7 = var7_11;
                    n2 = n3;
                }
                if (n2 != Integer.MAX_VALUE) {
                    void v1 = var4_6;
                    Integer n5 = objectArray.mPhotoWidth;
                    Integer n6 = objectArray.mPhotoHeight;
                    Integer n7 = v1.width;
                    Integer n8 = v1.height;
                    j.a(TAG, "requested resolution: (%dx%d); matched (%dx%d)", (Object)n5, (Object)n6, (Object)n7, (Object)n8);
                    object.setPictureSize(v1.width, var4_6.height);
                }
            }
            try {
                j.a(TAG, "|photoParameters|: %s", (Object)object.flatten());
                objectArray.mCamera.setParameters((Camera.Parameters)object);
            }
            catch (RuntimeException runtimeException) {
                Object[] objectArray2 = objectArray;
                objectArray = new Object[]{};
                j.b(TAG, "setParameters " + runtimeException, objectArray);
                objectArray2.notifyTakePhotoError(l2);
                return;
            }
            CrPictureCallback crPictureCallback2 = crPictureCallback;
            crPictureCallback = (VideoCaptureCamera)objectArray.new CrPictureCallback(null);
            objectArray.mCamera.takePicture(null, null, null, (Camera.PictureCallback)crPictureCallback2);
            return;
        }
        Object[] objectArray3 = objectArray;
        objectArray = new Object[]{};
        j.b(TAG, "takePhotoAsync: mCamera is null or is not running", objectArray);
        objectArray3.notifyTakePhotoError(l2);
    }

    @Override
    public void deallocate() {
        block8: {
            Camera camera;
            if (this.mCamera == null) {
                return;
            }
            VideoCaptureCamera videoCaptureCamera = this;
            videoCaptureCamera.stopCaptureAndBlockUntilStopped();
            try {
                camera = videoCaptureCamera.mCamera;
            }
            catch (IOException iOException) {
                Object[] objectArray = new Object[]{};
                j.b(TAG, "deallocate: failed to deallocate camera, " + iOException, objectArray);
                return;
            }
            camera.setPreviewTexture(null);
            if (videoCaptureCamera.mGlTextures == null) break block8;
            int[] nArray = this.mGlTextures;
            GLES20.glDeleteTextures((int)1, (int[])nArray, (int)0);
        }
        this.mCaptureFormat = null;
        this.mCamera.release();
        this.mCamera = null;
    }

    public void onPreviewFrame(byte[] byArray, Camera camera) {
        VideoCaptureCamera videoCaptureCamera = this;
        videoCaptureCamera.mPreviewBufferLock.lock();
        try {
            if (!videoCaptureCamera.mIsRunning) {
                return;
            }
            if (byArray.length == this.mExpectedFrameSize) {
                VideoCaptureCamera videoCaptureCamera2 = this;
                videoCaptureCamera2.nativeOnFrameAvailable(videoCaptureCamera2.mNativeVideoCaptureDeviceAndroid, byArray, this.mExpectedFrameSize, this.getCameraRotation());
            } else {
                VideoCaptureCamera videoCaptureCamera3 = this;
                videoCaptureCamera3.nativeOnFrameDropped(videoCaptureCamera3.mNativeVideoCaptureDeviceAndroid, 8);
            }
            return;
        }
        finally {
            this.mPreviewBufferLock.unlock();
            if (camera != null) {
                camera.addCallbackBuffer(byArray);
            }
        }
    }

    private class CrPictureCallback
    implements Camera.PictureCallback {
        public CrPictureCallback() {
        }

        public /* synthetic */ CrPictureCallback(1 var2_2) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onPictureTaken(byte[] byArray, Camera objectArray) {
            try {
                j.a(VideoCaptureCamera.TAG, "|mPreviewParameters|: %s", (Object)VideoCaptureCamera.this.mPreviewParameters.flatten());
                objectArray.setParameters(VideoCaptureCamera.this.mPreviewParameters);
            }
            catch (RuntimeException runtimeException) {
                Object[] objectArray2 = new Object[]{};
                j.b(VideoCaptureCamera.TAG, "onPictureTaken, setParameters() " + runtimeException, objectArray2);
            }
            try {
                objectArray.startPreview();
            }
            catch (RuntimeException runtimeException) {
                objectArray = new Object[]{};
                j.b(VideoCaptureCamera.TAG, "onPictureTaken, startPreview() " + runtimeException, objectArray);
            }
            CrPictureCallback crPictureCallback = this;
            objectArray = crPictureCallback.VideoCaptureCamera.this.mPhotoTakenCallbackLock;
            synchronized (objectArray) {
                if (crPictureCallback.VideoCaptureCamera.this.mPhotoTakenCallbackId != 0L) {
                    VideoCaptureCamera.this.nativeOnPhotoTaken(VideoCaptureCamera.this.mNativeVideoCaptureDeviceAndroid, VideoCaptureCamera.this.mPhotoTakenCallbackId, byArray);
                }
                VideoCaptureCamera.access$102(VideoCaptureCamera.this, 0L);
                return;
            }
        }
    }

    private class CrErrorCallback
    implements Camera.ErrorCallback {
        public CrErrorCallback() {
        }

        public /* synthetic */ CrErrorCallback(1 var2_2) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onError(int n2, Camera camera) {
            CrErrorCallback crErrorCallback = this;
            VideoCaptureCamera videoCaptureCamera = crErrorCallback.VideoCaptureCamera.this;
            videoCaptureCamera.nativeOnError(videoCaptureCamera.mNativeVideoCaptureDeviceAndroid, 68, "Error id: " + n2);
            Object object = crErrorCallback.VideoCaptureCamera.this.mPhotoTakenCallbackLock;
            synchronized (object) {
                if (crErrorCallback.VideoCaptureCamera.this.mPhotoTakenCallbackId == 0L) {
                    return;
                }
                CrErrorCallback crErrorCallback2 = this;
                crErrorCallback2.VideoCaptureCamera.this.notifyTakePhotoError(VideoCaptureCamera.this.mPhotoTakenCallbackId);
                VideoCaptureCamera.access$102(crErrorCallback2.VideoCaptureCamera.this, 0L);
                return;
            }
        }
    }

    private static class BuggyDeviceHack {
        public static final String[] COLORSPACE_BUGGY_DEVICE_LIST = new String[]{"SAMSUNG-SGH-I747", "ODROID-U2", "XT1092", "XT1095", "XT1096", "XT1097"};

        public static int getImageFormat() {
            String[] stringArray = COLORSPACE_BUGGY_DEVICE_LIST;
            int n2 = COLORSPACE_BUGGY_DEVICE_LIST.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!stringArray[i2].contentEquals(Build.MODEL)) continue;
                return 17;
            }
            return 842094169;
        }
    }
}

