/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.media;

import android.media.MediaPlayer;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.media.MediaPlayerBridge;

@JNINamespace(value="media")
public class MediaPlayerListener
implements MediaPlayer.OnPreparedListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnVideoSizeChangedListener,
MediaPlayer.OnErrorListener {
    public static final int MEDIA_ERROR_FORMAT = 0;
    public static final int MEDIA_ERROR_DECODE = 1;
    public static final int MEDIA_ERROR_NOT_VALID_FOR_PROGRESSIVE_PLAYBACK = 2;
    public static final int MEDIA_ERROR_INVALID_CODE = 3;
    public static final int MEDIA_ERROR_SERVER_DIED = 4;
    public static final int MEDIA_ERROR_MALFORMED = -1007;
    public static final int MEDIA_ERROR_TIMED_OUT = -110;
    public long mNativeMediaPlayerListener;

    public MediaPlayerListener(long l2) {
        this.mNativeMediaPlayerListener = l2;
    }

    public static MediaPlayerListener create(long l2, MediaPlayerBridge mediaPlayerBridge) {
        MediaPlayerListener mediaPlayerListener;
        MediaPlayerListener mediaPlayerListener2 = mediaPlayerListener;
        mediaPlayerListener = new MediaPlayerListener(l2);
        if (mediaPlayerBridge != null) {
            mediaPlayerBridge.setOnCompletionListener(mediaPlayerListener2);
            mediaPlayerBridge.setOnErrorListener(mediaPlayerListener2);
            mediaPlayerBridge.setOnPreparedListener(mediaPlayerListener2);
            mediaPlayerBridge.setOnVideoSizeChangedListener(mediaPlayerListener2);
        }
        return mediaPlayerListener2;
    }

    private native void nativeOnMediaError(long var1, int var3);

    private native void nativeOnVideoSizeChanged(long var1, int var3, int var4);

    private native void nativeOnMediaPrepared(long var1);

    private native void nativeOnPlaybackComplete(long var1);

    /*
     * Unable to fully structure code
     */
    public boolean onError(MediaPlayer var1_1, int var2_3, int var3_4) {
        if (var2_3 != 1) {
            if (var2_3 != 100) {
                if (var2_3 != 200) {
                    while (true) {
                        var1_2 = 3;
                        break;
                    }
                } else {
                    var1_2 = 2;
                }
            } else {
                var1_2 = 4;
            }
        } else if (var3_4 != -1007) {
            if (var3_4 == -110) ** continue;
            var1_2 = 0;
        } else {
            var1_2 = 1;
        }
        v0 = this;
        v0.nativeOnMediaError(v0.mNativeMediaPlayerListener, var1_2);
        return true;
    }

    public void onVideoSizeChanged(MediaPlayer mediaPlayer, int n2, int n3) {
        MediaPlayerListener mediaPlayerListener = this;
        mediaPlayerListener.nativeOnVideoSizeChanged(mediaPlayerListener.mNativeMediaPlayerListener, n2, n3);
    }

    public void onCompletion(MediaPlayer mediaPlayer) {
        MediaPlayerListener mediaPlayerListener = this;
        mediaPlayerListener.nativeOnPlaybackComplete(mediaPlayerListener.mNativeMediaPlayerListener);
    }

    public void onPrepared(MediaPlayer mediaPlayer) {
        MediaPlayerListener mediaPlayerListener = this;
        mediaPlayerListener.nativeOnMediaPrepared(mediaPlayerListener.mNativeMediaPlayerListener);
    }
}

