/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.media;

import a.b.a.j;
import android.media.MediaCodec;
import android.util.SparseArray;
import java.nio.ByteBuffer;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.media.MediaCodecBridge;

@JNINamespace(value="media")
public class MediaCodecEncoder
extends MediaCodecBridge {
    public static final String TAG = "cr_MediaCodecEncoder";
    public SparseArray<ByteBuffer> mOutputBuffers = new SparseArray();
    public ByteBuffer mConfigData;

    public MediaCodecEncoder(MediaCodec mediaCodec, int n2) {
        super(mediaCodec, n2, false);
    }

    private ByteBuffer getMediaCodecOutputBuffer(int n2) {
        if ((this = super.getOutputBuffer(n2)) != null) {
            return this;
        }
        throw new IllegalStateException("Got null output buffer");
    }

    @Override
    public ByteBuffer getOutputBuffer(int n2) {
        return (ByteBuffer)this.mOutputBuffers.get(n2);
    }

    @Override
    public void releaseOutputBuffer(int n2, boolean bl) {
        try {
            MediaCodecEncoder mediaCodecEncoder = this;
            mediaCodecEncoder.mMediaCodec.releaseOutputBuffer(n2, bl);
            mediaCodecEncoder.mOutputBuffers.remove(n2);
        }
        catch (IllegalStateException illegalStateException) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = illegalStateException;
            j.b(TAG, "Failed to release output buffer", objectArray2);
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int dequeueOutputBufferInternal(MediaCodec.BufferInfo object, long l2) {
        void var0_4;
        int n2;
        block16: {
            int n3;
            block15: {
                int n4;
                block14: {
                    StringBuilder stringBuilder;
                    n3 = -1;
                    n4 = this.mMediaCodec.dequeueOutputBuffer((MediaCodec.BufferInfo)object, l2);
                    if (n4 < 0) break block14;
                    if (!((((MediaCodec.BufferInfo)object).flags & 2) != 0)) break block14;
                    j.a(TAG, "Config frame generated. Offset: %d, size: %d", (Object)((MediaCodec.BufferInfo)object).offset, (Object)((MediaCodec.BufferInfo)object).size);
                    Comparable<ByteBuffer> comparable = this.getMediaCodecOutputBuffer(n4);
                    ((ByteBuffer)comparable).position(((MediaCodec.BufferInfo)object).offset);
                    ((ByteBuffer)comparable).limit(((MediaCodec.BufferInfo)object).offset + ((MediaCodec.BufferInfo)object).size);
                    this.mConfigData = ByteBuffer.allocateDirect(((MediaCodec.BufferInfo)object).size);
                    this.mConfigData.put((ByteBuffer)comparable);
                    comparable = stringBuilder;
                    stringBuilder = new StringBuilder();
                    int n5 = 0;
                    while (true) {
                        int n6;
                        if ((n6 = ((MediaCodec.BufferInfo)object).size) >= 8) {
                            n6 = 8;
                        }
                        if (n5 >= n6) break;
                        ((StringBuilder)comparable).append(Integer.toHexString(this.mConfigData.get(n5) & 0xFF)).append(" ");
                        ++n5;
                    }
                    MediaCodecEncoder mediaCodecEncoder = this;
                    Object[] objectArray = new Object[1];
                    try {
                        objectArray[0] = ((StringBuilder)comparable).toString();
                        j.c(TAG, "spsData: %s", objectArray);
                        mediaCodecEncoder.mMediaCodec.releaseOutputBuffer(n4, false);
                        n2 = mediaCodecEncoder.mMediaCodec.dequeueOutputBuffer((MediaCodec.BufferInfo)object, l2);
                        break block15;
                    }
                    catch (IllegalStateException illegalStateException) {
                        n2 = n4;
                    }
                    break block16;
                }
                n2 = n4;
            }
            if (n2 < 0) return n2;
            try {
                ByteBuffer byteBuffer = this.getMediaCodecOutputBuffer(n2);
                byteBuffer.position(((MediaCodec.BufferInfo)object).offset);
                byteBuffer.limit(((MediaCodec.BufferInfo)object).offset + ((MediaCodec.BufferInfo)object).size);
                n3 = (((MediaCodec.BufferInfo)object).flags & 1) != 0 ? 1 : 0;
                if (n3 != 0) {
                    j.a(TAG, "Key frame generated");
                }
                if (n3 != 0 && this.mConfigData != null) {
                    Object object2 = object;
                    j.a(TAG, "Appending config frame of size %d to output buffer with size %d", (Object)this.mConfigData.capacity(), (Object)((MediaCodec.BufferInfo)object).size);
                    object = ByteBuffer.allocateDirect(this.mConfigData.capacity() + ((MediaCodec.BufferInfo)object).size);
                    MediaCodecEncoder mediaCodecEncoder = this;
                    mediaCodecEncoder.mConfigData.rewind();
                    ((ByteBuffer)object).put(mediaCodecEncoder.mConfigData);
                    ((ByteBuffer)object).put(byteBuffer);
                    ((ByteBuffer)object).rewind();
                    ((MediaCodec.BufferInfo)object2).offset = 0;
                    ((MediaCodec.BufferInfo)object2).size += this.mConfigData.capacity();
                    this.mOutputBuffers.put(n2, object);
                    return n2;
                }
                this.mOutputBuffers.put(n2, (Object)byteBuffer);
                return n2;
            }
            catch (IllegalStateException illegalStateException) {}
            break block16;
            catch (IllegalStateException illegalStateException) {
                n2 = n3;
            }
        }
        Object[] objectArray = new Object[1];
        object = objectArray;
        objectArray[0] = var0_4;
        j.b(TAG, "Failed to dequeue output buffer", (Object[])object);
        return n2;
    }
}

