/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.input;

import a.b.c.b.d.l;
import a.b.c.b.d.o;
import a.b.c.b.d.p;
import a.b.c.b.n;
import a.b.c.b.w;
import a.b.c.b.y;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.List;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.content.browser.accessibility.WebContentsAccessibilityImpl;
import org.chromium.content.browser.selection.SelectionPopupControllerImpl;
import org.chromium.content.browser.webcontents.WebContentsImpl;
import org.chromium.content_public.browser.WebContents;
import org.chromium.ui.base.DeviceFormFactor;
import org.chromium.ui.base.ViewAndroidDelegate;
import org.chromium.ui.base.WindowAndroid;

@JNINamespace(value="content")
public class SelectPopup
implements n.a,
ViewAndroidDelegate.ContainerViewObserver,
w,
a.b.a.o {
    public static final /* synthetic */ boolean $assertionsDisabled;
    public final WebContentsImpl mWebContents;
    public View mContainerView;
    public Ui mPopupView;
    public long mNativeSelectPopup;
    public long mNativeSelectPopupSourceFrame;

    public static SelectPopup fromWebContents(WebContents webContents) {
        return ((WebContentsImpl)webContents).getOrSetUserData(SelectPopup.class, UserDataFactoryLazyHolder.INSTANCE);
    }

    public static SelectPopup create(WebContents webContents, long l2) {
        SelectPopup.fromWebContents(webContents).mNativeSelectPopup = l2;
        return SelectPopup.fromWebContents(webContents);
    }

    public SelectPopup(WebContents object) {
        this.mWebContents = (WebContentsImpl)object;
        object = this.mWebContents.getViewAndroidDelegate();
        if (!$assertionsDisabled && object == null) {
            throw new AssertionError();
        }
        this.mContainerView = ((ViewAndroidDelegate)object).getContainerView();
        ((ViewAndroidDelegate)object).addObserver(this);
        object = this.mWebContents;
        if (object != null) {
            n.a((WebContents)object).a.add(this);
        }
        y.a(this.mWebContents).a(this);
    }

    private void show(View view, long l2, String[] object, int[] nArray, boolean bl, int[] nArray2, boolean bl2) {
        if (this.mContainerView.getParent() != null && this.mContainerView.getVisibility() == 0) {
            ArrayList arrayList;
            Object object2;
            Object object3 = this.mWebContents;
            if (object3 != null) {
                object2 = SelectionPopupControllerImpl.fromWebContents((WebContents)object3);
                if (object2 != null) {
                    ((SelectionPopupControllerImpl)object2).destroyActionModeAndUnselect();
                }
                if ((object3 = n.a((WebContents)object3)) != null) {
                    ((n)object3).a();
                }
            }
            if (!$assertionsDisabled && this.mNativeSelectPopupSourceFrame != 0L) {
                throw new AssertionError((Object)"Zombie popup did not clear the frame source");
            }
            object3 = this.mWebContents.getContext();
            if (object3 == null) {
                return;
            }
            if (!$assertionsDisabled && ((String[])object).length != nArray.length) {
                throw new AssertionError();
            }
            object2 = arrayList;
            arrayList = new ArrayList();
            for (int i2 = 0; i2 < ((String[])object).length; ++i2) {
                object2.add(new p(object[i2], nArray[i2]));
            }
            object = WebContentsAccessibilityImpl.fromWebContents(this.mWebContents);
            this.mPopupView = DeviceFormFactor.isTablet() && !bl && !((WebContentsAccessibilityImpl)object).isTouchExplorationEnabled() ? new o(this, (Context)object3, view, (List<p>)object2, nArray2, bl2) : new l(this, (Context)object3, (List<p>)object2, bl, nArray2);
            this.mNativeSelectPopupSourceFrame = l2;
            this.mPopupView.show();
            return;
        }
        this.mNativeSelectPopupSourceFrame = l2;
        this.selectMenuItems(null);
    }

    private void onNativeDestroyed() {
        this.mNativeSelectPopup = 0L;
    }

    private native void nativeSelectMenuItems(long var1, long var3, int[] var5);

    static {
        $assertionsDisabled = SelectPopup.class.desiredAssertionStatus() ^ true;
    }

    public void close() {
        this.mPopupView = null;
    }

    @Override
    public void hide() {
        Ui ui = ((SelectPopup)((Object)ui)).mPopupView;
        if (ui != null) {
            ui.hide(true);
        }
    }

    @Override
    public void onUpdateContainerView(ViewGroup viewGroup) {
        this.mContainerView = viewGroup;
        this.hide();
    }

    @Override
    public void onWindowAndroidChanged(WindowAndroid windowAndroid) {
        this.close();
    }

    public void hideWithoutCancel() {
        Ui ui = this.mPopupView;
        if (ui == null) {
            return;
        }
        SelectPopup selectPopup = this;
        ui.hide(false);
        selectPopup.mPopupView = null;
        selectPopup.mNativeSelectPopupSourceFrame = 0L;
    }

    public boolean isVisibleForTesting() {
        return this.mPopupView != null;
    }

    public void selectMenuItems(int[] nArray) {
        long l2 = this.mNativeSelectPopup;
        if (l2 != 0L) {
            this.nativeSelectMenuItems(l2, this.mNativeSelectPopupSourceFrame, nArray);
        }
        SelectPopup selectPopup = this;
        selectPopup.mNativeSelectPopupSourceFrame = 0L;
        selectPopup.mPopupView = null;
    }

    private static final class UserDataFactoryLazyHolder {
        public static final WebContentsImpl.UserDataFactory<SelectPopup> INSTANCE = SelectPopup::new;

        public static /* synthetic */ WebContentsImpl.UserDataFactory access$000() {
            return INSTANCE;
        }
    }

    public static interface Ui {
        public void show();

        public void hide(boolean var1);
    }
}

