/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import a.b.a.c.a;
import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import android.os.StrictMode;
import android.util.Log;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.regex.Pattern;
import org.chromium.base.CommandLine;
import org.chromium.base.ContextUtils;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="base::android")
public class SysUtils {
    public static final int ANDROID_LOW_MEMORY_DEVICE_THRESHOLD_MB = 512;
    public static final int ANDROID_O_LOW_MEMORY_DEVICE_THRESHOLD_MB = 1024;
    public static final String TAG = "SysUtils";
    public static Boolean sLowEndDevice;
    public static Integer sAmountOfPhysicalMemoryKB;
    public static a.a sLowEndMatches;
    public static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    public static int detectAmountOfPhysicalMemoryKB() {
        block19: {
            block18: {
                block17: {
                    var0 = Pattern.compile("^MemTotal:\\s+([0-9]+) kB$");
                    var1_3 = StrictMode.allowThreadDiskReads();
                    var2_4 = v0;
                    v0 = new FileReader("/proc/meminfo");
                    var3_5 = v1;
                    v1 = new BufferedReader(var2_4);
                    do {
                        if ((var4_6 = var3_5.readLine()) != null) continue;
                        v2 = "SysUtils";
                        v3 = "/proc/meminfo lacks a MemTotal entry?";
lbl14:
                        // 2 sources

                        while (true) {
                            Log.w((String)v2, (String)v3);
                            break block17;
                            break;
                        }
                    } while (!(var4_6 = var0.matcher((CharSequence)var4_6)).find());
                    var0_1 = Integer.parseInt(var4_6.group(1));
                    if (var0_1 <= 1024) {
                        v2 = "SysUtils";
                        v3 = "Invalid /proc/meminfo total size in kB: " + var4_6.group(1);
                        ** continue;
                    }
                    break block18;
                }
                v4 = var1_3;
                v5 = var2_4;
                var3_5.close();
                v5.close();
            }
            v6 = var0_1;
            v7 = var1_3;
            v8 = var2_4;
            var3_5.close();
            v8.close();
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)v7);
            return v6;
            catch (Throwable v9) {
                try {
                    var3_5.close();
                    throw v9;
                }
                catch (Throwable v10) {
                    try {
                        var2_4.close();
                        throw v10;
                        catch (Throwable v11) {
                            break block19;
                        }
                    }
                    catch (Exception var0_2) {
                        v4 = var1_3;
                        Log.w((String)"SysUtils", (String)"Cannot get total physical size from /proc/meminfo", (Throwable)var0_2);
                    }
                }
            }
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)v4);
            return 0;
        }
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)var1_3);
        throw v11;
    }

    public static boolean isLowEndDevice() {
        if (sLowEndDevice == null) {
            sLowEndDevice = SysUtils.detectLowEndDevice();
        }
        return sLowEndDevice;
    }

    public static int amountOfPhysicalMemoryKB() {
        if (sAmountOfPhysicalMemoryKB == null) {
            sAmountOfPhysicalMemoryKB = SysUtils.detectAmountOfPhysicalMemoryKB();
        }
        return sAmountOfPhysicalMemoryKB;
    }

    public static boolean isCurrentlyLowMemory() {
        ActivityManager.MemoryInfo memoryInfo;
        ActivityManager.MemoryInfo memoryInfo2 = memoryInfo;
        ((ActivityManager)ContextUtils.sApplicationContext.getSystemService("activity")).getMemoryInfo(new ActivityManager.MemoryInfo());
        return memoryInfo2.lowMemory;
    }

    public static void resetForTesting() {
        sLowEndDevice = null;
        sAmountOfPhysicalMemoryKB = null;
    }

    public static boolean hasCamera(Context context) {
        context = context.getPackageManager();
        boolean bl = context.hasSystemFeature("android.hardware.camera");
        if (Build.VERSION.SDK_INT >= 17) {
            bl |= context.hasSystemFeature("android.hardware.camera.any");
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @TargetApi(value=19)
    public static boolean detectLowEndDevice() {
        if (!$assertionsDisabled && !CommandLine.isInitialized()) {
            throw new AssertionError();
        }
        if (CommandLine.getInstance().hasSwitch("enable-low-end-device-mode")) {
            return true;
        }
        if (CommandLine.getInstance().hasSwitch("disable-low-end-device-mode")) {
            return false;
        }
        sAmountOfPhysicalMemoryKB = SysUtils.detectAmountOfPhysicalMemoryKB();
        boolean bl = sAmountOfPhysicalMemoryKB > 0 && (Build.VERSION.SDK_INT >= 26 ? sAmountOfPhysicalMemoryKB / 1024 <= 1024 : sAmountOfPhysicalMemoryKB / 1024 <= 512);
        boolean bl2 = false;
        if (ContextUtils.sApplicationContext != null && Build.VERSION.SDK_INT >= 19) {
            bl2 = ((ActivityManager)ContextUtils.sApplicationContext.getSystemService("activity")).isLowRamDevice();
        }
        a.a a2 = sLowEndMatches;
        boolean bl3 = bl == bl2;
        a2.a(bl3);
        return bl;
    }

    public static void logPageFaultCountToTracing() {
        SysUtils.nativeLogPageFaultCountToTracing();
    }

    public static native void nativeLogPageFaultCountToTracing();

    static {
        $assertionsDisabled = SysUtils.class.desiredAssertionStatus() ^ true;
        sLowEndMatches = new a.a("Android.SysUtilsLowEndMatches");
    }
}

