/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.annotations.MainDex;

@JNINamespace(value="base::android")
@MainDex
public class JavaHandlerThread {
    public static final /* synthetic */ boolean $assertionsDisabled;
    public final HandlerThread mThread;
    public Throwable mUnhandledException;

    public JavaHandlerThread(String string2, int n2) {
        this.mThread = new HandlerThread(string2, n2);
    }

    public static JavaHandlerThread create(String string2, int n2) {
        return new JavaHandlerThread(string2, n2);
    }

    private void startAndInitialize(final long l2, final long l3) {
        this.maybeStart();
        new Handler(this.mThread.getLooper()).post(new Runnable(){

            @Override
            public void run() {
                JavaHandlerThread.this.nativeInitializeThread(l2, l3);
            }
        });
    }

    private void quitThreadSafely(final long l2) {
        new Handler(this.mThread.getLooper()).post(new Runnable(){

            @Override
            public void run() {
                2 v0 = this;
                v0.JavaHandlerThread.this.mThread.quit();
                v0.JavaHandlerThread.this.nativeOnLooperStopped(l2);
            }
        });
        if (Build.VERSION.SDK_INT >= 18) {
            this.mThread.getLooper().quitSafely();
        }
    }

    private void joinThread() {
        boolean bl = false;
        while (!bl) {
            try {
                this.mThread.join();
                bl = true;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private boolean hasStarted() {
        return this.mThread.getState() != Thread.State.NEW;
    }

    private boolean isAlive() {
        return this.mThread.isAlive();
    }

    private void listenForUncaughtExceptionsForTesting() {
        this.mThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                JavaHandlerThread.access$302(JavaHandlerThread.this, throwable);
            }
        });
    }

    private Throwable getUncaughtExceptionIfAny() {
        return this.mUnhandledException;
    }

    private native void nativeInitializeThread(long var1, long var3);

    private native void nativeOnLooperStopped(long var1);

    public static /* synthetic */ Throwable access$302(JavaHandlerThread javaHandlerThread, Throwable throwable) {
        javaHandlerThread.mUnhandledException = throwable;
        return throwable;
    }

    static {
        $assertionsDisabled = JavaHandlerThread.class.desiredAssertionStatus() ^ true;
    }

    public Looper getLooper() {
        if (!$assertionsDisabled && !this.hasStarted()) {
            throw new AssertionError();
        }
        return this.mThread.getLooper();
    }

    public void maybeStart() {
        if (this.hasStarted()) {
            return;
        }
        this.mThread.start();
    }
}

