
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/viz/public/interfaces/compositing/quads.mojom
//

package com.vccorp.viz.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class YuvVideoQuadState extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 80;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(80, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public com.vccorp.gfx.mojom.RectF yaTexCoordRect;
    public com.vccorp.gfx.mojom.RectF uvTexCoordRect;
    public com.vccorp.gfx.mojom.Size yaTexSize;
    public com.vccorp.gfx.mojom.Size uvTexSize;
    public int yPlaneResourceId;
    public int uPlaneResourceId;
    public int vPlaneResourceId;
    public int aPlaneResourceId;
    public float resourceOffset;
    public float resourceMultiplier;
    public int bitsPerChannel;
    public com.vccorp.gfx.mojom.ColorSpace videoColorSpace;
    public int protectedVideoType;

    private YuvVideoQuadState(int version) {
        super(STRUCT_SIZE, version);
    }

    public YuvVideoQuadState() {
        this(0);
    }

    public static YuvVideoQuadState deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static YuvVideoQuadState deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static YuvVideoQuadState decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        YuvVideoQuadState result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new YuvVideoQuadState(elementsOrVersion);
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                result.yaTexCoordRect = com.vccorp.gfx.mojom.RectF.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                result.uvTexCoordRect = com.vccorp.gfx.mojom.RectF.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                result.yaTexSize = com.vccorp.gfx.mojom.Size.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, false);
                result.uvTexSize = com.vccorp.gfx.mojom.Size.decode(decoder1);
                }
                {
                    
                result.yPlaneResourceId = decoder0.readInt(40);
                }
                {
                    
                result.uPlaneResourceId = decoder0.readInt(44);
                }
                {
                    
                result.vPlaneResourceId = decoder0.readInt(48);
                }
                {
                    
                result.aPlaneResourceId = decoder0.readInt(52);
                }
                {
                    
                result.resourceOffset = decoder0.readFloat(56);
                }
                {
                    
                result.resourceMultiplier = decoder0.readFloat(60);
                }
                {
                    
                result.bitsPerChannel = decoder0.readInt(64);
                }
                {
                    
                result.protectedVideoType = decoder0.readInt(68);
                    ProtectedVideoState.validate(result.protectedVideoType);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(72, false);
                result.videoColorSpace = com.vccorp.gfx.mojom.ColorSpace.decode(decoder1);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.yaTexCoordRect, 8, false);
        
        encoder0.encode(this.uvTexCoordRect, 16, false);
        
        encoder0.encode(this.yaTexSize, 24, false);
        
        encoder0.encode(this.uvTexSize, 32, false);
        
        encoder0.encode(this.yPlaneResourceId, 40);
        
        encoder0.encode(this.uPlaneResourceId, 44);
        
        encoder0.encode(this.vPlaneResourceId, 48);
        
        encoder0.encode(this.aPlaneResourceId, 52);
        
        encoder0.encode(this.resourceOffset, 56);
        
        encoder0.encode(this.resourceMultiplier, 60);
        
        encoder0.encode(this.bitsPerChannel, 64);
        
        encoder0.encode(this.protectedVideoType, 68);
        
        encoder0.encode(this.videoColorSpace, 72, false);
    }
}