
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/viz/public/interfaces/compositing/video_detector_observer.mojom
//

package com.vccorp.viz.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class VideoDetectorObserver_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<VideoDetectorObserver, VideoDetectorObserver.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<VideoDetectorObserver, VideoDetectorObserver.Proxy>() {

        @Override
        public String getName() {
            return "viz.mojom.VideoDetectorObserver";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, VideoDetectorObserver impl) {
            return new Stub(core, impl);
        }

        @Override
        public VideoDetectorObserver[] buildArray(int size) {
          return new VideoDetectorObserver[size];
        }
    };


    private static final int ON_VIDEO_ACTIVITY_STARTED_ORDINAL = 0;

    private static final int ON_VIDEO_ACTIVITY_ENDED_ORDINAL = 1;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements VideoDetectorObserver.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void onVideoActivityStarted(
) {

            VideoDetectorObserverOnVideoActivityStartedParams _message = new VideoDetectorObserverOnVideoActivityStartedParams();


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_VIDEO_ACTIVITY_STARTED_ORDINAL)));

        }


        @Override
        public void onVideoActivityEnded(
) {

            VideoDetectorObserverOnVideoActivityEndedParams _message = new VideoDetectorObserverOnVideoActivityEndedParams();


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_VIDEO_ACTIVITY_ENDED_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<VideoDetectorObserver> {

        Stub(com.vccorp.mojo.system.Core core, VideoDetectorObserver impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                VideoDetectorObserver_Internal.MANAGER, messageWithHeader);





                    case ON_VIDEO_ACTIVITY_STARTED_ORDINAL: {

                        VideoDetectorObserverOnVideoActivityStartedParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onVideoActivityStarted();
                        return true;
                    }





                    case ON_VIDEO_ACTIVITY_ENDED_ORDINAL: {

                        VideoDetectorObserverOnVideoActivityEndedParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onVideoActivityEnded();
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), VideoDetectorObserver_Internal.MANAGER, messageWithHeader, receiver);






                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class VideoDetectorObserverOnVideoActivityStartedParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private VideoDetectorObserverOnVideoActivityStartedParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public VideoDetectorObserverOnVideoActivityStartedParams() {
            this(0);
        }

        public static VideoDetectorObserverOnVideoActivityStartedParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static VideoDetectorObserverOnVideoActivityStartedParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static VideoDetectorObserverOnVideoActivityStartedParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            VideoDetectorObserverOnVideoActivityStartedParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new VideoDetectorObserverOnVideoActivityStartedParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class VideoDetectorObserverOnVideoActivityEndedParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private VideoDetectorObserverOnVideoActivityEndedParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public VideoDetectorObserverOnVideoActivityEndedParams() {
            this(0);
        }

        public static VideoDetectorObserverOnVideoActivityEndedParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static VideoDetectorObserverOnVideoActivityEndedParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static VideoDetectorObserverOnVideoActivityEndedParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            VideoDetectorObserverOnVideoActivityEndedParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new VideoDetectorObserverOnVideoActivityEndedParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



}
