
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/viz/public/interfaces/compositing/filter_operation.mojom
//

package com.vccorp.viz.mojom;

import com.vccorp.mojo.bindings.DeserializationException;

public final class FilterType {
    private static final boolean IS_EXTENSIBLE = false;

    public static final int GRAYSCALE = 0;
    public static final int SEPIA = 1; // GRAYSCALE + 1
    public static final int SATURATE = 2; // SEPIA + 1
    public static final int HUE_ROTATE = 3; // SATURATE + 1
    public static final int INVERT = 4; // HUE_ROTATE + 1
    public static final int BRIGHTNESS = 5; // INVERT + 1
    public static final int CONTRAST = 6; // BRIGHTNESS + 1
    public static final int OPACITY = 7; // CONTRAST + 1
    public static final int BLUR = 8; // OPACITY + 1
    public static final int DROP_SHADOW = 9; // BLUR + 1
    public static final int COLOR_MATRIX = 10; // DROP_SHADOW + 1
    public static final int ZOOM = 11; // COLOR_MATRIX + 1
    public static final int REFERENCE = 12; // ZOOM + 1
    public static final int SATURATING_BRIGHTNESS = 13; // REFERENCE + 1
    public static final int ALPHA_THRESHOLD = 14; // SATURATING_BRIGHTNESS + 1
    public static final int FILTER_TYPE_LAST = FilterType.ALPHA_THRESHOLD;

    public static boolean isKnownValue(int value) {
        return value >= 0 && value <= 14;
    }

    public static void validate(int value) {
        if (IS_EXTENSIBLE || isKnownValue(value)) return;
        throw new DeserializationException("Invalid enum value.");
    }

    private FilterType() {}
}