
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/viz/public/interfaces/compositing/compositor_frame_sink.mojom
//

package com.vccorp.viz.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class CompositorFrameSink_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<CompositorFrameSink, CompositorFrameSink.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<CompositorFrameSink, CompositorFrameSink.Proxy>() {

        @Override
        public String getName() {
            return "viz.mojom.CompositorFrameSink";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, CompositorFrameSink impl) {
            return new Stub(core, impl);
        }

        @Override
        public CompositorFrameSink[] buildArray(int size) {
          return new CompositorFrameSink[size];
        }
    };


    private static final int SET_NEEDS_BEGIN_FRAME_ORDINAL = 0;

    private static final int SET_WANTS_ANIMATE_ONLY_BEGIN_FRAMES_ORDINAL = 1;

    private static final int SUBMIT_COMPOSITOR_FRAME_ORDINAL = 2;

    private static final int SUBMIT_COMPOSITOR_FRAME_SYNC_ORDINAL = 3;

    private static final int DID_NOT_PRODUCE_FRAME_ORDINAL = 4;

    private static final int DID_ALLOCATE_SHARED_BITMAP_ORDINAL = 5;

    private static final int DID_DELETE_SHARED_BITMAP_ORDINAL = 6;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements CompositorFrameSink.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void setNeedsBeginFrame(
boolean needsBeginFrame) {

            CompositorFrameSinkSetNeedsBeginFrameParams _message = new CompositorFrameSinkSetNeedsBeginFrameParams();

            _message.needsBeginFrame = needsBeginFrame;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(SET_NEEDS_BEGIN_FRAME_ORDINAL)));

        }


        @Override
        public void setWantsAnimateOnlyBeginFrames(
) {

            CompositorFrameSinkSetWantsAnimateOnlyBeginFramesParams _message = new CompositorFrameSinkSetWantsAnimateOnlyBeginFramesParams();


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(SET_WANTS_ANIMATE_ONLY_BEGIN_FRAMES_ORDINAL)));

        }


        @Override
        public void submitCompositorFrame(
LocalSurfaceId localSurfaceId, CompositorFrame frame, HitTestRegionList hitTestRegionList, long submitTime) {

            CompositorFrameSinkSubmitCompositorFrameParams _message = new CompositorFrameSinkSubmitCompositorFrameParams();

            _message.localSurfaceId = localSurfaceId;

            _message.frame = frame;

            _message.hitTestRegionList = hitTestRegionList;

            _message.submitTime = submitTime;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(SUBMIT_COMPOSITOR_FRAME_ORDINAL)));

        }


        @Override
        public void submitCompositorFrameSync(
LocalSurfaceId localSurfaceId, CompositorFrame frame, HitTestRegionList hitTestRegionList, long submitTime, 
SubmitCompositorFrameSyncResponse callback) {

            CompositorFrameSinkSubmitCompositorFrameSyncParams _message = new CompositorFrameSinkSubmitCompositorFrameSyncParams();

            _message.localSurfaceId = localSurfaceId;

            _message.frame = frame;

            _message.hitTestRegionList = hitTestRegionList;

            _message.submitTime = submitTime;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    SUBMIT_COMPOSITOR_FRAME_SYNC_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new CompositorFrameSinkSubmitCompositorFrameSyncResponseParamsForwardToCallback(callback));

        }


        @Override
        public void didNotProduceFrame(
BeginFrameAck ack) {

            CompositorFrameSinkDidNotProduceFrameParams _message = new CompositorFrameSinkDidNotProduceFrameParams();

            _message.ack = ack;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(DID_NOT_PRODUCE_FRAME_ORDINAL)));

        }


        @Override
        public void didAllocateSharedBitmap(
com.vccorp.mojo.system.SharedBufferHandle buffer, com.vccorp.gpu.mojom.Mailbox id) {

            CompositorFrameSinkDidAllocateSharedBitmapParams _message = new CompositorFrameSinkDidAllocateSharedBitmapParams();

            _message.buffer = buffer;

            _message.id = id;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(DID_ALLOCATE_SHARED_BITMAP_ORDINAL)));

        }


        @Override
        public void didDeleteSharedBitmap(
com.vccorp.gpu.mojom.Mailbox id) {

            CompositorFrameSinkDidDeleteSharedBitmapParams _message = new CompositorFrameSinkDidDeleteSharedBitmapParams();

            _message.id = id;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(DID_DELETE_SHARED_BITMAP_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<CompositorFrameSink> {

        Stub(com.vccorp.mojo.system.Core core, CompositorFrameSink impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                CompositorFrameSink_Internal.MANAGER, messageWithHeader);





                    case SET_NEEDS_BEGIN_FRAME_ORDINAL: {

                        CompositorFrameSinkSetNeedsBeginFrameParams data =
                                CompositorFrameSinkSetNeedsBeginFrameParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setNeedsBeginFrame(data.needsBeginFrame);
                        return true;
                    }





                    case SET_WANTS_ANIMATE_ONLY_BEGIN_FRAMES_ORDINAL: {

                        CompositorFrameSinkSetWantsAnimateOnlyBeginFramesParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setWantsAnimateOnlyBeginFrames();
                        return true;
                    }





                    case SUBMIT_COMPOSITOR_FRAME_ORDINAL: {

                        CompositorFrameSinkSubmitCompositorFrameParams data =
                                CompositorFrameSinkSubmitCompositorFrameParams.deserialize(messageWithHeader.getPayload());

                        getImpl().submitCompositorFrame(data.localSurfaceId, data.frame, data.hitTestRegionList, data.submitTime);
                        return true;
                    }







                    case DID_NOT_PRODUCE_FRAME_ORDINAL: {

                        CompositorFrameSinkDidNotProduceFrameParams data =
                                CompositorFrameSinkDidNotProduceFrameParams.deserialize(messageWithHeader.getPayload());

                        getImpl().didNotProduceFrame(data.ack);
                        return true;
                    }





                    case DID_ALLOCATE_SHARED_BITMAP_ORDINAL: {

                        CompositorFrameSinkDidAllocateSharedBitmapParams data =
                                CompositorFrameSinkDidAllocateSharedBitmapParams.deserialize(messageWithHeader.getPayload());

                        getImpl().didAllocateSharedBitmap(data.buffer, data.id);
                        return true;
                    }





                    case DID_DELETE_SHARED_BITMAP_ORDINAL: {

                        CompositorFrameSinkDidDeleteSharedBitmapParams data =
                                CompositorFrameSinkDidDeleteSharedBitmapParams.deserialize(messageWithHeader.getPayload());

                        getImpl().didDeleteSharedBitmap(data.id);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), CompositorFrameSink_Internal.MANAGER, messageWithHeader, receiver);













                    case SUBMIT_COMPOSITOR_FRAME_SYNC_ORDINAL: {

                        CompositorFrameSinkSubmitCompositorFrameSyncParams data =
                                CompositorFrameSinkSubmitCompositorFrameSyncParams.deserialize(messageWithHeader.getPayload());

                        getImpl().submitCompositorFrameSync(data.localSurfaceId, data.frame, data.hitTestRegionList, data.submitTime, new CompositorFrameSinkSubmitCompositorFrameSyncResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }








                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class CompositorFrameSinkSetNeedsBeginFrameParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean needsBeginFrame;

        private CompositorFrameSinkSetNeedsBeginFrameParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public CompositorFrameSinkSetNeedsBeginFrameParams() {
            this(0);
        }

        public static CompositorFrameSinkSetNeedsBeginFrameParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static CompositorFrameSinkSetNeedsBeginFrameParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static CompositorFrameSinkSetNeedsBeginFrameParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            CompositorFrameSinkSetNeedsBeginFrameParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new CompositorFrameSinkSetNeedsBeginFrameParams(elementsOrVersion);
                    {
                        
                    result.needsBeginFrame = decoder0.readBoolean(8, 0);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.needsBeginFrame, 8, 0);
        }
    }



    
    static final class CompositorFrameSinkSetWantsAnimateOnlyBeginFramesParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private CompositorFrameSinkSetWantsAnimateOnlyBeginFramesParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public CompositorFrameSinkSetWantsAnimateOnlyBeginFramesParams() {
            this(0);
        }

        public static CompositorFrameSinkSetWantsAnimateOnlyBeginFramesParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static CompositorFrameSinkSetWantsAnimateOnlyBeginFramesParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static CompositorFrameSinkSetWantsAnimateOnlyBeginFramesParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            CompositorFrameSinkSetWantsAnimateOnlyBeginFramesParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new CompositorFrameSinkSetWantsAnimateOnlyBeginFramesParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class CompositorFrameSinkSubmitCompositorFrameParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 40;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(40, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public LocalSurfaceId localSurfaceId;
        public CompositorFrame frame;
        public HitTestRegionList hitTestRegionList;
        public long submitTime;

        private CompositorFrameSinkSubmitCompositorFrameParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public CompositorFrameSinkSubmitCompositorFrameParams() {
            this(0);
        }

        public static CompositorFrameSinkSubmitCompositorFrameParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static CompositorFrameSinkSubmitCompositorFrameParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static CompositorFrameSinkSubmitCompositorFrameParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            CompositorFrameSinkSubmitCompositorFrameParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new CompositorFrameSinkSubmitCompositorFrameParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.localSurfaceId = LocalSurfaceId.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.frame = CompositorFrame.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, true);
                    result.hitTestRegionList = HitTestRegionList.decode(decoder1);
                    }
                    {
                        
                    result.submitTime = decoder0.readLong(32);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.localSurfaceId, 8, false);
            
            encoder0.encode(this.frame, 16, false);
            
            encoder0.encode(this.hitTestRegionList, 24, true);
            
            encoder0.encode(this.submitTime, 32);
        }
    }



    
    static final class CompositorFrameSinkSubmitCompositorFrameSyncParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 40;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(40, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public LocalSurfaceId localSurfaceId;
        public CompositorFrame frame;
        public HitTestRegionList hitTestRegionList;
        public long submitTime;

        private CompositorFrameSinkSubmitCompositorFrameSyncParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public CompositorFrameSinkSubmitCompositorFrameSyncParams() {
            this(0);
        }

        public static CompositorFrameSinkSubmitCompositorFrameSyncParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static CompositorFrameSinkSubmitCompositorFrameSyncParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static CompositorFrameSinkSubmitCompositorFrameSyncParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            CompositorFrameSinkSubmitCompositorFrameSyncParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new CompositorFrameSinkSubmitCompositorFrameSyncParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.localSurfaceId = LocalSurfaceId.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.frame = CompositorFrame.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, true);
                    result.hitTestRegionList = HitTestRegionList.decode(decoder1);
                    }
                    {
                        
                    result.submitTime = decoder0.readLong(32);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.localSurfaceId, 8, false);
            
            encoder0.encode(this.frame, 16, false);
            
            encoder0.encode(this.hitTestRegionList, 24, true);
            
            encoder0.encode(this.submitTime, 32);
        }
    }



    
    static final class CompositorFrameSinkSubmitCompositorFrameSyncResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public ReturnedResource[] resources;

        private CompositorFrameSinkSubmitCompositorFrameSyncResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public CompositorFrameSinkSubmitCompositorFrameSyncResponseParams() {
            this(0);
        }

        public static CompositorFrameSinkSubmitCompositorFrameSyncResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static CompositorFrameSinkSubmitCompositorFrameSyncResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static CompositorFrameSinkSubmitCompositorFrameSyncResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            CompositorFrameSinkSubmitCompositorFrameSyncResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new CompositorFrameSinkSubmitCompositorFrameSyncResponseParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.resources = new ReturnedResource[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                            result.resources[i1] = ReturnedResource.decode(decoder2);
                        }
                    }
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            if (this.resources == null) {
                encoder0.encodeNullPointer(8, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.resources.length, 8, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.resources.length; ++i0) {
                    
                    encoder1.encode(this.resources[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
        }
    }

    static class CompositorFrameSinkSubmitCompositorFrameSyncResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final CompositorFrameSink.SubmitCompositorFrameSyncResponse mCallback;

        CompositorFrameSinkSubmitCompositorFrameSyncResponseParamsForwardToCallback(CompositorFrameSink.SubmitCompositorFrameSyncResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(SUBMIT_COMPOSITOR_FRAME_SYNC_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                CompositorFrameSinkSubmitCompositorFrameSyncResponseParams response = CompositorFrameSinkSubmitCompositorFrameSyncResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.resources);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class CompositorFrameSinkSubmitCompositorFrameSyncResponseParamsProxyToResponder implements CompositorFrameSink.SubmitCompositorFrameSyncResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        CompositorFrameSinkSubmitCompositorFrameSyncResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(ReturnedResource[] resources) {
            CompositorFrameSinkSubmitCompositorFrameSyncResponseParams _response = new CompositorFrameSinkSubmitCompositorFrameSyncResponseParams();

            _response.resources = resources;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    SUBMIT_COMPOSITOR_FRAME_SYNC_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class CompositorFrameSinkDidNotProduceFrameParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public BeginFrameAck ack;

        private CompositorFrameSinkDidNotProduceFrameParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public CompositorFrameSinkDidNotProduceFrameParams() {
            this(0);
        }

        public static CompositorFrameSinkDidNotProduceFrameParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static CompositorFrameSinkDidNotProduceFrameParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static CompositorFrameSinkDidNotProduceFrameParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            CompositorFrameSinkDidNotProduceFrameParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new CompositorFrameSinkDidNotProduceFrameParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.ack = BeginFrameAck.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.ack, 8, false);
        }
    }



    
    static final class CompositorFrameSinkDidAllocateSharedBitmapParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo.system.SharedBufferHandle buffer;
        public com.vccorp.gpu.mojom.Mailbox id;

        private CompositorFrameSinkDidAllocateSharedBitmapParams(int version) {
            super(STRUCT_SIZE, version);
            this.buffer = com.vccorp.mojo.system.InvalidHandle.INSTANCE;
        }

        public CompositorFrameSinkDidAllocateSharedBitmapParams() {
            this(0);
        }

        public static CompositorFrameSinkDidAllocateSharedBitmapParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static CompositorFrameSinkDidAllocateSharedBitmapParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static CompositorFrameSinkDidAllocateSharedBitmapParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            CompositorFrameSinkDidAllocateSharedBitmapParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new CompositorFrameSinkDidAllocateSharedBitmapParams(elementsOrVersion);
                    {
                        
                    result.buffer = decoder0.readSharedBufferHandle(8, false);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.id = com.vccorp.gpu.mojom.Mailbox.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.buffer, 8, false);
            
            encoder0.encode(this.id, 16, false);
        }
    }



    
    static final class CompositorFrameSinkDidDeleteSharedBitmapParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.gpu.mojom.Mailbox id;

        private CompositorFrameSinkDidDeleteSharedBitmapParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public CompositorFrameSinkDidDeleteSharedBitmapParams() {
            this(0);
        }

        public static CompositorFrameSinkDidDeleteSharedBitmapParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static CompositorFrameSinkDidDeleteSharedBitmapParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static CompositorFrameSinkDidDeleteSharedBitmapParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            CompositorFrameSinkDidDeleteSharedBitmapParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new CompositorFrameSinkDidDeleteSharedBitmapParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.id = com.vccorp.gpu.mojom.Mailbox.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.id, 8, false);
        }
    }



}
