
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/viz/public/interfaces/compositing/begin_frame_args.mojom
//

package com.vccorp.viz.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class BeginFrameArgs extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 64;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(64, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public com.vccorp.mojo_base.mojom.TimeTicks frameTime;
    public com.vccorp.mojo_base.mojom.TimeTicks deadline;
    public com.vccorp.mojo_base.mojom.TimeDelta interval;
    public long sourceId;
    public long sequenceNumber;
    public long traceId;
    public int type;
    public boolean onCriticalPath;
    public boolean animateOnly;

    private BeginFrameArgs(int version) {
        super(STRUCT_SIZE, version);
    }

    public BeginFrameArgs() {
        this(0);
    }

    public static BeginFrameArgs deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static BeginFrameArgs deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static BeginFrameArgs decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        BeginFrameArgs result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new BeginFrameArgs(elementsOrVersion);
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                result.frameTime = com.vccorp.mojo_base.mojom.TimeTicks.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                result.deadline = com.vccorp.mojo_base.mojom.TimeTicks.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                result.interval = com.vccorp.mojo_base.mojom.TimeDelta.decode(decoder1);
                }
                {
                    
                result.sourceId = decoder0.readLong(32);
                }
                {
                    
                result.sequenceNumber = decoder0.readLong(40);
                }
                {
                    
                result.traceId = decoder0.readLong(48);
                }
                {
                    
                result.type = decoder0.readInt(56);
                    BeginFrameArgsType.validate(result.type);
                }
                {
                    
                result.onCriticalPath = decoder0.readBoolean(60, 0);
                }
                {
                    
                result.animateOnly = decoder0.readBoolean(60, 1);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.frameTime, 8, false);
        
        encoder0.encode(this.deadline, 16, false);
        
        encoder0.encode(this.interval, 24, false);
        
        encoder0.encode(this.sourceId, 32);
        
        encoder0.encode(this.sequenceNumber, 40);
        
        encoder0.encode(this.traceId, 48);
        
        encoder0.encode(this.type, 56);
        
        encoder0.encode(this.onCriticalPath, 60, 0);
        
        encoder0.encode(this.animateOnly, 60, 1);
    }
}