
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     ui/latency/mojo/latency_info.mojom
//

package com.vccorp.ui.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class LatencyInfo extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 56;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(56, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public String traceName;
    public java.util.Map<Integer, com.vccorp.mojo_base.mojom.TimeTicks> latencyComponents;
    public long traceId;
    public long ukmSourceId;
    public boolean coalesced;
    public boolean began;
    public boolean terminated;
    public int sourceEventType;
    public float scrollUpdateDelta;
    public float predictedScrollUpdateDelta;

    private LatencyInfo(int version) {
        super(STRUCT_SIZE, version);
    }

    public LatencyInfo() {
        this(0);
    }

    public static LatencyInfo deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static LatencyInfo deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static LatencyInfo decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        LatencyInfo result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new LatencyInfo(elementsOrVersion);
                {
                    
                result.traceName = decoder0.readString(8, false);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                {
                    decoder1.readDataHeaderForMap();
                    int[] keys0;
                    com.vccorp.mojo_base.mojom.TimeTicks[] values0;
                    {
                        
                        keys0 = decoder1.readInts(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        {
                            for (int i1 = 0; i1 < keys0.length; ++i1) {
                                LatencyComponentType.validate(keys0[i1]);
                            }
                        }
                    }
                    {
                        
                        com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE, false);
                        {
                            com.vccorp.mojo.bindings.DataHeader si2 = decoder2.readDataHeaderForPointerArray(keys0.length);
                            values0 = new com.vccorp.mojo_base.mojom.TimeTicks[si2.elementsOrVersion];
                            for (int i2 = 0; i2 < si2.elementsOrVersion; ++i2) {
                                
                                com.vccorp.mojo.bindings.Decoder decoder3 = decoder2.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i2, false);
                                values0[i2] = com.vccorp.mojo_base.mojom.TimeTicks.decode(decoder3);
                            }
                        }
                    }
                    result.latencyComponents = new java.util.HashMap<Integer, com.vccorp.mojo_base.mojom.TimeTicks>();
                    for (int index0 = 0; index0 < keys0.length; ++index0) {
                        result.latencyComponents.put(keys0[index0],  values0[index0]);
                    }
                }
                }
                {
                    
                result.traceId = decoder0.readLong(24);
                }
                {
                    
                result.ukmSourceId = decoder0.readLong(32);
                }
                {
                    
                result.coalesced = decoder0.readBoolean(40, 0);
                }
                {
                    
                result.began = decoder0.readBoolean(40, 1);
                }
                {
                    
                result.terminated = decoder0.readBoolean(40, 2);
                }
                {
                    
                result.sourceEventType = decoder0.readInt(44);
                    SourceEventType.validate(result.sourceEventType);
                }
                {
                    
                result.scrollUpdateDelta = decoder0.readFloat(48);
                }
                {
                    
                result.predictedScrollUpdateDelta = decoder0.readFloat(52);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.traceName, 8, false);
        
        if (this.latencyComponents == null) {
            encoder0.encodeNullPointer(16, false);
        } else {
            org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encoderForMap(16);
            int size0 = this.latencyComponents.size();
            int[] keys0 = new int[size0];
            com.vccorp.mojo_base.mojom.TimeTicks[] values0 = new com.vccorp.mojo_base.mojom.TimeTicks[size0];
            int index0 = 0;
            for (java.util.Map.Entry<Integer, com.vccorp.mojo_base.mojom.TimeTicks> entry0 : this.latencyComponents.entrySet()) {
                keys0[index0] = entry0.getKey();
                values0[index0] = entry0.getValue();
                ++index0;
            }
            
            encoder1.encode(keys0, com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            
            {
                org.chromium.mojo.bindings.Encoder encoder2 = encoder1.encodePointerArray(values0.length, com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i1 = 0; i1 < values0.length; ++i1) {
                    
                    encoder2.encode(values0[i1], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                }
            }
        }
        
        encoder0.encode(this.traceId, 24);
        
        encoder0.encode(this.ukmSourceId, 32);
        
        encoder0.encode(this.coalesced, 40, 0);
        
        encoder0.encode(this.began, 40, 1);
        
        encoder0.encode(this.terminated, 40, 2);
        
        encoder0.encode(this.sourceEventType, 44);
        
        encoder0.encode(this.scrollUpdateDelta, 48);
        
        encoder0.encode(this.predictedScrollUpdateDelta, 52);
    }
}