
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     skia/public/interfaces/image_info.mojom
//

package com.vccorp.skia.mojom;

import com.vccorp.mojo.bindings.DeserializationException;

public final class ColorType {
    private static final boolean IS_EXTENSIBLE = false;

    public static final int UNKNOWN = 0;
    public static final int ALPHA_8 = 1; // UNKNOWN + 1
    public static final int RGB_565 = 2; // ALPHA_8 + 1
    public static final int ARGB_4444 = 3; // RGB_565 + 1
    public static final int RGBA_8888 = 4; // ARGB_4444 + 1
    public static final int BGRA_8888 = 5; // RGBA_8888 + 1
    public static final int INDEX_8 = 6; // BGRA_8888 + 1
    public static final int GRAY_8 = 7; // INDEX_8 + 1

    public static boolean isKnownValue(int value) {
        return value >= 0 && value <= 7;
    }

    public static void validate(int value) {
        if (IS_EXTENSIBLE || isKnownValue(value)) return;
        throw new DeserializationException("Invalid enum value.");
    }

    private ColorType() {}
}