
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/shape_detection/public/mojom/barcodedetection_provider.mojom
//

package com.vccorp.shape_detection.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class BarcodeDetectionProvider_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<BarcodeDetectionProvider, BarcodeDetectionProvider.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<BarcodeDetectionProvider, BarcodeDetectionProvider.Proxy>() {

        @Override
        public String getName() {
            return "shape_detection.mojom.BarcodeDetectionProvider";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, BarcodeDetectionProvider impl) {
            return new Stub(core, impl);
        }

        @Override
        public BarcodeDetectionProvider[] buildArray(int size) {
          return new BarcodeDetectionProvider[size];
        }
    };


    private static final int CREATE_BARCODE_DETECTION_ORDINAL = 0;

    private static final int ENUMERATE_SUPPORTED_FORMATS_ORDINAL = 1;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements BarcodeDetectionProvider.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void createBarcodeDetection(
com.vccorp.mojo.bindings.InterfaceRequest<BarcodeDetection> request, BarcodeDetectorOptions options) {

            BarcodeDetectionProviderCreateBarcodeDetectionParams _message = new BarcodeDetectionProviderCreateBarcodeDetectionParams();

            _message.request = request;

            _message.options = options;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(CREATE_BARCODE_DETECTION_ORDINAL)));

        }


        @Override
        public void enumerateSupportedFormats(

EnumerateSupportedFormatsResponse callback) {

            BarcodeDetectionProviderEnumerateSupportedFormatsParams _message = new BarcodeDetectionProviderEnumerateSupportedFormatsParams();


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    ENUMERATE_SUPPORTED_FORMATS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new BarcodeDetectionProviderEnumerateSupportedFormatsResponseParamsForwardToCallback(callback));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<BarcodeDetectionProvider> {

        Stub(com.vccorp.mojo.system.Core core, BarcodeDetectionProvider impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                BarcodeDetectionProvider_Internal.MANAGER, messageWithHeader);





                    case CREATE_BARCODE_DETECTION_ORDINAL: {

                        BarcodeDetectionProviderCreateBarcodeDetectionParams data =
                                BarcodeDetectionProviderCreateBarcodeDetectionParams.deserialize(messageWithHeader.getPayload());

                        getImpl().createBarcodeDetection(data.request, data.options);
                        return true;
                    }




                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), BarcodeDetectionProvider_Internal.MANAGER, messageWithHeader, receiver);









                    case ENUMERATE_SUPPORTED_FORMATS_ORDINAL: {

                        BarcodeDetectionProviderEnumerateSupportedFormatsParams.deserialize(messageWithHeader.getPayload());

                        getImpl().enumerateSupportedFormats(new BarcodeDetectionProviderEnumerateSupportedFormatsResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class BarcodeDetectionProviderCreateBarcodeDetectionParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo.bindings.InterfaceRequest<BarcodeDetection> request;
        public BarcodeDetectorOptions options;

        private BarcodeDetectionProviderCreateBarcodeDetectionParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public BarcodeDetectionProviderCreateBarcodeDetectionParams() {
            this(0);
        }

        public static BarcodeDetectionProviderCreateBarcodeDetectionParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static BarcodeDetectionProviderCreateBarcodeDetectionParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static BarcodeDetectionProviderCreateBarcodeDetectionParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            BarcodeDetectionProviderCreateBarcodeDetectionParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new BarcodeDetectionProviderCreateBarcodeDetectionParams(elementsOrVersion);
                    {
                        
                    result.request = decoder0.readInterfaceRequest(8, false);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.options = BarcodeDetectorOptions.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.request, 8, false);
            
            encoder0.encode(this.options, 16, false);
        }
    }



    
    static final class BarcodeDetectionProviderEnumerateSupportedFormatsParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private BarcodeDetectionProviderEnumerateSupportedFormatsParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public BarcodeDetectionProviderEnumerateSupportedFormatsParams() {
            this(0);
        }

        public static BarcodeDetectionProviderEnumerateSupportedFormatsParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static BarcodeDetectionProviderEnumerateSupportedFormatsParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static BarcodeDetectionProviderEnumerateSupportedFormatsParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            BarcodeDetectionProviderEnumerateSupportedFormatsParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new BarcodeDetectionProviderEnumerateSupportedFormatsParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class BarcodeDetectionProviderEnumerateSupportedFormatsResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int[] supportedFormats;

        private BarcodeDetectionProviderEnumerateSupportedFormatsResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public BarcodeDetectionProviderEnumerateSupportedFormatsResponseParams() {
            this(0);
        }

        public static BarcodeDetectionProviderEnumerateSupportedFormatsResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static BarcodeDetectionProviderEnumerateSupportedFormatsResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static BarcodeDetectionProviderEnumerateSupportedFormatsResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            BarcodeDetectionProviderEnumerateSupportedFormatsResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new BarcodeDetectionProviderEnumerateSupportedFormatsResponseParams(elementsOrVersion);
                    {
                        
                    result.supportedFormats = decoder0.readInts(8, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    {
                        for (int i0 = 0; i0 < result.supportedFormats.length; ++i0) {
                            BarcodeFormat.validate(result.supportedFormats[i0]);
                        }
                    }
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.supportedFormats, 8, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
        }
    }

    static class BarcodeDetectionProviderEnumerateSupportedFormatsResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final BarcodeDetectionProvider.EnumerateSupportedFormatsResponse mCallback;

        BarcodeDetectionProviderEnumerateSupportedFormatsResponseParamsForwardToCallback(BarcodeDetectionProvider.EnumerateSupportedFormatsResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(ENUMERATE_SUPPORTED_FORMATS_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                BarcodeDetectionProviderEnumerateSupportedFormatsResponseParams response = BarcodeDetectionProviderEnumerateSupportedFormatsResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.supportedFormats);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class BarcodeDetectionProviderEnumerateSupportedFormatsResponseParamsProxyToResponder implements BarcodeDetectionProvider.EnumerateSupportedFormatsResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        BarcodeDetectionProviderEnumerateSupportedFormatsResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(int[] supportedFormats) {
            BarcodeDetectionProviderEnumerateSupportedFormatsResponseParams _response = new BarcodeDetectionProviderEnumerateSupportedFormatsResponseParams();

            _response.supportedFormats = supportedFormats;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    ENUMERATE_SUPPORTED_FORMATS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



}
