// Copyright 2018 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

package com.vccorp.services.service_manager;

import com.vccorp.mojo.bindings.ConnectionErrorHandler;
import com.vccorp.mojo.bindings.Interface;
import com.vccorp.mojo.bindings.InterfaceRequest;
import com.vccorp.mojo.system.MessagePipeHandle;
import com.vccorp.mojo.system.MojoException;
import com.vccorp.service_manager.mojom.Identity;
import com.vccorp.service_manager.mojom.ServiceFilter;

/**
 * This class exposes the ability to bind interfaces from other services in the system.
 */
public class Connector implements ConnectionErrorHandler {
    private com.vccorp.service_manager.mojom.Connector.Proxy mConnector;

    private static class ConnectorBindInterfaceResponseImpl
            implements com.vccorp.service_manager.mojom.Connector.BindInterfaceResponse {
        @Override
        public void call(Integer result, Identity identity) {}
    }

    public Connector(MessagePipeHandle handle) {
        mConnector = com.vccorp.service_manager.mojom.Connector.MANAGER.attachProxy(handle, 0);
        mConnector.getProxyHandler().setErrorHandler(this);
    }

    /**
     * Asks a service to bind an interface request.
     *
     * @param serviceName The name of the service.
     * @param interfaceName The name of interface I.
     * @param request The request for the interface I.
     */
    public <I extends Interface, P extends Interface.Proxy> void bindInterface(
            String serviceName, String interfaceName, InterfaceRequest<I> request) {
        ServiceFilter filter = new ServiceFilter();
        filter.serviceName = serviceName;

        com.vccorp.service_manager.mojom.Connector.BindInterfaceResponse callback =
                new ConnectorBindInterfaceResponseImpl();
        mConnector.bindInterface(filter, interfaceName, request.passHandle(),
                com.vccorp.service_manager.mojom.BindInterfacePriority.IMPORTANT, callback);
    }

    @Override
    public void onConnectionError(MojoException e) {
        mConnector.close();
    }
}
