
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/proxy_resolver/public/mojom/proxy_resolver.mojom
//

package com.vccorp.proxy_resolver.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class ProxyResolverFactory_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<ProxyResolverFactory, ProxyResolverFactory.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<ProxyResolverFactory, ProxyResolverFactory.Proxy>() {

        @Override
        public String getName() {
            return "proxy_resolver.mojom.ProxyResolverFactory";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, ProxyResolverFactory impl) {
            return new Stub(core, impl);
        }

        @Override
        public ProxyResolverFactory[] buildArray(int size) {
          return new ProxyResolverFactory[size];
        }
    };


    private static final int CREATE_RESOLVER_ORDINAL = 0;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements ProxyResolverFactory.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void createResolver(
String pacScript, com.vccorp.mojo.bindings.InterfaceRequest<ProxyResolver> resolver, ProxyResolverFactoryRequestClient client) {

            ProxyResolverFactoryCreateResolverParams _message = new ProxyResolverFactoryCreateResolverParams();

            _message.pacScript = pacScript;

            _message.resolver = resolver;

            _message.client = client;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(CREATE_RESOLVER_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<ProxyResolverFactory> {

        Stub(com.vccorp.mojo.system.Core core, ProxyResolverFactory impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                ProxyResolverFactory_Internal.MANAGER, messageWithHeader);





                    case CREATE_RESOLVER_ORDINAL: {

                        ProxyResolverFactoryCreateResolverParams data =
                                ProxyResolverFactoryCreateResolverParams.deserialize(messageWithHeader.getPayload());

                        getImpl().createResolver(data.pacScript, data.resolver, data.client);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), ProxyResolverFactory_Internal.MANAGER, messageWithHeader, receiver);




                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class ProxyResolverFactoryCreateResolverParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String pacScript;
        public com.vccorp.mojo.bindings.InterfaceRequest<ProxyResolver> resolver;
        public ProxyResolverFactoryRequestClient client;

        private ProxyResolverFactoryCreateResolverParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ProxyResolverFactoryCreateResolverParams() {
            this(0);
        }

        public static ProxyResolverFactoryCreateResolverParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ProxyResolverFactoryCreateResolverParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ProxyResolverFactoryCreateResolverParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ProxyResolverFactoryCreateResolverParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ProxyResolverFactoryCreateResolverParams(elementsOrVersion);
                    {
                        
                    result.pacScript = decoder0.readString(8, false);
                    }
                    {
                        
                    result.resolver = decoder0.readInterfaceRequest(16, false);
                    }
                    {
                        
                    result.client = decoder0.readServiceInterface(20, false, ProxyResolverFactoryRequestClient.MANAGER);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.pacScript, 8, false);
            
            encoder0.encode(this.resolver, 16, false);
            
            encoder0.encode(this.client, 20, false, ProxyResolverFactoryRequestClient.MANAGER);
        }
    }



}
