
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/payments/payment_app.mojom
//

package com.vccorp.payments.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class PaymentHandlerResponseCallback_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<PaymentHandlerResponseCallback, PaymentHandlerResponseCallback.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<PaymentHandlerResponseCallback, PaymentHandlerResponseCallback.Proxy>() {

        @Override
        public String getName() {
            return "payments.mojom.PaymentHandlerResponseCallback";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, PaymentHandlerResponseCallback impl) {
            return new Stub(core, impl);
        }

        @Override
        public PaymentHandlerResponseCallback[] buildArray(int size) {
          return new PaymentHandlerResponseCallback[size];
        }
    };


    private static final int ON_RESPONSE_FOR_ABORT_PAYMENT_ORDINAL = 0;

    private static final int ON_RESPONSE_FOR_CAN_MAKE_PAYMENT_ORDINAL = 1;

    private static final int ON_RESPONSE_FOR_PAYMENT_REQUEST_ORDINAL = 2;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements PaymentHandlerResponseCallback.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void onResponseForAbortPayment(
boolean paymentAborted) {

            PaymentHandlerResponseCallbackOnResponseForAbortPaymentParams _message = new PaymentHandlerResponseCallbackOnResponseForAbortPaymentParams();

            _message.paymentAborted = paymentAborted;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_RESPONSE_FOR_ABORT_PAYMENT_ORDINAL)));

        }


        @Override
        public void onResponseForCanMakePayment(
boolean canMakePayment) {

            PaymentHandlerResponseCallbackOnResponseForCanMakePaymentParams _message = new PaymentHandlerResponseCallbackOnResponseForCanMakePaymentParams();

            _message.canMakePayment = canMakePayment;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_RESPONSE_FOR_CAN_MAKE_PAYMENT_ORDINAL)));

        }


        @Override
        public void onResponseForPaymentRequest(
PaymentHandlerResponse response) {

            PaymentHandlerResponseCallbackOnResponseForPaymentRequestParams _message = new PaymentHandlerResponseCallbackOnResponseForPaymentRequestParams();

            _message.response = response;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_RESPONSE_FOR_PAYMENT_REQUEST_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<PaymentHandlerResponseCallback> {

        Stub(com.vccorp.mojo.system.Core core, PaymentHandlerResponseCallback impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                PaymentHandlerResponseCallback_Internal.MANAGER, messageWithHeader);





                    case ON_RESPONSE_FOR_ABORT_PAYMENT_ORDINAL: {

                        PaymentHandlerResponseCallbackOnResponseForAbortPaymentParams data =
                                PaymentHandlerResponseCallbackOnResponseForAbortPaymentParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onResponseForAbortPayment(data.paymentAborted);
                        return true;
                    }





                    case ON_RESPONSE_FOR_CAN_MAKE_PAYMENT_ORDINAL: {

                        PaymentHandlerResponseCallbackOnResponseForCanMakePaymentParams data =
                                PaymentHandlerResponseCallbackOnResponseForCanMakePaymentParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onResponseForCanMakePayment(data.canMakePayment);
                        return true;
                    }





                    case ON_RESPONSE_FOR_PAYMENT_REQUEST_ORDINAL: {

                        PaymentHandlerResponseCallbackOnResponseForPaymentRequestParams data =
                                PaymentHandlerResponseCallbackOnResponseForPaymentRequestParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onResponseForPaymentRequest(data.response);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), PaymentHandlerResponseCallback_Internal.MANAGER, messageWithHeader, receiver);








                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class PaymentHandlerResponseCallbackOnResponseForAbortPaymentParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean paymentAborted;

        private PaymentHandlerResponseCallbackOnResponseForAbortPaymentParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PaymentHandlerResponseCallbackOnResponseForAbortPaymentParams() {
            this(0);
        }

        public static PaymentHandlerResponseCallbackOnResponseForAbortPaymentParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PaymentHandlerResponseCallbackOnResponseForAbortPaymentParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PaymentHandlerResponseCallbackOnResponseForAbortPaymentParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PaymentHandlerResponseCallbackOnResponseForAbortPaymentParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PaymentHandlerResponseCallbackOnResponseForAbortPaymentParams(elementsOrVersion);
                    {
                        
                    result.paymentAborted = decoder0.readBoolean(8, 0);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.paymentAborted, 8, 0);
        }
    }



    
    static final class PaymentHandlerResponseCallbackOnResponseForCanMakePaymentParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean canMakePayment;

        private PaymentHandlerResponseCallbackOnResponseForCanMakePaymentParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PaymentHandlerResponseCallbackOnResponseForCanMakePaymentParams() {
            this(0);
        }

        public static PaymentHandlerResponseCallbackOnResponseForCanMakePaymentParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PaymentHandlerResponseCallbackOnResponseForCanMakePaymentParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PaymentHandlerResponseCallbackOnResponseForCanMakePaymentParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PaymentHandlerResponseCallbackOnResponseForCanMakePaymentParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PaymentHandlerResponseCallbackOnResponseForCanMakePaymentParams(elementsOrVersion);
                    {
                        
                    result.canMakePayment = decoder0.readBoolean(8, 0);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.canMakePayment, 8, 0);
        }
    }



    
    static final class PaymentHandlerResponseCallbackOnResponseForPaymentRequestParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public PaymentHandlerResponse response;

        private PaymentHandlerResponseCallbackOnResponseForPaymentRequestParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PaymentHandlerResponseCallbackOnResponseForPaymentRequestParams() {
            this(0);
        }

        public static PaymentHandlerResponseCallbackOnResponseForPaymentRequestParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PaymentHandlerResponseCallbackOnResponseForPaymentRequestParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PaymentHandlerResponseCallbackOnResponseForPaymentRequestParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PaymentHandlerResponseCallbackOnResponseForPaymentRequestParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PaymentHandlerResponseCallbackOnResponseForPaymentRequestParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.response = PaymentHandlerResponse.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.response, 8, false);
        }
    }



}
