
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/network/public/mojom/websocket.mojom
//

package com.vccorp.network.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class WebSocketClient_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<WebSocketClient, WebSocketClient.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<WebSocketClient, WebSocketClient.Proxy>() {

        @Override
        public String getName() {
            return "network.mojom.WebSocketClient";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, WebSocketClient impl) {
            return new Stub(core, impl);
        }

        @Override
        public WebSocketClient[] buildArray(int size) {
          return new WebSocketClient[size];
        }
    };


    private static final int ON_FAIL_CHANNEL_ORDINAL = 0;

    private static final int ON_START_OPENING_HANDSHAKE_ORDINAL = 1;

    private static final int ON_FINISH_OPENING_HANDSHAKE_ORDINAL = 2;

    private static final int ON_ADD_CHANNEL_RESPONSE_ORDINAL = 3;

    private static final int ON_DATA_FRAME_ORDINAL = 4;

    private static final int ON_FLOW_CONTROL_ORDINAL = 5;

    private static final int ON_DROP_CHANNEL_ORDINAL = 6;

    private static final int ON_CLOSING_HANDSHAKE_ORDINAL = 7;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements WebSocketClient.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void onFailChannel(
String reason) {

            WebSocketClientOnFailChannelParams _message = new WebSocketClientOnFailChannelParams();

            _message.reason = reason;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_FAIL_CHANNEL_ORDINAL)));

        }


        @Override
        public void onStartOpeningHandshake(
WebSocketHandshakeRequest request) {

            WebSocketClientOnStartOpeningHandshakeParams _message = new WebSocketClientOnStartOpeningHandshakeParams();

            _message.request = request;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_START_OPENING_HANDSHAKE_ORDINAL)));

        }


        @Override
        public void onFinishOpeningHandshake(
WebSocketHandshakeResponse response) {

            WebSocketClientOnFinishOpeningHandshakeParams _message = new WebSocketClientOnFinishOpeningHandshakeParams();

            _message.response = response;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_FINISH_OPENING_HANDSHAKE_ORDINAL)));

        }


        @Override
        public void onAddChannelResponse(
String selectedProtocol, String extensions) {

            WebSocketClientOnAddChannelResponseParams _message = new WebSocketClientOnAddChannelResponseParams();

            _message.selectedProtocol = selectedProtocol;

            _message.extensions = extensions;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_ADD_CHANNEL_RESPONSE_ORDINAL)));

        }


        @Override
        public void onDataFrame(
boolean fin, int type, byte[] data) {

            WebSocketClientOnDataFrameParams _message = new WebSocketClientOnDataFrameParams();

            _message.fin = fin;

            _message.type = type;

            _message.data = data;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_DATA_FRAME_ORDINAL)));

        }


        @Override
        public void onFlowControl(
long quota) {

            WebSocketClientOnFlowControlParams _message = new WebSocketClientOnFlowControlParams();

            _message.quota = quota;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_FLOW_CONTROL_ORDINAL)));

        }


        @Override
        public void onDropChannel(
boolean wasClean, short code, String reason) {

            WebSocketClientOnDropChannelParams _message = new WebSocketClientOnDropChannelParams();

            _message.wasClean = wasClean;

            _message.code = code;

            _message.reason = reason;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_DROP_CHANNEL_ORDINAL)));

        }


        @Override
        public void onClosingHandshake(
) {

            WebSocketClientOnClosingHandshakeParams _message = new WebSocketClientOnClosingHandshakeParams();


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_CLOSING_HANDSHAKE_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<WebSocketClient> {

        Stub(com.vccorp.mojo.system.Core core, WebSocketClient impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                WebSocketClient_Internal.MANAGER, messageWithHeader);





                    case ON_FAIL_CHANNEL_ORDINAL: {

                        WebSocketClientOnFailChannelParams data =
                                WebSocketClientOnFailChannelParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onFailChannel(data.reason);
                        return true;
                    }





                    case ON_START_OPENING_HANDSHAKE_ORDINAL: {

                        WebSocketClientOnStartOpeningHandshakeParams data =
                                WebSocketClientOnStartOpeningHandshakeParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onStartOpeningHandshake(data.request);
                        return true;
                    }





                    case ON_FINISH_OPENING_HANDSHAKE_ORDINAL: {

                        WebSocketClientOnFinishOpeningHandshakeParams data =
                                WebSocketClientOnFinishOpeningHandshakeParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onFinishOpeningHandshake(data.response);
                        return true;
                    }





                    case ON_ADD_CHANNEL_RESPONSE_ORDINAL: {

                        WebSocketClientOnAddChannelResponseParams data =
                                WebSocketClientOnAddChannelResponseParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onAddChannelResponse(data.selectedProtocol, data.extensions);
                        return true;
                    }





                    case ON_DATA_FRAME_ORDINAL: {

                        WebSocketClientOnDataFrameParams data =
                                WebSocketClientOnDataFrameParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onDataFrame(data.fin, data.type, data.data);
                        return true;
                    }





                    case ON_FLOW_CONTROL_ORDINAL: {

                        WebSocketClientOnFlowControlParams data =
                                WebSocketClientOnFlowControlParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onFlowControl(data.quota);
                        return true;
                    }





                    case ON_DROP_CHANNEL_ORDINAL: {

                        WebSocketClientOnDropChannelParams data =
                                WebSocketClientOnDropChannelParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onDropChannel(data.wasClean, data.code, data.reason);
                        return true;
                    }





                    case ON_CLOSING_HANDSHAKE_ORDINAL: {

                        WebSocketClientOnClosingHandshakeParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onClosingHandshake();
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), WebSocketClient_Internal.MANAGER, messageWithHeader, receiver);


















                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class WebSocketClientOnFailChannelParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String reason;

        private WebSocketClientOnFailChannelParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public WebSocketClientOnFailChannelParams() {
            this(0);
        }

        public static WebSocketClientOnFailChannelParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static WebSocketClientOnFailChannelParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static WebSocketClientOnFailChannelParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            WebSocketClientOnFailChannelParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new WebSocketClientOnFailChannelParams(elementsOrVersion);
                    {
                        
                    result.reason = decoder0.readString(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.reason, 8, false);
        }
    }



    
    static final class WebSocketClientOnStartOpeningHandshakeParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public WebSocketHandshakeRequest request;

        private WebSocketClientOnStartOpeningHandshakeParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public WebSocketClientOnStartOpeningHandshakeParams() {
            this(0);
        }

        public static WebSocketClientOnStartOpeningHandshakeParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static WebSocketClientOnStartOpeningHandshakeParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static WebSocketClientOnStartOpeningHandshakeParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            WebSocketClientOnStartOpeningHandshakeParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new WebSocketClientOnStartOpeningHandshakeParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.request = WebSocketHandshakeRequest.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.request, 8, false);
        }
    }



    
    static final class WebSocketClientOnFinishOpeningHandshakeParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public WebSocketHandshakeResponse response;

        private WebSocketClientOnFinishOpeningHandshakeParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public WebSocketClientOnFinishOpeningHandshakeParams() {
            this(0);
        }

        public static WebSocketClientOnFinishOpeningHandshakeParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static WebSocketClientOnFinishOpeningHandshakeParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static WebSocketClientOnFinishOpeningHandshakeParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            WebSocketClientOnFinishOpeningHandshakeParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new WebSocketClientOnFinishOpeningHandshakeParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.response = WebSocketHandshakeResponse.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.response, 8, false);
        }
    }



    
    static final class WebSocketClientOnAddChannelResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String selectedProtocol;
        public String extensions;

        private WebSocketClientOnAddChannelResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public WebSocketClientOnAddChannelResponseParams() {
            this(0);
        }

        public static WebSocketClientOnAddChannelResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static WebSocketClientOnAddChannelResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static WebSocketClientOnAddChannelResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            WebSocketClientOnAddChannelResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new WebSocketClientOnAddChannelResponseParams(elementsOrVersion);
                    {
                        
                    result.selectedProtocol = decoder0.readString(8, false);
                    }
                    {
                        
                    result.extensions = decoder0.readString(16, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.selectedProtocol, 8, false);
            
            encoder0.encode(this.extensions, 16, false);
        }
    }



    
    static final class WebSocketClientOnDataFrameParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean fin;
        public int type;
        public byte[] data;

        private WebSocketClientOnDataFrameParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public WebSocketClientOnDataFrameParams() {
            this(0);
        }

        public static WebSocketClientOnDataFrameParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static WebSocketClientOnDataFrameParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static WebSocketClientOnDataFrameParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            WebSocketClientOnDataFrameParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new WebSocketClientOnDataFrameParams(elementsOrVersion);
                    {
                        
                    result.fin = decoder0.readBoolean(8, 0);
                    }
                    {
                        
                    result.type = decoder0.readInt(12);
                        WebSocketMessageType.validate(result.type);
                    }
                    {
                        
                    result.data = decoder0.readBytes(16, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.fin, 8, 0);
            
            encoder0.encode(this.type, 12);
            
            encoder0.encode(this.data, 16, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
        }
    }



    
    static final class WebSocketClientOnFlowControlParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public long quota;

        private WebSocketClientOnFlowControlParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public WebSocketClientOnFlowControlParams() {
            this(0);
        }

        public static WebSocketClientOnFlowControlParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static WebSocketClientOnFlowControlParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static WebSocketClientOnFlowControlParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            WebSocketClientOnFlowControlParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new WebSocketClientOnFlowControlParams(elementsOrVersion);
                    {
                        
                    result.quota = decoder0.readLong(8);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.quota, 8);
        }
    }



    
    static final class WebSocketClientOnDropChannelParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean wasClean;
        public short code;
        public String reason;

        private WebSocketClientOnDropChannelParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public WebSocketClientOnDropChannelParams() {
            this(0);
        }

        public static WebSocketClientOnDropChannelParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static WebSocketClientOnDropChannelParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static WebSocketClientOnDropChannelParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            WebSocketClientOnDropChannelParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new WebSocketClientOnDropChannelParams(elementsOrVersion);
                    {
                        
                    result.wasClean = decoder0.readBoolean(8, 0);
                    }
                    {
                        
                    result.code = decoder0.readShort(10);
                    }
                    {
                        
                    result.reason = decoder0.readString(16, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.wasClean, 8, 0);
            
            encoder0.encode(this.code, 10);
            
            encoder0.encode(this.reason, 16, false);
        }
    }



    
    static final class WebSocketClientOnClosingHandshakeParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private WebSocketClientOnClosingHandshakeParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public WebSocketClientOnClosingHandshakeParams() {
            this(0);
        }

        public static WebSocketClientOnClosingHandshakeParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static WebSocketClientOnClosingHandshakeParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static WebSocketClientOnClosingHandshakeParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            WebSocketClientOnClosingHandshakeParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new WebSocketClientOnClosingHandshakeParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



}
