
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/network/public/mojom/tcp_socket.mojom
//

package com.vccorp.network.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class TcpConnectedSocket_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<TcpConnectedSocket, TcpConnectedSocket.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<TcpConnectedSocket, TcpConnectedSocket.Proxy>() {

        @Override
        public String getName() {
            return "network.mojom.TCPConnectedSocket";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, TcpConnectedSocket impl) {
            return new Stub(core, impl);
        }

        @Override
        public TcpConnectedSocket[] buildArray(int size) {
          return new TcpConnectedSocket[size];
        }
    };


    private static final int UPGRADE_TO_TLS_ORDINAL = 0;

    private static final int SET_SEND_BUFFER_SIZE_ORDINAL = 1;

    private static final int SET_RECEIVE_BUFFER_SIZE_ORDINAL = 2;

    private static final int SET_NO_DELAY_ORDINAL = 3;

    private static final int SET_KEEP_ALIVE_ORDINAL = 4;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements TcpConnectedSocket.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void upgradeToTls(
HostPortPair hostPortPair, TlsClientSocketOptions options, MutableNetworkTrafficAnnotationTag trafficAnnotation, com.vccorp.mojo.bindings.InterfaceRequest<TlsClientSocket> request, SocketObserver observer,
UpgradeToTlsResponse callback) {

            TcpConnectedSocketUpgradeToTlsParams _message = new TcpConnectedSocketUpgradeToTlsParams();

            _message.hostPortPair = hostPortPair;

            _message.options = options;

            _message.trafficAnnotation = trafficAnnotation;

            _message.request = request;

            _message.observer = observer;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    UPGRADE_TO_TLS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new TcpConnectedSocketUpgradeToTlsResponseParamsForwardToCallback(callback));

        }


        @Override
        public void setSendBufferSize(
int sendBufferSize, 
SetSendBufferSizeResponse callback) {

            TcpConnectedSocketSetSendBufferSizeParams _message = new TcpConnectedSocketSetSendBufferSizeParams();

            _message.sendBufferSize = sendBufferSize;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    SET_SEND_BUFFER_SIZE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new TcpConnectedSocketSetSendBufferSizeResponseParamsForwardToCallback(callback));

        }


        @Override
        public void setReceiveBufferSize(
int receiveBufferSize, 
SetReceiveBufferSizeResponse callback) {

            TcpConnectedSocketSetReceiveBufferSizeParams _message = new TcpConnectedSocketSetReceiveBufferSizeParams();

            _message.receiveBufferSize = receiveBufferSize;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    SET_RECEIVE_BUFFER_SIZE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new TcpConnectedSocketSetReceiveBufferSizeResponseParamsForwardToCallback(callback));

        }


        @Override
        public void setNoDelay(
boolean noDelay, 
SetNoDelayResponse callback) {

            TcpConnectedSocketSetNoDelayParams _message = new TcpConnectedSocketSetNoDelayParams();

            _message.noDelay = noDelay;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    SET_NO_DELAY_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new TcpConnectedSocketSetNoDelayResponseParamsForwardToCallback(callback));

        }


        @Override
        public void setKeepAlive(
boolean enable, int delaySecs, 
SetKeepAliveResponse callback) {

            TcpConnectedSocketSetKeepAliveParams _message = new TcpConnectedSocketSetKeepAliveParams();

            _message.enable = enable;

            _message.delaySecs = delaySecs;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    SET_KEEP_ALIVE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new TcpConnectedSocketSetKeepAliveResponseParamsForwardToCallback(callback));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<TcpConnectedSocket> {

        Stub(com.vccorp.mojo.system.Core core, TcpConnectedSocket impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                TcpConnectedSocket_Internal.MANAGER, messageWithHeader);












                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), TcpConnectedSocket_Internal.MANAGER, messageWithHeader, receiver);







                    case UPGRADE_TO_TLS_ORDINAL: {

                        TcpConnectedSocketUpgradeToTlsParams data =
                                TcpConnectedSocketUpgradeToTlsParams.deserialize(messageWithHeader.getPayload());

                        getImpl().upgradeToTls(data.hostPortPair, data.options, data.trafficAnnotation, data.request, data.observer, new TcpConnectedSocketUpgradeToTlsResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case SET_SEND_BUFFER_SIZE_ORDINAL: {

                        TcpConnectedSocketSetSendBufferSizeParams data =
                                TcpConnectedSocketSetSendBufferSizeParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setSendBufferSize(data.sendBufferSize, new TcpConnectedSocketSetSendBufferSizeResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case SET_RECEIVE_BUFFER_SIZE_ORDINAL: {

                        TcpConnectedSocketSetReceiveBufferSizeParams data =
                                TcpConnectedSocketSetReceiveBufferSizeParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setReceiveBufferSize(data.receiveBufferSize, new TcpConnectedSocketSetReceiveBufferSizeResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case SET_NO_DELAY_ORDINAL: {

                        TcpConnectedSocketSetNoDelayParams data =
                                TcpConnectedSocketSetNoDelayParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setNoDelay(data.noDelay, new TcpConnectedSocketSetNoDelayResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case SET_KEEP_ALIVE_ORDINAL: {

                        TcpConnectedSocketSetKeepAliveParams data =
                                TcpConnectedSocketSetKeepAliveParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setKeepAlive(data.enable, data.delaySecs, new TcpConnectedSocketSetKeepAliveResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class TcpConnectedSocketUpgradeToTlsParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 48;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(48, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public HostPortPair hostPortPair;
        public TlsClientSocketOptions options;
        public MutableNetworkTrafficAnnotationTag trafficAnnotation;
        public com.vccorp.mojo.bindings.InterfaceRequest<TlsClientSocket> request;
        public SocketObserver observer;

        private TcpConnectedSocketUpgradeToTlsParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public TcpConnectedSocketUpgradeToTlsParams() {
            this(0);
        }

        public static TcpConnectedSocketUpgradeToTlsParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static TcpConnectedSocketUpgradeToTlsParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static TcpConnectedSocketUpgradeToTlsParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            TcpConnectedSocketUpgradeToTlsParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new TcpConnectedSocketUpgradeToTlsParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.hostPortPair = HostPortPair.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, true);
                    result.options = TlsClientSocketOptions.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                    result.trafficAnnotation = MutableNetworkTrafficAnnotationTag.decode(decoder1);
                    }
                    {
                        
                    result.request = decoder0.readInterfaceRequest(32, false);
                    }
                    {
                        
                    result.observer = decoder0.readServiceInterface(36, true, SocketObserver.MANAGER);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.hostPortPair, 8, false);
            
            encoder0.encode(this.options, 16, true);
            
            encoder0.encode(this.trafficAnnotation, 24, false);
            
            encoder0.encode(this.request, 32, false);
            
            encoder0.encode(this.observer, 36, true, SocketObserver.MANAGER);
        }
    }



    
    static final class TcpConnectedSocketUpgradeToTlsResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int netError;
        public com.vccorp.mojo.system.DataPipe.ConsumerHandle receiveStream;
        public com.vccorp.mojo.system.DataPipe.ProducerHandle sendStream;
        public SslInfo sslInfo;

        private TcpConnectedSocketUpgradeToTlsResponseParams(int version) {
            super(STRUCT_SIZE, version);
            this.receiveStream = com.vccorp.mojo.system.InvalidHandle.INSTANCE;
            this.sendStream = com.vccorp.mojo.system.InvalidHandle.INSTANCE;
        }

        public TcpConnectedSocketUpgradeToTlsResponseParams() {
            this(0);
        }

        public static TcpConnectedSocketUpgradeToTlsResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static TcpConnectedSocketUpgradeToTlsResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static TcpConnectedSocketUpgradeToTlsResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            TcpConnectedSocketUpgradeToTlsResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new TcpConnectedSocketUpgradeToTlsResponseParams(elementsOrVersion);
                    {
                        
                    result.netError = decoder0.readInt(8);
                    }
                    {
                        
                    result.receiveStream = decoder0.readConsumerHandle(12, true);
                    }
                    {
                        
                    result.sendStream = decoder0.readProducerHandle(16, true);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, true);
                    result.sslInfo = SslInfo.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.netError, 8);
            
            encoder0.encode(this.receiveStream, 12, true);
            
            encoder0.encode(this.sendStream, 16, true);
            
            encoder0.encode(this.sslInfo, 24, true);
        }
    }

    static class TcpConnectedSocketUpgradeToTlsResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final TcpConnectedSocket.UpgradeToTlsResponse mCallback;

        TcpConnectedSocketUpgradeToTlsResponseParamsForwardToCallback(TcpConnectedSocket.UpgradeToTlsResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(UPGRADE_TO_TLS_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                TcpConnectedSocketUpgradeToTlsResponseParams response = TcpConnectedSocketUpgradeToTlsResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.netError, response.receiveStream, response.sendStream, response.sslInfo);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class TcpConnectedSocketUpgradeToTlsResponseParamsProxyToResponder implements TcpConnectedSocket.UpgradeToTlsResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        TcpConnectedSocketUpgradeToTlsResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer netError, com.vccorp.mojo.system.DataPipe.ConsumerHandle receiveStream, com.vccorp.mojo.system.DataPipe.ProducerHandle sendStream, SslInfo sslInfo) {
            TcpConnectedSocketUpgradeToTlsResponseParams _response = new TcpConnectedSocketUpgradeToTlsResponseParams();

            _response.netError = netError;

            _response.receiveStream = receiveStream;

            _response.sendStream = sendStream;

            _response.sslInfo = sslInfo;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    UPGRADE_TO_TLS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class TcpConnectedSocketSetSendBufferSizeParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int sendBufferSize;

        private TcpConnectedSocketSetSendBufferSizeParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public TcpConnectedSocketSetSendBufferSizeParams() {
            this(0);
        }

        public static TcpConnectedSocketSetSendBufferSizeParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static TcpConnectedSocketSetSendBufferSizeParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static TcpConnectedSocketSetSendBufferSizeParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            TcpConnectedSocketSetSendBufferSizeParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new TcpConnectedSocketSetSendBufferSizeParams(elementsOrVersion);
                    {
                        
                    result.sendBufferSize = decoder0.readInt(8);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.sendBufferSize, 8);
        }
    }



    
    static final class TcpConnectedSocketSetSendBufferSizeResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int netError;

        private TcpConnectedSocketSetSendBufferSizeResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public TcpConnectedSocketSetSendBufferSizeResponseParams() {
            this(0);
        }

        public static TcpConnectedSocketSetSendBufferSizeResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static TcpConnectedSocketSetSendBufferSizeResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static TcpConnectedSocketSetSendBufferSizeResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            TcpConnectedSocketSetSendBufferSizeResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new TcpConnectedSocketSetSendBufferSizeResponseParams(elementsOrVersion);
                    {
                        
                    result.netError = decoder0.readInt(8);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.netError, 8);
        }
    }

    static class TcpConnectedSocketSetSendBufferSizeResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final TcpConnectedSocket.SetSendBufferSizeResponse mCallback;

        TcpConnectedSocketSetSendBufferSizeResponseParamsForwardToCallback(TcpConnectedSocket.SetSendBufferSizeResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(SET_SEND_BUFFER_SIZE_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                TcpConnectedSocketSetSendBufferSizeResponseParams response = TcpConnectedSocketSetSendBufferSizeResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.netError);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class TcpConnectedSocketSetSendBufferSizeResponseParamsProxyToResponder implements TcpConnectedSocket.SetSendBufferSizeResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        TcpConnectedSocketSetSendBufferSizeResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer netError) {
            TcpConnectedSocketSetSendBufferSizeResponseParams _response = new TcpConnectedSocketSetSendBufferSizeResponseParams();

            _response.netError = netError;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    SET_SEND_BUFFER_SIZE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class TcpConnectedSocketSetReceiveBufferSizeParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int receiveBufferSize;

        private TcpConnectedSocketSetReceiveBufferSizeParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public TcpConnectedSocketSetReceiveBufferSizeParams() {
            this(0);
        }

        public static TcpConnectedSocketSetReceiveBufferSizeParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static TcpConnectedSocketSetReceiveBufferSizeParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static TcpConnectedSocketSetReceiveBufferSizeParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            TcpConnectedSocketSetReceiveBufferSizeParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new TcpConnectedSocketSetReceiveBufferSizeParams(elementsOrVersion);
                    {
                        
                    result.receiveBufferSize = decoder0.readInt(8);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.receiveBufferSize, 8);
        }
    }



    
    static final class TcpConnectedSocketSetReceiveBufferSizeResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int netError;

        private TcpConnectedSocketSetReceiveBufferSizeResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public TcpConnectedSocketSetReceiveBufferSizeResponseParams() {
            this(0);
        }

        public static TcpConnectedSocketSetReceiveBufferSizeResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static TcpConnectedSocketSetReceiveBufferSizeResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static TcpConnectedSocketSetReceiveBufferSizeResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            TcpConnectedSocketSetReceiveBufferSizeResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new TcpConnectedSocketSetReceiveBufferSizeResponseParams(elementsOrVersion);
                    {
                        
                    result.netError = decoder0.readInt(8);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.netError, 8);
        }
    }

    static class TcpConnectedSocketSetReceiveBufferSizeResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final TcpConnectedSocket.SetReceiveBufferSizeResponse mCallback;

        TcpConnectedSocketSetReceiveBufferSizeResponseParamsForwardToCallback(TcpConnectedSocket.SetReceiveBufferSizeResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(SET_RECEIVE_BUFFER_SIZE_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                TcpConnectedSocketSetReceiveBufferSizeResponseParams response = TcpConnectedSocketSetReceiveBufferSizeResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.netError);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class TcpConnectedSocketSetReceiveBufferSizeResponseParamsProxyToResponder implements TcpConnectedSocket.SetReceiveBufferSizeResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        TcpConnectedSocketSetReceiveBufferSizeResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer netError) {
            TcpConnectedSocketSetReceiveBufferSizeResponseParams _response = new TcpConnectedSocketSetReceiveBufferSizeResponseParams();

            _response.netError = netError;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    SET_RECEIVE_BUFFER_SIZE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class TcpConnectedSocketSetNoDelayParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean noDelay;

        private TcpConnectedSocketSetNoDelayParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public TcpConnectedSocketSetNoDelayParams() {
            this(0);
        }

        public static TcpConnectedSocketSetNoDelayParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static TcpConnectedSocketSetNoDelayParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static TcpConnectedSocketSetNoDelayParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            TcpConnectedSocketSetNoDelayParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new TcpConnectedSocketSetNoDelayParams(elementsOrVersion);
                    {
                        
                    result.noDelay = decoder0.readBoolean(8, 0);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.noDelay, 8, 0);
        }
    }



    
    static final class TcpConnectedSocketSetNoDelayResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean success;

        private TcpConnectedSocketSetNoDelayResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public TcpConnectedSocketSetNoDelayResponseParams() {
            this(0);
        }

        public static TcpConnectedSocketSetNoDelayResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static TcpConnectedSocketSetNoDelayResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static TcpConnectedSocketSetNoDelayResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            TcpConnectedSocketSetNoDelayResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new TcpConnectedSocketSetNoDelayResponseParams(elementsOrVersion);
                    {
                        
                    result.success = decoder0.readBoolean(8, 0);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.success, 8, 0);
        }
    }

    static class TcpConnectedSocketSetNoDelayResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final TcpConnectedSocket.SetNoDelayResponse mCallback;

        TcpConnectedSocketSetNoDelayResponseParamsForwardToCallback(TcpConnectedSocket.SetNoDelayResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(SET_NO_DELAY_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                TcpConnectedSocketSetNoDelayResponseParams response = TcpConnectedSocketSetNoDelayResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.success);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class TcpConnectedSocketSetNoDelayResponseParamsProxyToResponder implements TcpConnectedSocket.SetNoDelayResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        TcpConnectedSocketSetNoDelayResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Boolean success) {
            TcpConnectedSocketSetNoDelayResponseParams _response = new TcpConnectedSocketSetNoDelayResponseParams();

            _response.success = success;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    SET_NO_DELAY_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class TcpConnectedSocketSetKeepAliveParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean enable;
        public int delaySecs;

        private TcpConnectedSocketSetKeepAliveParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public TcpConnectedSocketSetKeepAliveParams() {
            this(0);
        }

        public static TcpConnectedSocketSetKeepAliveParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static TcpConnectedSocketSetKeepAliveParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static TcpConnectedSocketSetKeepAliveParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            TcpConnectedSocketSetKeepAliveParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new TcpConnectedSocketSetKeepAliveParams(elementsOrVersion);
                    {
                        
                    result.enable = decoder0.readBoolean(8, 0);
                    }
                    {
                        
                    result.delaySecs = decoder0.readInt(12);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.enable, 8, 0);
            
            encoder0.encode(this.delaySecs, 12);
        }
    }



    
    static final class TcpConnectedSocketSetKeepAliveResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean success;

        private TcpConnectedSocketSetKeepAliveResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public TcpConnectedSocketSetKeepAliveResponseParams() {
            this(0);
        }

        public static TcpConnectedSocketSetKeepAliveResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static TcpConnectedSocketSetKeepAliveResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static TcpConnectedSocketSetKeepAliveResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            TcpConnectedSocketSetKeepAliveResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new TcpConnectedSocketSetKeepAliveResponseParams(elementsOrVersion);
                    {
                        
                    result.success = decoder0.readBoolean(8, 0);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.success, 8, 0);
        }
    }

    static class TcpConnectedSocketSetKeepAliveResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final TcpConnectedSocket.SetKeepAliveResponse mCallback;

        TcpConnectedSocketSetKeepAliveResponseParamsForwardToCallback(TcpConnectedSocket.SetKeepAliveResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(SET_KEEP_ALIVE_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                TcpConnectedSocketSetKeepAliveResponseParams response = TcpConnectedSocketSetKeepAliveResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.success);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class TcpConnectedSocketSetKeepAliveResponseParamsProxyToResponder implements TcpConnectedSocket.SetKeepAliveResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        TcpConnectedSocketSetKeepAliveResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Boolean success) {
            TcpConnectedSocketSetKeepAliveResponseParams _response = new TcpConnectedSocketSetKeepAliveResponseParams();

            _response.success = success;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    SET_KEEP_ALIVE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



}
